/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.values.Array;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Assert;
import org.junit.Test;

public class IndexForIDTest
extends QueueTestCommon {
    private int count;
    private String staged;

    private static void applyFlyweight(Facade datum, long datumSize, DocumentContext dc) {
        Wire wire = dc.wire();
        Bytes bytes = wire.bytes();
        datum.bytesStore((BytesStore)bytes, bytes.readPosition(), datumSize);
    }

    void producer() {
        try {
            Facade datum = (Facade)Values.newNativeReference(Facade.class);
            long datumSize = datum.maxSize();
            Assert.assertEquals((long)256L, (long)datumSize);
            Thread pretoucher = new Thread(() -> {
                try (ChronicleQueue queue = ChronicleQueue.single((String)this.staged);
                     ExcerptAppender appender0 = queue.acquireAppender();){
                    while (!Thread.currentThread().isInterrupted()) {
                        appender0.pretouch();
                        Jvm.pause((long)10L);
                    }
                }
            });
            pretoucher.setDaemon(true);
            pretoucher.start();
            try (ChronicleQueue queue = ChronicleQueue.single((String)this.staged);
                 ExcerptAppender appender = queue.acquireAppender();
                 LongValue value = queue.indexForId("producer");){
                value.setOrderedValue(Long.MAX_VALUE);
                for (int i = 0; i < this.count; ++i) {
                    try (DocumentContext dc = appender.writingDocument();){
                        Wire wire = dc.wire();
                        Bytes bytes = wire.bytes();
                        datum.bytesStore((BytesStore)bytes, bytes.writePosition(), datumSize);
                        bytes.writeSkip(datumSize);
                        datum.setProducerTime(System.nanoTime());
                        continue;
                    }
                }
                pretoucher.interrupt();
                try {
                    pretoucher.join(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    void first() {
        this.copy("producer", Facade::setFirstTime, "first");
    }

    void mid() {
        this.copy("first", Facade::setMidTime, "mid");
    }

    void end() {
        this.copy("mid", Facade::setEndTime, "end");
    }

    private void copy(String fromID, TimeSetter setTime, String toID) {
        Facade datum = (Facade)Values.newNativeReference(Facade.class);
        long datumSize = datum.maxSize();
        long end = System.currentTimeMillis() + (long)(Jvm.isCodeCoverage() ? 90000 : 60000);
        try (ChronicleQueue queue = ChronicleQueue.single((String)this.staged);
             ExcerptTailer tailer = queue.createTailer();
             LongValue fromIndex = queue.indexForId(fromID);
             LongValue toIndex = queue.indexForId(toID);){
            for (int i = 0; i < this.count; ++i) {
                try (DocumentContext dc = tailer.readingDocument();){
                    if (!dc.isPresent()) {
                        Jvm.pause((long)1L);
                        --i;
                        if (end >= System.currentTimeMillis()) continue;
                        Assert.fail((String)("Timed out i: " + i));
                        continue;
                    }
                    long index = dc.index();
                    while (index > fromIndex.getVolatileValue()) {
                        Jvm.nanoPause();
                    }
                    IndexForIDTest.applyFlyweight(datum, datumSize, dc);
                    setTime.apply(datum, System.nanoTime());
                    toIndex.setVolatileValue(index);
                    continue;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    @Test
    public void staged() {
        this.staged = IOTools.createTempDirectory((String)"staged").toString();
        this.count = Jvm.isArm() ? 10000 : 1000000;
        Stream.of(this::producer, this::first, this::mid, this::end).forEach(Runnable::run);
        IOTools.deleteDirWithFiles((String)this.staged, (int)3);
    }

    static interface Facade
    extends Byteable {
        public long getProducerTime();

        public void setProducerTime(long var1);

        public long getFirstTime();

        public void setFirstTime(long var1);

        public long getMidTime();

        public void setMidTime(long var1);

        public long getEndTime();

        public void setEndTime(long var1);

        @Array(length=28)
        public double getValueAt(int var1);

        public void setValueAt(int var1, double var2);
    }

    @FunctionalInterface
    static interface TimeSetter {
        public void apply(Facade var1, long var2);
    }
}

