/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.ref.TextBooleanReference;
import net.openhft.chronicle.bytes.ref.TextIntArrayReference;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.Resettable;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.CommentAnnotationNotifier;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DynamicEnum;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextReadDocumentContext;
import net.openhft.chronicle.wire.TextStopCharTesters;
import net.openhft.chronicle.wire.TextStopCharsTesters;
import net.openhft.chronicle.wire.TextWriteDocumentContext;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueInStack;
import net.openhft.chronicle.wire.ValueInState;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaMethodReaderBuilder;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlWire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWire
extends AbstractWire
implements Wire {
    public static final BytesStore TYPE = BytesStore.from("!type ");
    public static final BytesStore BINARY = BytesStore.from("!!binary");
    @NotNull
    public static final Bytes<byte[]> TYPE_STR = Bytes.from("type ");
    static final String SEQ_MAP = "!seqmap";
    static final String NULL = "!null \"\"";
    static final BitSet STARTS_QUOTE_CHARS = new BitSet();
    static final BitSet QUOTE_CHARS = new BitSet();
    static final BitSet END_CHARS = new BitSet();
    static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_QUOTES = new ThreadLocal();
    static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_SINGLE_QUOTES = new ThreadLocal();
    static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_END_OF_TEXT = new ThreadLocal();
    static final ThreadLocal<WeakReference<StopCharsTester>> STRICT_ESCAPED_END_OF_TEXT = new ThreadLocal();
    static final BytesStore COMMA_SPACE = BytesStore.from(", ");
    static final BytesStore COMMA_NEW_LINE = BytesStore.from(",\n");
    static final BytesStore NEW_LINE = BytesStore.from("\n");
    static final BytesStore EMPTY_AFTER_COMMENT = BytesStore.from("");
    static final BytesStore EMPTY = BytesStore.from("");
    static final BytesStore SPACE = BytesStore.from(" ");
    static final BytesStore END_FIELD = NEW_LINE;
    static final char[] HEXADECIMAL = "0123456789ABCDEF".toCharArray();
    static final Pattern REGX_PATTERN = Pattern.compile("\\.|\\$");
    static final Supplier<StopCharTester> QUOTES_ESCAPING = StopCharTesters.QUOTES::escaping;
    static final Supplier<StopCharTester> SINGLE_QUOTES_ESCAPING = StopCharTesters.SINGLE_QUOTES::escaping;
    static final Supplier<StopCharTester> END_OF_TEXT_ESCAPING = TextStopCharTesters.END_OF_TEXT::escaping;
    static final Supplier<StopCharsTester> STRICT_END_OF_TEXT_ESCAPING = TextStopCharsTesters.STRICT_END_OF_TEXT::escaping;
    static final Supplier<StopCharsTester> END_EVENT_NAME_ESCAPING = TextStopCharsTesters.END_EVENT_NAME::escaping;
    protected final TextValueIn valueIn = this.createValueIn();
    private final TextValueOut valueOut = this.createValueOut();
    private final StringBuilder sb = new StringBuilder();
    protected long lineStart = 0L;
    private DefaultValueIn defaultValueIn;
    private WriteDocumentContext writeContext;
    private ReadDocumentContext readContext;
    private boolean strict = false;
    private boolean addTimeStamps = false;
    private boolean trimFirstCurly = true;

    public TextWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super(bytes, use8bit);
    }

    public TextWire(@NotNull Bytes<?> bytes) {
        this(bytes, false);
    }

    @NotNull
    public static TextWire fromFile(String name) throws IOException {
        return new TextWire(BytesUtil.readFile(name), true);
    }

    @NotNull
    public static TextWire from(@NotNull String text) {
        return new TextWire(Bytes.from(text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asText(@NotNull Wire wire) {
        assert (wire.startUse());
        NativeBytes<Void> bytes = NativeBytes.nativeBytes();
        try {
            long pos = wire.bytes().readPosition();
            @NotNull Wire tw = (Wire)WireType.TEXT.apply(bytes);
            wire.copyTo(tw);
            wire.bytes().readPosition(pos);
            String string = tw.toString();
            return string;
        }
        finally {
            bytes.releaseLast();
            assert (wire.endUse());
        }
    }

    public static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        for (int i = 0; i < length; ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case '0': {
                        ch = 0;
                        break;
                    }
                    case 'a': {
                        ch = 7;
                        break;
                    }
                    case 'b': {
                        ch = 8;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 'v': {
                        ch = 11;
                        break;
                    }
                    case 'f': {
                        ch = 12;
                        break;
                    }
                    case 'r': {
                        ch = 13;
                        break;
                    }
                    case 'e': {
                        ch = 27;
                        break;
                    }
                    case 'N': {
                        ch = 133;
                        break;
                    }
                    case '_': {
                        ch = 160;
                        break;
                    }
                    case 'x': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case 'u': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 4096 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 256 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            AppendableUtil.setCharAt(sb, end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, end);
    }

    @Nullable
    static StopCharTester getEscapingSingleQuotes() {
        StopCharTester sct = ThreadLocalHelper.getTL(ESCAPED_SINGLE_QUOTES, SINGLE_QUOTES_ESCAPING);
        sct.isStopChar(32);
        return sct;
    }

    private static void checkConsecutiveSpaces(@NotNull StringBuilder sb) {
        if (sb.length() == 0) {
            return;
        }
        char lastCh = sb.charAt(0);
        for (int i = 1; i < sb.length() - 1; ++i) {
            char ch2 = sb.charAt(i);
            if (lastCh <= ' ' && ch2 <= ' ') {
                throw new IORuntimeException("Cannot have multiple consecutive spaces in a field name '" + sb + "'");
            }
            lastCh = ch2;
        }
    }

    public static <T> T load(String filename) throws IOException {
        return (T)TextWire.fromFile(filename).readObject();
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    public boolean strict() {
        return this.strict;
    }

    public TextWire strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public boolean addTimeStamps() {
        return this.addTimeStamps;
    }

    public TextWire addTimeStamps(boolean addTimeStamps) {
        this.addTimeStamps = addTimeStamps;
        return this;
    }

    @Override
    @NotNull
    public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.TEXT, () -> this.newTextMethodWriterInvocationHandler(tClass));
        for (Class aClass : additional) {
            builder.addInterface(aClass);
        }
        this.useTextDocuments();
        builder.marshallableOut(this);
        return builder.build();
    }

    @NotNull
    TextMethodWriterInvocationHandler newTextMethodWriterInvocationHandler(Class ... interfaces) {
        for (Class anInterface : interfaces) {
            Comment c = anInterface.getAnnotation(Comment.class);
            if (c == null) continue;
            this.writeComment(c.value());
        }
        return new TextMethodWriterInvocationHandler(interfaces[0], this);
    }

    @Override
    @NotNull
    public <T> MethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder<T> text = new VanillaMethodWriterBuilder<T>(tClass, WireType.TEXT, () -> this.newTextMethodWriterInvocationHandler(tClass));
        text.marshallableOut(this);
        return text;
    }

    @Override
    @NotNull
    public VanillaMethodReaderBuilder methodReaderBuilder() {
        return super.methodReaderBuilder().wireType(WireType.TEXT);
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        if (this.writeContext == null) {
            this.useTextDocuments();
        }
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (this.writeContext != null && this.writeContext.isOpen() && this.writeContext.chainedElement()) {
            return this.writeContext;
        }
        return this.writingDocument(metaData);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.initReadContext();
        return this.readContext;
    }

    protected void initReadContext() {
        if (this.readContext == null) {
            this.useBinaryDocuments();
        }
        this.readContext.start();
    }

    @NotNull
    public TextWire useBinaryDocuments() {
        this.readContext = new BinaryReadDocumentContext(this, false);
        this.writeContext = new BinaryWriteDocumentContext(this);
        return this;
    }

    @NotNull
    public TextWire useTextDocuments() {
        this.readContext = new TextReadDocumentContext(this);
        this.writeContext = new TextWriteDocumentContext(this);
        return this;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.initReadContext();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @NotNull
    protected TextValueOut createValueOut() {
        return new TextValueOut();
    }

    @NotNull
    protected TextValueIn createValueIn() {
        return new TextValueIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.bytes.readRemaining() > 0x100000L) {
            long l = this.bytes.readLimit();
            try {
                this.bytes.readLimit(this.bytes.readPosition() + 0x100000L);
                String string = this.bytes + "..";
                return string;
            }
            finally {
                this.bytes.readLimit(l);
            }
        }
        return this.bytes.toString();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        if (!(wire instanceof TextWire) && !(wire instanceof YamlWire)) {
            throw new UnsupportedOperationException("Not implemented yet. Can only copy TextWire format to the same format  not " + wire.getClass());
        }
        Bytes<?> bytes0 = this.bytes();
        long length = bytes0.readRemaining();
        wire.bytes().write(this.bytes, bytes0.readPosition(), length);
        this.bytes.readSkip(length);
    }

    @Override
    public long readEventNumber() {
        StringBuilder stringBuilder = this.acquireStringBuilder();
        this.readField(stringBuilder);
        try {
            return StringUtils.parseInt(stringBuilder, 10);
        }
        catch (NumberFormatException ignored) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder());
        return this.valueIn;
    }

    @NotNull
    protected StringBuilder acquireStringBuilder() {
        StringUtils.setCount(this.sb, 0);
        return this.sb;
    }

    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        try {
            int ch = this.peekCode();
            if (ch > 128 && ((ch & 0xC0) == 128 || (ch & 0xF0) == 240)) {
                throw new IllegalStateException("Attempting to read binary as TextWire ch=" + Integer.toHexString(ch));
            }
            if (ch < 0 || ch == 33 || ch == 91 || ch == 123) {
                sb.setLength(0);
                return sb;
            }
            if (ch == 63) {
                this.bytes.readSkip(1L);
                this.consumePadding();
                ch = this.peekCode();
            }
            if (ch == 34) {
                this.bytes.readSkip(1L);
                this.parseUntil(sb, this.getEscapingQuotes());
                this.consumePadding();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString() + " was " + (char)ch);
                }
            } else if (ch == 39) {
                this.bytes.readSkip(1L);
                this.parseUntil(sb, TextWire.getEscapingSingleQuotes());
                this.consumePadding();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString() + " was " + (char)ch);
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            TextWire.unescape(sb);
            TextWire.checkConsecutiveSpaces(sb);
        }
        catch (BufferUnderflowException e) {
            Jvm.debug().on(this.getClass(), e);
        }
        return sb;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) {
        this.consumePadding(0);
        @NotNull StringBuilder sb = this.acquireStringBuilder();
        try {
            int ch = this.peekCode();
            if (ch > 128 && ((ch & 0xC0) == 128 || (ch & 0xF0) == 240)) {
                throw new IllegalStateException("Attempting to read binary as TextWire ch=" + Integer.toHexString(ch));
            }
            if (ch == 63) {
                this.bytes.readSkip(1L);
                this.consumePadding();
                int ch3 = this.peekCode();
                @Nullable Object object = ch3 != 33 && expectedClass == Object.class ? this.valueIn.objectWithInferredType0(null, SerializationStrategies.ANY_SCALAR, this.defaultKeyClass()) : this.valueIn.object(expectedClass);
                this.consumePadding();
                int ch2 = this.readCode();
                if (ch2 != 58) {
                    throw new IllegalStateException("Unexpected character after field " + ch + " '" + (char)ch2 + "'");
                }
                return object;
            }
            if (ch == 91) {
                return this.valueIn.object(expectedClass);
            }
            if (ch == 34 || ch == 39) {
                this.bytes.readSkip(1L);
                StopCharTester escapingQuotes = ch == 34 ? this.getEscapingQuotes() : TextWire.getEscapingSingleQuotes();
                this.parseUntil(sb, escapingQuotes);
                this.consumePadding(1);
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return null;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            TextWire.unescape(sb);
        }
        catch (BufferUnderflowException e) {
            Jvm.debug().on(this.getClass(), e);
        }
        return this.toExpected(expectedClass, sb);
    }

    protected Class defaultKeyClass() {
        return Object.class;
    }

    @Nullable
    private <K> K toExpected(Class<K> expectedClass, StringBuilder sb) {
        return ObjectUtils.convertTo(expectedClass, WireInternal.INTERNER.intern(sb));
    }

    @NotNull
    protected StopCharTester getEscapingEndOfText() {
        StopCharTester escaping = ThreadLocalHelper.getTL(ESCAPED_END_OF_TEXT, END_OF_TEXT_ESCAPING);
        escaping.isStopChar(32);
        return escaping;
    }

    @NotNull
    protected StopCharsTester getStrictEscapingEndOfText() {
        StopCharsTester escaping = ThreadLocalHelper.getTL(STRICT_ESCAPED_END_OF_TEXT, this.strictEndOfTextEscaping());
        escaping.isStopChar(32, 32);
        return escaping;
    }

    @Deprecated
    @NotNull
    protected TextStopCharsTesters strictEndOfText() {
        return TextStopCharsTesters.STRICT_END_OF_TEXT;
    }

    @NotNull
    protected Supplier<StopCharsTester> strictEndOfTextEscaping() {
        return this.strictEndOfText() == TextStopCharsTesters.STRICT_END_OF_TEXT ? STRICT_END_OF_TEXT_ESCAPING : this.strictEndOfText()::escaping;
    }

    @NotNull
    protected StopCharsTester getEscapingEndEventName() {
        StopCharsTester escaping = ThreadLocalHelper.getTL(STRICT_ESCAPED_END_OF_TEXT, END_EVENT_NAME_ESCAPING);
        escaping.isStopChar(32, 32);
        return escaping;
    }

    @Nullable
    protected StopCharTester getEscapingQuotes() {
        StopCharTester sct = ThreadLocalHelper.getTL(ESCAPED_QUOTES, QUOTES_ESCAPING);
        sct.isStopChar(32);
        return sct;
    }

    @Override
    public void consumePadding() {
        this.consumePadding(0);
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        return "todo";
    }

    public void consumePadding(int commas) {
        block6: while (true) {
            int codePoint = this.peekCode();
            switch (codePoint) {
                case 35: {
                    while (this.notNewLine(this.readCode())) {
                    }
                    this.lineStart = this.bytes.readPosition();
                    continue block6;
                }
                case 44: {
                    if (this.valueIn.isASeparator(this.peekCodeNext()) && commas-- <= 0) {
                        return;
                    }
                    this.bytes.readSkip(1L);
                    continue block6;
                }
                case 9: 
                case 32: {
                    this.bytes.readSkip(1L);
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.lineStart = this.bytes.readPosition() + 1L;
                    this.bytes.readSkip(1L);
                    continue block6;
                }
            }
            break;
        }
    }

    private boolean notNewLine(int readCode) {
        return readCode >= 0 && readCode != 13 && readCode != 10;
    }

    protected void consumeDocumentStart() {
        long pos;
        if (this.bytes.readRemaining() > 4L && this.bytes.readByte(pos = this.bytes.readPosition()) == 45 && this.bytes.readByte(pos + 1L) == 45 && this.bytes.readByte(pos + 2L) == 45) {
            String word;
            this.bytes.readSkip(3L);
            this.consumeWhiteSpace();
            pos = this.bytes.readPosition();
            switch (word = this.bytes.parseUtf8(StopCharTesters.SPACE_STOP)) {
                case "!!data": 
                case "!!data-not-ready": 
                case "!!meta-data": 
                case "!!meta-data-not-ready": {
                    break;
                }
                default: {
                    this.bytes.readPosition(pos);
                }
            }
        }
    }

    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    int peekCodeNext() {
        return this.bytes.peekUnsignedByte(this.bytes.readPosition() + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    protected int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.read(key.name(), key.code(), key.defaultValue());
    }

    private ValueIn read(@NotNull CharSequence keyName, int keyCode, Object defaultValue) {
        this.consumePadding();
        ValueInState curr = this.valueIn.curr();
        StringBuilder stringBuilder = this.acquireStringBuilder();
        if (curr.savedPosition() > 0L) {
            this.bytes.readPosition(curr.savedPosition() - 1L);
            curr.savedPosition(0L);
        }
        while (this.bytes.readRemaining() > 0L) {
            long position = this.bytes.readPosition();
            this.readField(stringBuilder);
            curr = this.valueIn.curr();
            if (StringUtils.equalsCaseIgnore(stringBuilder, keyName)) {
                return this.valueIn;
            }
            if (stringBuilder.length() == 0) {
                if (curr.unexpectedSize() > 0) break;
                return this.valueIn;
            }
            curr.addUnexpected(position);
            long toSkip = this.valueIn.readLengthMarshallable();
            this.bytes.readSkip(toSkip);
            this.consumePadding(1);
        }
        return this.read2(keyName, keyCode, defaultValue, curr, stringBuilder, keyName);
    }

    protected ValueIn read2(CharSequence keyName, int keyCode, Object defaultValue, @NotNull ValueInState curr, @NotNull StringBuilder sb, @NotNull CharSequence name) {
        long position2 = this.bytes.readPosition();
        for (int i = 0; i < curr.unexpectedSize(); ++i) {
            this.bytes.readPosition(curr.unexpected(i));
            this.readField(sb);
            if (sb.length() != 0 && !StringUtils.equalsCaseIgnore(sb, name)) continue;
            curr.removeUnexpected(i);
            curr.savedPosition(position2 + 1L);
            return this.valueIn;
        }
        this.bytes.readPosition(position2);
        if (this.defaultValueIn == null) {
            this.defaultValueIn = new DefaultValueIn(this);
        }
        this.defaultValueIn.defaultValue = defaultValue;
        return this.defaultValueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumePadding();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        this.consumeWhiteSpace();
        if (this.peekCode() == 35) {
            this.bytes.readSkip(1L);
            this.consumeWhiteSpace();
            this.bytes.parseUtf8((Appendable)s, StopCharTesters.CONTROL_STOP);
        }
        return this;
    }

    public void consumeWhiteSpace() {
        while (Character.isWhitespace(this.peekCode())) {
            this.bytes.readSkip(1L);
        }
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.valueIn.resetState();
        this.valueOut.resetState();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut.write();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence name) {
        return this.valueOut.write(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueOut writeEvent(Class expectedType, Object eventKey) {
        if (eventKey instanceof WireKey) {
            return this.writeEventName((WireKey)eventKey);
        }
        if (eventKey instanceof CharSequence) {
            return this.writeEventName((CharSequence)eventKey);
        }
        if (expectedType != null && expectedType.isInstance(eventKey)) {
            if (eventKey instanceof Enum) {
                return this.writeEventName(((Enum)eventKey).name());
            }
            if (eventKey instanceof DynamicEnum) {
                return this.writeEventName(((DynamicEnum)eventKey).name());
            }
        }
        boolean wasLeft = this.valueOut.swapLeaf(true);
        try {
            ValueOut valueOut = this.valueOut.write(expectedType, eventKey);
            return valueOut;
        }
        finally {
            this.valueOut.swapLeaf(wasLeft);
        }
    }

    @Override
    @NotNull
    public WireOut dropDefault(boolean dropDefault) {
        this.valueOut.dropDefault = dropDefault;
        return this;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(@NotNull CharSequence s) {
        this.valueOut.writeComment(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.writeUnsignedByte((this.bytes.writePosition() & 0x3FL) == 0L ? 10 : 32);
        }
        return this;
    }

    void escape(@NotNull CharSequence s) {
        @NotNull Quotes quotes = this.needsQuotesEscaped(s);
        if (quotes == Quotes.NONE) {
            this.escape0(s, quotes);
            return;
        }
        this.bytes.writeUnsignedByte(quotes.q);
        this.escape0(s, quotes);
        this.bytes.writeUnsignedByte(quotes.q);
    }

    protected void escape0(@NotNull CharSequence s, @NotNull Quotes quotes) {
        block16: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\u0000': {
                    this.bytes.appendUtf8("\\0");
                    continue block16;
                }
                case '\u0007': {
                    this.bytes.appendUtf8("\\a");
                    continue block16;
                }
                case '\b': {
                    this.bytes.appendUtf8("\\b");
                    continue block16;
                }
                case '\t': {
                    this.bytes.appendUtf8("\\t");
                    continue block16;
                }
                case '\n': {
                    this.bytes.appendUtf8("\\n");
                    continue block16;
                }
                case '\u000b': {
                    this.bytes.appendUtf8("\\v");
                    continue block16;
                }
                case '\f': {
                    this.bytes.appendUtf8("\\f");
                    continue block16;
                }
                case '\r': {
                    this.bytes.appendUtf8("\\r");
                    continue block16;
                }
                case '\u001b': {
                    this.bytes.appendUtf8("\\e");
                    continue block16;
                }
                case '\"': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte(ch);
                        continue block16;
                    }
                    this.bytes.writeUnsignedByte(ch);
                    continue block16;
                }
                case '\'': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte(ch);
                        continue block16;
                    }
                    this.bytes.writeUnsignedByte(ch);
                    continue block16;
                }
                case '\\': {
                    ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte(ch);
                    continue block16;
                }
                case '\u0085': {
                    this.bytes.appendUtf8("\\N");
                    continue block16;
                }
                case '\u00a0': {
                    this.bytes.appendUtf8("\\_");
                    continue block16;
                }
                default: {
                    if (ch > '\u00ff') {
                        this.appendU4(ch);
                        continue block16;
                    }
                    if (ch < ' ' || ch > '\u007f') {
                        this.appendX2(ch);
                        continue block16;
                    }
                    this.bytes.appendUtf8(ch);
                }
            }
        }
    }

    private void appendX2(char ch) {
        this.bytes.append('\\');
        this.bytes.append('x');
        this.bytes.append(HEXADECIMAL[ch >> 4 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch & 0xF]);
    }

    private void appendU4(char ch) {
        this.bytes.append('\\');
        this.bytes.append('u');
        this.bytes.append(HEXADECIMAL[ch >> 12]);
        this.bytes.append(HEXADECIMAL[ch >> 8 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch >> 4 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch & 0xF]);
    }

    @NotNull
    protected Quotes needsQuotesEscaped(@NotNull CharSequence s) {
        @NotNull Quotes quotes = Quotes.NONE;
        if (s.length() == 0) {
            return Quotes.DOUBLE;
        }
        if (STARTS_QUOTE_CHARS.get(s.charAt(0)) || Character.isWhitespace(s.charAt(s.length() - 1))) {
            return Quotes.DOUBLE;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (QUOTE_CHARS.get(ch) || ch < ' ' || ch > '\u007f') {
                return Quotes.DOUBLE;
            }
            if (ch != '\"') continue;
            quotes = Quotes.SINGLE;
        }
        return quotes;
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        return new TextBooleanReference();
    }

    @Override
    public boolean useSelfDescribingMessage(@NotNull CommonMarshallable object) {
        return true;
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        return new TextIntArrayReference();
    }

    public void parseWord(@NotNull StringBuilder sb) {
        this.parseUntil(sb, StopCharTesters.SPACE_STOP);
    }

    public void parseUntil(@NotNull StringBuilder sb, @NotNull StopCharTester testers) {
        if (this.use8bit) {
            this.bytes.parse8bit((Appendable)sb, testers);
        } else {
            this.bytes.parseUtf8((Appendable)sb, testers);
        }
    }

    public void parseUntil(@NotNull StringBuilder sb, @NotNull StopCharsTester testers) {
        sb.setLength(0);
        if (this.use8bit) {
            AppendableUtil.read8bitAndAppend(this.bytes, sb, testers);
        } else {
            AppendableUtil.readUTFAndAppend(this.bytes, sb, testers);
        }
    }

    public void append(@NotNull CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.appendUtf8(cs);
        }
    }

    public void append(@NotNull CharSequence cs, int offset, int length) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, offset + length);
        } else {
            this.bytes.appendUtf8(cs, offset, length);
        }
    }

    @Nullable
    public Object readObject() {
        this.consumePadding();
        this.consumeDocumentStart();
        return this.getValueIn().object(Object.class);
    }

    @Nullable
    Object readObject(int indentation) {
        this.consumePadding();
        int code = this.peekCode();
        int indentation2 = this.indentation();
        if (indentation2 < indentation) {
            return NoObject.NO_OBJECT;
        }
        switch (code) {
            case 45: {
                if (this.peekCodeNext() == 45) {
                    return NoObject.NO_OBJECT;
                }
                return this.readList(indentation2, null);
            }
            case 91: {
                return this.readList();
            }
            case 123: {
                return this.valueIn.marshallableAsMap(Object.class, Object.class);
            }
            case 33: {
                return this.readTypedObject();
            }
        }
        return this.readMap(indentation2, null);
    }

    private int indentation() {
        long pos = this.bytes.readPosition();
        if (pos < this.lineStart) {
            this.lineStart = pos;
            return 0;
        }
        return Maths.toInt32(pos - this.lineStart);
    }

    @Nullable
    private Object readTypedObject() {
        return this.valueIn.object(Object.class);
    }

    @NotNull
    private List readList() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    List readList(int indentation, Class elementType) {
        @NotNull ArrayList<Object> objects = new ArrayList<Object>();
        while (this.peekCode() == 45 && this.indentation() >= indentation && this.peekCodeNext() != 45) {
            long ls = this.lineStart;
            this.bytes.readSkip(1L);
            this.consumePadding();
            if (this.lineStart == ls) {
                objects.add(this.valueIn.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, elementType));
            } else {
                @Nullable Object e = this.readObject(indentation);
                if (e != NoObject.NO_OBJECT) {
                    objects.add(e);
                }
            }
            this.consumePadding(1);
        }
        return objects;
    }

    @NotNull
    private Map readMap(int indentation, Class valueType) {
        @NotNull LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuilder sb = WireInternal.acquireAnotherStringBuilder(this.acquireStringBuilder());
        this.consumePadding();
        while (this.bytes.readRemaining() > 0L && this.indentation() >= indentation && this.bytes.readRemaining() != 0L) {
            this.read(sb);
            @Nullable String key = WireInternal.INTERNER.intern(sb);
            if (key.equals("...")) break;
            @Nullable Object value = this.valueIn.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, valueType);
            map.put(key, value);
            this.consumePadding(1);
        }
        return map;
    }

    public void writeObject(Object o) {
        if (o instanceof Iterable) {
            for (Object o2 : (Iterable)o) {
                this.writeObject(o2, 2);
            }
        } else if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                this.write(() -> entry.getKey().toString()).object(entry.getValue());
            }
        } else if (o instanceof WriteMarshallable) {
            this.valueOut.typedMarshallable((WriteMarshallable)o);
        } else {
            this.valueOut.object(o);
        }
    }

    private void writeObject(Object o, int indentation) {
        this.writeTwo('-', ' ');
        this.indentation(indentation - 2);
        this.valueOut.object(o);
    }

    private void indentation(int indentation) {
        while (indentation-- > 0) {
            this.bytes.writeUnsignedByte(32);
        }
    }

    @Override
    public void writeStartEvent() {
        this.valueOut.prependSeparator();
        this.writeTwo('?', ' ');
    }

    @Override
    public void writeEndEvent() {
        this.valueOut.endEvent();
    }

    void writeTwo(char ch1, char ch2) {
        this.bytes.writeUnsignedByte(ch1);
        this.bytes.writeUnsignedByte(ch2);
    }

    public boolean trimFirstCurly() {
        return this.trimFirstCurly;
    }

    public TextWire trimFirstCurly(boolean trimFirstCurly) {
        this.trimFirstCurly = trimFirstCurly;
        return this;
    }

    @Override
    public void reset() {
        this.sb.setLength(0);
        this.lineStart = 0L;
        this.valueIn.resetState();
        this.valueOut.resetState();
        this.writeContext.reset();
        this.readContext.reset();
        this.bytes.clear();
    }

    static {
        IOTools.unmonitor(TYPE);
        IOTools.unmonitor(BINARY);
        for (char ch : "?%*&@`0123456789+- ',#:{}[]|>!\\".toCharArray()) {
            STARTS_QUOTE_CHARS.set(ch);
        }
        for (char ch : "?,#:{}[]|>\\^".toCharArray()) {
            QUOTE_CHARS.set(ch);
        }
        for (char ch : "#:}]".toCharArray()) {
            END_CHARS.set(ch);
        }
        WireInternal.INTERNER.valueCount();
    }

    class TextValueIn
    implements ValueIn {
        final ValueInStack stack = new ValueInStack();
        int sequenceLimit = 0;

        TextValueIn() {
        }

        @Override
        public void resetState() {
            this.stack.reset();
        }

        public void pushState() {
            this.stack.push();
        }

        public void popState() {
            this.stack.pop();
        }

        public ValueInState curr() {
            return this.stack.curr();
        }

        @Override
        @Nullable
        public String text() {
            @Nullable CharSequence cs = this.textTo0(TextWire.this.acquireStringBuilder());
            return cs == null ? null : WireInternal.INTERNER.intern(cs);
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            sb.setLength(0);
            @Nullable CharSequence cs = this.textTo0(sb);
            if (cs == null) {
                return null;
            }
            if (cs != sb) {
                sb.setLength(0);
                sb.append(cs);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> bytes) {
            bytes.clear();
            @Nullable CharSequence cs = this.textTo0((Appendable & CharSequence)bytes);
            TextWire.this.consumePadding(1);
            if (cs == null) {
                return null;
            }
            if (cs != bytes) {
                bytes.clear();
                bytes.writeUtf8(cs);
            }
            return bytes;
        }

        @Override
        @NotNull
        public BracketType getBracketType() {
            TextWire.this.consumePadding();
            switch (TextWire.this.peekCode()) {
                case 123: {
                    return BracketType.MAP;
                }
                case 91: {
                    return BracketType.SEQ;
                }
            }
            return BracketType.NONE;
        }

        @Nullable
        <ACS extends Appendable & CharSequence> CharSequence textTo0(@NotNull ACS a) {
            TextWire.this.consumePadding();
            int ch = TextWire.this.peekCode();
            @Nullable CharSequence ret = a;
            switch (ch) {
                case 123: {
                    long len = this.readLength();
                    try {
                        a.append(Bytes.toString(TextWire.this.bytes, TextWire.this.bytes.readPosition(), len));
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                    TextWire.this.bytes.readSkip(len);
                    TextWire.this.bytes.skipTo(StopCharTesters.COMMA_STOP);
                    return a;
                }
                case 34: {
                    this.readText(a, TextWire.this.getEscapingQuotes());
                    break;
                }
                case 39: {
                    this.readText(a, TextWire.getEscapingSingleQuotes());
                    break;
                }
                case 33: {
                    TextWire.this.bytes.readSkip(1L);
                    StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                    TextWire.this.parseWord(stringBuilder);
                    if (StringUtils.isEqual(stringBuilder, (CharSequence)"!null")) {
                        this.textTo(stringBuilder);
                        ret = null;
                        break;
                    }
                    if (a instanceof StringBuilder) {
                        this.textTo((StringBuilder)a);
                        break;
                    }
                    this.textTo(stringBuilder);
                    ret = stringBuilder;
                    break;
                }
                case -1: {
                    return "";
                }
                case 36: {
                    if (TextWire.this.peekCodeNext() == 123) {
                        this.unsubstitutedString(a);
                        return a;
                    }
                }
                default: {
                    long rem = TextWire.this.bytes.readRemaining();
                    if (rem > 0L) {
                        if (a instanceof Bytes) {
                            TextWire.this.bytes.parse8bit((Bytes)a, TextWire.this.getStrictEscapingEndOfText());
                        } else if (TextWire.this.use8bit) {
                            TextWire.this.bytes.parse8bit((StringBuilder)a, TextWire.this.getStrictEscapingEndOfText());
                        } else {
                            TextWire.this.bytes.parseUtf8(a, TextWire.this.getStrictEscapingEndOfText());
                        }
                        if (rem == TextWire.this.bytes.readRemaining()) {
                            throw new IORuntimeException("Nothing to read at " + TextWire.this.bytes.toDebugString(32L));
                        }
                    } else {
                        AppendableUtil.setLength(a, 0);
                    }
                    while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                        AppendableUtil.setLength(a, ((CharSequence)a).length() - 1);
                    }
                    break block1;
                }
            }
            int prev = this.peekBack();
            if (END_CHARS.get(prev)) {
                TextWire.this.bytes.readSkip(-1L);
            }
            return ret;
        }

        private <ACS extends Appendable & CharSequence> void unsubstitutedString(@NotNull ACS a) {
            char c;
            String text = TextWire.this.bytes.toString();
            if (text.length() > 32) {
                text = text.substring(0, 32);
            }
            Jvm.warn().on(this.getClass(), "Found an unsubstituted ${} as " + text);
            do {
                c = TextWire.this.bytes.readChar();
                try {
                    a.append(c);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            } while (!TextWire.this.bytes.isEmpty() && c != '}');
        }

        private <ACS extends Appendable & CharSequence> void readText(@NotNull ACS a, @NotNull StopCharTester quotes) {
            TextWire.this.bytes.readSkip(1L);
            if (TextWire.this.use8bit) {
                TextWire.this.bytes.parse8bit(a, quotes);
            } else {
                TextWire.this.bytes.parseUtf8(a, quotes);
            }
            TextWire.unescape(a);
            TextWire.this.consumePadding(1);
        }

        protected int peekBack() {
            while (TextWire.this.bytes.readPosition() > TextWire.this.bytes.start()) {
                int prev = TextWire.this.bytes.readUnsignedByte(TextWire.this.bytes.readPosition() - 1L);
                if (prev != 32) {
                    if (prev == 10 || prev == 13) {
                        TextWire.this.lineStart = TextWire.this.bytes.readPosition();
                    }
                    return prev;
                }
                TextWire.this.bytes.readSkip(-1L);
            }
            return -1;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes) {
            toBytes.clear();
            return this.bytes((BytesIn<?> b) -> {
                Bytes cfr_ignored_0 = (Bytes)toBytes.write((BytesStore)((Object)b));
            });
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            return this.bytes((BytesIn<?> bytes) -> {
                long capacity = bytes.readRemaining();
                VanillaBytes<Void> bytes2 = Bytes.allocateDirect(capacity);
                bytes2.write((BytesStore)((Object)bytes));
                toBytes.set(bytes2.addressForRead(bytes2.start()), capacity);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            TextWire.this.consumePadding();
            try {
                @NotNull StringBuilder sb = TextWire.this.acquireStringBuilder();
                if (TextWire.this.peekCode() == 33) {
                    TextWire.this.bytes.readSkip(1L);
                    TextWire.this.parseWord(sb);
                    @Nullable byte[] uncompressed = Compression.uncompress((CharSequence)sb, TextWire.this, t -> {
                        @NotNull StringBuilder sb2 = TextWire.this.acquireStringBuilder();
                        AppendableUtil.setLength(sb2, 0);
                        t.parseUntil(sb2, StopCharTesters.COMMA_SPACE_STOP);
                        return Base64.getDecoder().decode(sb2.toString());
                    });
                    if (uncompressed != null) {
                        bytesConsumer.readMarshallable(Bytes.wrapForRead(uncompressed));
                    } else {
                        if (!StringUtils.isEqual(sb, (CharSequence)"!null")) throw new IORuntimeException("Unsupported type=" + sb);
                        bytesConsumer.readMarshallable(null);
                        TextWire.this.parseWord(sb);
                    }
                } else {
                    this.textTo(sb);
                    bytesConsumer.readMarshallable(Bytes.wrapForRead(sb.toString().getBytes(StandardCharsets.ISO_8859_1)));
                }
                TextWire textWire = TextWire.this;
                return textWire;
            }
            finally {
                TextWire.this.consumePadding(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] bytes(byte[] using) {
            TextWire.this.consumePadding();
            try {
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                if (TextWire.this.peekCode() == 33) {
                    byte[] bytes;
                    TextWire.this.bytes.readSkip(1L);
                    TextWire.this.parseWord(stringBuilder);
                    if ("byte[]".contentEquals(stringBuilder)) {
                        TextWire.this.bytes.readSkip(1L);
                        TextWire.this.parseWord(stringBuilder);
                    }
                    if ((bytes = Compression.uncompress((CharSequence)stringBuilder, this, t -> {
                        @NotNull StringBuilder sb0 = TextWire.this.acquireStringBuilder();
                        TextWire.this.parseUntil(sb0, StopCharTesters.COMMA_SPACE_STOP);
                        return Base64.getDecoder().decode(WireInternal.INTERNER.intern(sb0));
                    })) != null) {
                        byte[] byArray = bytes;
                        return byArray;
                    }
                    if ("!null".contentEquals(stringBuilder)) {
                        TextWire.this.parseWord(stringBuilder);
                        byte[] byArray = null;
                        return byArray;
                    }
                    throw new IllegalStateException("unsupported type=" + stringBuilder);
                }
                this.textTo(stringBuilder);
                if (using != null && stringBuilder.length() == using.length) {
                    for (int i = 0; i < using.length; ++i) {
                        using[i] = (byte)stringBuilder.charAt(i);
                    }
                    byte[] byArray = using;
                    return byArray;
                }
                byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
                return byArray;
            }
            finally {
                TextWire.this.consumePadding(1);
            }
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return TextWire.this;
        }

        @Override
        public long readLength() {
            return this.readLengthMarshallable();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            this.consumeAny();
            if (TextWire.this.peekCode() == 44) {
                TextWire.this.bytes.readSkip(1L);
            }
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long readLengthMarshallable() {
            long start = TextWire.this.bytes.readPosition();
            try {
                this.consumeAny();
                long l = TextWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.readPosition(start);
            }
        }

        protected void consumeAny() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            switch (code) {
                case 36: {
                    TextWire.this.bytes.readSkip(1L);
                    if (TextWire.this.peekCode() != 123) break;
                    TextWire.this.bytes.parse8bit(StopCharTesters.CURLY_STOP);
                    break;
                }
                case 123: {
                    this.consumeMap();
                    break;
                }
                case 91: {
                    this.consumeSeq();
                    break;
                }
                case 125: {
                    break;
                }
                case 93: {
                    break;
                }
                case 63: {
                    TextWire.this.bytes.readSkip(1L);
                    this.consumeAny();
                    if (TextWire.this.peekCode() != 58) break;
                    TextWire.this.bytes.readSkip(1L);
                    this.consumeAny();
                    break;
                }
                case 33: {
                    this.consumeType2();
                    break;
                }
                default: {
                    this.consumeValue();
                    while (this.peekBack() <= 32 && TextWire.this.bytes.readPosition() >= 0L) {
                        TextWire.this.bytes.readSkip(-1L);
                    }
                    if (this.peekBack() == 44) {
                        TextWire.this.bytes.readSkip(-1L);
                        break;
                    }
                    TextWire.this.consumePadding();
                    if (TextWire.this.peekCode() != 58 || !this.isASeparator(TextWire.this.peekCodeNext())) break;
                    TextWire.this.readCode();
                    this.consumeAny();
                }
            }
        }

        protected boolean isASeparator(int nextChar) {
            return TextStopCharsTesters.isASeparator(nextChar);
        }

        private void consumeType2() {
            TextWire.this.bytes.readSkip(1L);
            boolean type = TextWire.this.bytes.startsWith(TYPE_STR);
            if (type) {
                TextWire.this.bytes.readSkip(TYPE_STR.length());
            }
            while (!TextStopCharTesters.END_OF_TYPE.isStopChar(TextWire.this.peekCode())) {
                TextWire.this.bytes.readSkip(1L);
            }
            if (TextWire.this.peekCode() == 59) {
                TextWire.this.bytes.readSkip(1L);
            }
            if (!type) {
                this.consumeAny();
            }
        }

        private void consumeSeq() {
            block2: {
                long pos;
                TextWire.this.bytes.readSkip(1L);
                do {
                    pos = TextWire.this.bytes.readPosition();
                    this.consumeAny();
                    if (TextWire.this.peekCode() != 44 || !this.isASeparator(TextWire.this.peekCodeNext())) break block2;
                    TextWire.this.readCode();
                } while (TextWire.this.bytes.readPosition() != pos);
                throw new IllegalStateException("Stuck at pos " + pos + " " + TextWire.this.bytes);
            }
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (code != 93) {
                TextWire.this.bytes.readSkip(-1L);
                throw new IllegalStateException("Expected a ] was " + TextWire.this.bytes);
            }
        }

        private void consumeMap() {
            block2: {
                long pos;
                TextWire.this.bytes.readSkip(1L);
                do {
                    pos = TextWire.this.bytes.readPosition();
                    this.consumeAny();
                    int code2 = TextWire.this.peekCode();
                    if (code2 == 125 || code2 == 93 || code2 <= 0) break block2;
                    if (code2 != 44 || !this.isASeparator(TextWire.this.peekCodeNext())) continue;
                    TextWire.this.readCode();
                } while (TextWire.this.bytes.readPosition() != pos);
                throw new IllegalStateException("Stuck at pos " + pos + " " + TextWire.this.bytes);
            }
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (code != 125) {
                TextWire.this.bytes.readSkip(-1L);
                throw new IllegalStateException("Expected a } was " + (char)code);
            }
        }

        private void consumeValue() {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.parseWord(stringBuilder);
                if (StringUtils.isEqual(stringBuilder, (CharSequence)"type")) {
                    this.consumeType();
                } else {
                    this.consumeAny();
                }
            } else {
                this.textTo(stringBuilder);
            }
        }

        private void consumeType() {
            TextWire.this.parseUntil(TextWire.this.acquireStringBuilder(), StopCharTesters.COMMA_SPACE_STOP);
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                tFlag.accept(t, null);
                return TextWire.this;
            }
            tFlag.accept(t, StringUtils.isEqual(stringBuilder, (CharSequence)"true"));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            TextWire.this.consumePadding();
            tb.accept(t, (byte)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return TextWire.this;
        }

        long getALong() {
            int code = TextWire.this.peekCode();
            switch (code) {
                case 34: 
                case 39: {
                    TextWire.this.bytes.readSkip(1L);
                    break;
                }
                case 70: 
                case 84: 
                case 102: 
                case 116: {
                    return this.bool() ? 1L : 0L;
                }
                case 36: {
                    this.unsubstitutedNumber();
                    return 0L;
                }
                case 91: 
                case 123: {
                    throw new IORuntimeException("Cannot read a " + (char)code + " as a number");
                }
            }
            return TextWire.this.bytes.parseLong();
        }

        private void unsubstitutedNumber() {
            String s = TextWire.this.bytes.parse8bit(StopCharTesters.CURLY_STOP);
            Jvm.warn().on(this.getClass(), "Cannot read " + s + "} as a number, treating as 0");
            if (",\n ".indexOf(TextWire.this.peekCode()) < 0) {
                throw new IllegalStateException("Unable to continue after ${} in number.");
            }
            TextWire.this.bytes.readSkip(1L);
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            TextWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            TextWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            TextWire.this.consumePadding();
            if (TextWire.this.peekCode() == 36) {
                this.unsubstitutedNumber();
            } else {
                tf.accept(t, (float)TextWire.this.bytes.parseDouble());
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            TextWire.this.consumePadding();
            if (TextWire.this.peekCode() == 36) {
                this.unsubstitutedNumber();
            } else {
                td.accept(t, TextWire.this.bytes.parseDouble());
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            setLocalTime.accept(t, LocalTime.parse(WireInternal.INTERNER.intern(stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tZonedDateTime.accept(t, ZonedDateTime.parse(WireInternal.INTERNER.intern(stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tLocalDate.accept(t, LocalDate.parse(WireInternal.INTERNER.intern(stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tuuid.accept(t, UUID.fromString(WireInternal.INTERNER.intern(stringBuilder)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            TextWire.this.consumePadding();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
            }
            @NotNull Byteable b = (Byteable)((Object)values);
            long length = TextLongArrayReference.peakLength(TextWire.this.bytes, TextWire.this.bytes.readPosition());
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            setter.accept(t, values);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            TextWire.this.consumePadding();
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            TextWire.this.consumePadding();
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        public WireIn bool(@NotNull BooleanValue value) {
            TextWire.this.consumePadding();
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            TextWire.this.consumePadding();
            if (!(value instanceof TextIntReference)) {
                value = new TextIntReference();
                setter.accept(t, value);
            }
            @Nullable Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.peekCode();
            if (code == '!') {
                @Nullable Class typePrefix = this.typePrefix();
                if (typePrefix == Void.TYPE) {
                    this.text();
                    return false;
                }
                TextWire.this.consumePadding();
                code = (char)TextWire.this.readCode();
            }
            if (code == '[') {
                TextWire.this.bytes.readSkip(1L);
                this.sequenceLimit = Integer.MAX_VALUE;
            } else {
                this.sequenceLimit = 1;
            }
            tReader.accept(t, TextWire.this.valueIn);
            if (code == '[') {
                TextWire.this.consumePadding(1);
                char code2 = (char)TextWire.this.readCode();
                if (code2 != ']') {
                    throw new IORuntimeException("Expected a ] but got " + code2 + " (" + code2 + ")");
                }
            }
            TextWire.this.consumePadding(1);
            return true;
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) {
            return this.sequence(list, buffer, bufferAdd);
        }

        @Override
        public <T> boolean sequence(@NotNull List<T> list, @NotNull List<T> buffer, @NotNull Supplier<T> bufferAdd) {
            list.clear();
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.peekCode();
            if (code == '!') {
                @Nullable Class typePrefix = this.typePrefix();
                if (typePrefix == Void.TYPE) {
                    this.text();
                    return false;
                }
                TextWire.this.consumePadding();
                code = (char)TextWire.this.readCode();
            }
            if (code == '[') {
                TextWire.this.bytes.readSkip(1L);
                this.sequenceLimit = Integer.MAX_VALUE;
            } else {
                this.sequenceLimit = 1;
            }
            while (this.hasNextSequenceItem()) {
                T t;
                int size = list.size();
                if (buffer.size() <= size) {
                    buffer.add(bufferAdd.get());
                }
                if ((t = buffer.get(size)) instanceof Resettable) {
                    ((Resettable)t).reset();
                }
                list.add(this.object(t, t.getClass()));
            }
            if (code == '[') {
                TextWire.this.consumePadding(1);
                char code2 = (char)TextWire.this.readCode();
                if (code2 != ']') {
                    throw new IORuntimeException("Expected a ] but got " + code2 + " (" + code2 + ")");
                }
            }
            TextWire.this.consumePadding(1);
            return true;
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.peekCode();
            if (code == '[') {
                TextWire.this.bytes.readSkip(1L);
                this.sequenceLimit = Integer.MAX_VALUE;
            } else {
                this.sequenceLimit = 1;
            }
            TextWire.this.consumePadding();
            char code2 = (char)TextWire.this.peekCode();
            if (code2 == ']') {
                TextWire.this.readCode();
                return TextWire.this;
            }
            tReader.accept(t, kls, TextWire.this.valueIn);
            if (code == '[') {
                TextWire.this.consumePadding();
                char code3 = (char)TextWire.this.readCode();
                if (code3 != ']') {
                    throw new IORuntimeException("Expected a ] but got " + code3 + " (" + code3 + ")");
                }
            }
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        public boolean hasNext() {
            TextWire.this.consumePadding();
            return TextWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            if (this.sequenceLimit-- <= 0) {
                return false;
            }
            TextWire.this.consumePadding();
            int ch = TextWire.this.peekCode();
            if (ch == 44) {
                TextWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            boolean endsNormally = false;
            try {
                long newLimit = position - 1L + len;
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                T apply = marshallableReader.apply(TextWire.this);
                endsNormally = true;
                T t = apply;
                return t;
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.consumePadding(1);
                code = TextWire.this.readCode();
                this.popState();
                if (code != 125 && endsNormally) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toString(TextWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            stringBuilder.setLength(0);
            if (code == -1) {
                stringBuilder.append("java.lang.Object");
            } else if (code == 33) {
                TextWire.this.readCode();
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.bytes.readSkip(-1L);
                TextWire.this.consumePadding();
            }
            return this;
        }

        @Override
        public Class typePrefix() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33 || code == 64) {
                TextWire.this.readCode();
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                stringBuilder.setLength(0);
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.bytes.readSkip(-1L);
                try {
                    return this.classLookup().forName(stringBuilder);
                }
                catch (ClassNotFoundRuntimeException e) {
                    Jvm.warn().on(this.getClass(), "Unable to find " + stringBuilder + " " + e.getCause());
                    return null;
                }
            }
            return null;
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                TextWire.this.readCode();
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                stringBuilder.setLength(0);
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.bytes.readSkip(-1L);
                try {
                    return this.classLookup().forName(stringBuilder);
                }
                catch (ClassNotFoundRuntimeException e) {
                    if (tClass == null) {
                        if (Wires.GENERATE_TUPLES) {
                            return Wires.tupleFor(null, stringBuilder.toString());
                        }
                        Jvm.warn().on(TextWire.class, "Unable to load " + stringBuilder + ", is a class alias missing.");
                        return null;
                    }
                    String className = tClass.getName();
                    String[] split = REGX_PATTERN.split(stringBuilder);
                    if (split[split.length - 1].equalsIgnoreCase(tClass.getSimpleName())) {
                        try {
                            return tClass.isInterface() ? Wires.tupleFor(tClass, stringBuilder.toString()) : this.classLookup().forName(className);
                        }
                        catch (ClassNotFoundRuntimeException e1) {
                            Jvm.warn().on(this.getClass(), "ClassNotFoundException class=" + className);
                            return Wires.tupleFor(tClass, className);
                        }
                    }
                    if (tClass.getClassLoader() == null) {
                        throw new IllegalArgumentException("Unable to find class " + stringBuilder);
                    }
                    return Wires.tupleFor(tClass, stringBuilder.toString());
                }
            }
            return Wires.dtoInterface(tClass) && Wires.GENERATE_TUPLES && ObjectUtils.implementationToUse(tClass) == tClass ? Wires.tupleFor(tClass, null) : null;
        }

        @Override
        public boolean isTyped() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            return code == 33;
        }

        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (!TextWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            TextWire.this.bytes.readSkip("type ".length());
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
            classNameConsumer.accept(t, stringBuilder);
            return TextWire.this;
        }

        @Override
        public ClassLookup classLookup() {
            return TextWire.this.classLookup();
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (!TextWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            TextWire.this.bytes.readSkip("type ".length());
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
            try {
                return this.classLookup().forName(stringBuilder);
            }
            catch (ClassNotFoundRuntimeException e) {
                return unresolvedHandler.apply(stringBuilder, e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            long position0 = TextWire.this.bytes.readPosition();
            if (this.isNull()) {
                TextWire.this.consumePadding(1);
                return null;
            }
            if (TextWire.this.indentation() == 0 && TextWire.this.peekCode() != 123) {
                strategy.readUsing(null, object, this, BracketType.UNKNOWN);
                return object;
            }
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.typePrefix(null, (o, x) -> {});
            } else {
                if (code == 44) {
                    Jvm.warn().on(this.getClass(), "Expected a {} but was blank for type " + object.getClass());
                    TextWire.this.readCode();
                    return object;
                }
                if (code != 123) {
                    this.consumeValue();
                    long position00 = TextWire.this.bytes.readPosition();
                    String s = ((Bytes)TextWire.this.bytes.readPosition(position0)).toDebugString(128L);
                    TextWire.this.bytes.readPosition(position00);
                    throw new IORuntimeException("Trying to read marshallable " + object.getClass() + " at " + s + " expected to find a {");
                }
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                object = strategy.readUsing(null, object, this, BracketType.MAP);
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            TextWire.this.consumePadding(1);
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString(TextWire.this.bytes, 1024L));
            }
            TextWire.this.consumePadding(1);
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Demarshallable demarshallable(@NotNull Class clazz) {
            Object object;
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.typePrefix(null, (o, x) -> {});
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + this.stringForCode(code));
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                object = Demarshallable.newInstance(clazz, TextWire.this);
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            TextWire.this.consumePadding(1);
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString(TextWire.this.bytes, 1024L));
            }
            return object;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() {
            return (T)this.objectWithInferredType(null, SerializationStrategies.ANY_NESTED, null);
        }

        @Nullable
        <K, V> Map<K, V> map(@NotNull Class<K> kClass, @NotNull Class<V> vClass, @Nullable Map<K, V> usingMap) {
            TextWire.this.consumePadding();
            if (usingMap == null) {
                usingMap = new LinkedHashMap();
            } else {
                usingMap.clear();
            }
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            int code = TextWire.this.peekCode();
            switch (code) {
                case 33: {
                    return this.typedMap(kClass, vClass, usingMap, stringBuilder);
                }
                case 123: {
                    return this.marshallableAsMap(kClass, vClass, usingMap);
                }
                case 63: {
                    return TextWire.this.readAllAsMap(kClass, vClass, usingMap);
                }
            }
            throw new IORuntimeException("Unexpected code " + (char)code);
        }

        @Nullable
        private <K, V> Map<K, V> typedMap(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap, @NotNull StringBuilder sb) {
            TextWire.this.parseUntil(sb, StopCharTesters.SPACE_STOP);
            @Nullable String str = WireInternal.INTERNER.intern(sb);
            if ("!!null".contentEquals(sb)) {
                this.text();
                return null;
            }
            if ("!!seqmap".contentEquals(sb)) {
                TextWire.this.consumePadding();
                int start = TextWire.this.readCode();
                if (start != 91) {
                    throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                }
                do {
                    this.marshallable((WireIn r) -> {
                        @Nullable E k = r.read(() -> "key").object(kClazz);
                        @Nullable @Nullable E v = r.read(() -> "value").object(vClass);
                        usingMap.put(k, v);
                    });
                } while (this.hasNextSequenceItem());
                return usingMap;
            }
            throw new IORuntimeException("Unsupported type :" + str);
        }

        @Override
        public boolean bool() {
            TextWire.this.consumePadding();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                throw new NullPointerException("value is null");
            }
            if (ObjectUtils.isTrue(stringBuilder)) {
                return true;
            }
            if (ObjectUtils.isFalse(stringBuilder)) {
                return false;
            }
            Jvm.debug().on(this.getClass(), "Unable to parse '" + stringBuilder + "' as a boolean flag, assuming false");
            return false;
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            TextWire.this.consumePadding();
            TextWire.this.valueIn.skipType();
            switch (TextWire.this.peekCode()) {
                case 91: 
                case 123: {
                    Jvm.warn().on(this.getClass(), "Unable to read " + TextWire.this.valueIn.object() + " as a long.");
                    return 0L;
                }
            }
            long l = this.getALong();
            this.checkRewind();
            return l;
        }

        public void checkRewind() {
            int ch = this.peekBack();
            if (END_CHARS.get(ch)) {
                TextWire.this.bytes.readSkip(-1L);
            }
        }

        public void checkRewindDouble() {
            this.checkRewind();
        }

        @Override
        public double float64() {
            TextWire.this.consumePadding();
            TextWire.this.valueIn.skipType();
            switch (TextWire.this.peekCode()) {
                case 36: {
                    this.unsubstitutedNumber();
                    return 0.0;
                }
                case 91: 
                case 123: {
                    Jvm.warn().on(this.getClass(), "Unable to read " + TextWire.this.valueIn.object() + " as a double.");
                    return 0.0;
                }
            }
            double v = TextWire.this.bytes.parseDouble();
            this.checkRewindDouble();
            return v;
        }

        void skipType() {
            long peek = TextWire.this.bytes.peekUnsignedByte();
            if (peek == 33L) {
                StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
                TextWire.this.parseUntil(stringBuilder, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.consumePadding();
            }
        }

        @Override
        public float float32() {
            return (float)this.float64();
        }

        @Override
        public boolean isNull() {
            TextWire.this.consumePadding();
            if (TextWire.this.peekStringIgnoreCase("!!null \"\"")) {
                TextWire.this.bytes.readSkip("!!null \"\"".length());
                TextWire.this.consumePadding(1);
                return true;
            }
            return false;
        }

        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class type) {
            TextWire.this.consumePadding();
            @Nullable Object o = this.objectWithInferredType0(using, strategy, type);
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 58 && strategy.bracketType() != BracketType.NONE) {
                return this.readRestOfMap(using, o);
            }
            return o;
        }

        @NotNull
        Object readRestOfMap(Object using, Object o) {
            TextWire.this.readCode();
            TextWire.this.consumePadding();
            @Nullable Object value = this.objectWithInferredType0(using, SerializationStrategies.ANY_OBJECT, Object.class);
            @NotNull Map<K, V> map = using instanceof Map ? (Map)using : new LinkedHashMap();
            map.put(o, value);
            TextWire.this.readAllAsMap(Object.class, Object.class, map);
            return map;
        }

        @Nullable
        Object objectWithInferredType0(Object using, @NotNull SerializationStrategy strategy, Class type) {
            int code = TextWire.this.peekCode();
            switch (code) {
                case 63: {
                    return this.map(Object.class, Object.class, (Map)using);
                }
                case 33: {
                    return this.object(using, type);
                }
                case 45: {
                    if (TextWire.this.peekCodeNext() == 32) {
                        return TextWire.this.readList(TextWire.this.indentation(), null);
                    }
                    return TextWire.this.valueIn.readNumber();
                }
                case 91: {
                    return this.readSequence(strategy.type());
                }
                case 123: {
                    return TextWire.this.valueIn.marshallableAsMap(Object.class, Object.class);
                }
                case 93: {
                    throw new IORuntimeException("Unexpected ] at " + TextWire.this.bytes.toDebugString(32L));
                }
                case 125: {
                    throw new IORuntimeException("Unexpected } at " + TextWire.this.bytes.toDebugString(32L));
                }
                case 43: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return TextWire.this.valueIn.readNumber();
                }
            }
            if (using instanceof Bytes) {
                return TextWire.this.valueIn.textTo((Bytes)using);
            }
            if (using instanceof StringBuilder) {
                return TextWire.this.valueIn.textTo((StringBuilder)using);
            }
            @Nullable String text = TextWire.this.valueIn.text();
            if (text == null || Enum.class.isAssignableFrom(strategy.type())) {
                return text;
            }
            switch (text) {
                case "true": {
                    return Boolean.TRUE;
                }
                case "false": {
                    return Boolean.FALSE;
                }
            }
            return text;
        }

        @Nullable
        protected Object readNumber() {
            String s;
            @Nullable String ss = s = this.text();
            if (s == null || s.length() > 40) {
                return s;
            }
            if (s.contains("_")) {
                ss = s.replace("_", "");
            }
            try {
                return Long.decode(ss);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(ss);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        if (s.length() == 7 && s.charAt(1) == ':') {
                            return LocalTime.parse("0" + s);
                        }
                        if (s.length() == 8 && s.charAt(2) == ':') {
                            return LocalTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() == 10) {
                            return LocalDate.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() >= 22) {
                            return ZonedDateTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    return s;
                }
            }
        }

        @NotNull
        private Object readSequence(@NotNull Class clazz) {
            if (clazz == Object[].class || clazz == Object.class) {
                Object @NotNull [] list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.object(Object.class));
                    }
                });
                return clazz == Object[].class ? list.toArray() : list;
            }
            if (clazz == String[].class) {
                @NotNull ArrayList<E> list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list.toArray(new String[0]);
            }
            if (clazz == List.class) {
                @NotNull ArrayList<E> list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list;
            }
            if (clazz == Set.class) {
                @NotNull HashSet<E> list = new HashSet();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list;
            }
            throw new UnsupportedOperationException("Arrays of type " + clazz + " not supported.");
        }

        public String toString() {
            return TextWire.this.toString();
        }
    }

    @Deprecated
    class TextValueOut
    implements ValueOut,
    CommentAnnotationNotifier {
        protected boolean hasCommentAnnotation = false;
        protected int indentation = 0;
        @NotNull
        protected List<BytesStore> seps = new ArrayList<BytesStore>(4);
        @NotNull
        protected BytesStore sep = BytesStore.empty();
        protected boolean leaf = false;
        protected boolean dropDefault = false;
        @Nullable
        private String eventName;

        TextValueOut() {
        }

        @Override
        public void hasPrecedingComment(boolean hasCommentAnnotation) {
            this.hasCommentAnnotation = hasCommentAnnotation;
        }

        @Override
        public void resetState() {
            this.indentation = 0;
            this.seps.clear();
            this.sep = BytesStore.empty();
            this.leaf = false;
            this.dropDefault = false;
            this.eventName = null;
        }

        void prependSeparator() {
            this.appendSep();
            this.sep = BytesStore.empty();
        }

        protected void appendSep() {
            TextWire.this.append(this.sep);
            this.trimWhiteSpace();
            if (TextWire.this.bytes.endsWith('\n') || this.sep == EMPTY_AFTER_COMMENT) {
                this.indent();
            }
        }

        protected void trimWhiteSpace() {
            long wp = TextWire.this.bytes.writePosition();
            if (TextWire.this.bytes.peekUnsignedByte(wp - 1L) == 10 && TextWire.this.bytes.peekUnsignedByte(wp - 2L) == 10) {
                TextWire.this.bytes.writeSkip(-1L);
            }
        }

        @Override
        public boolean swapLeaf(boolean isLeaf) {
            if (isLeaf == this.leaf) {
                return this.leaf;
            }
            this.leaf = isLeaf;
            if (!isLeaf && this.sep.startsWith(',')) {
                this.elementSeparator();
            }
            return !this.leaf;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return TextWire.this;
        }

        protected void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                TextWire.this.bytes.writeUnsignedShort(8224);
            }
        }

        public void elementSeparator() {
            if (this.indentation == 0) {
                if (this.leaf) {
                    this.sep = COMMA_SPACE;
                } else {
                    this.sep = BytesStore.empty();
                    TextWire.this.bytes.writeUnsignedByte(10);
                }
            } else {
                this.sep = this.leaf ? COMMA_SPACE : COMMA_NEW_LINE;
            }
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (this.dropDefault) {
                if (flag == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.append(flag == null ? this.nullOut() : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public String nullOut() {
            return "!!null \"\"";
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (this.dropDefault) {
                if (s == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            if (s == null) {
                TextWire.this.append(this.nullOut());
            } else {
                TextWire.this.escape(s);
            }
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (this.dropDefault) {
                if (fromBytes == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (this.isText(fromBytes)) {
                return this.text(fromBytes);
            }
            int length = Maths.toInt32(fromBytes.readRemaining());
            @NotNull byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut rawText(CharSequence value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        private boolean isText(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            return this.bytes("!binary", byteArray);
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull String type, byte[] byteArray) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            this.typePrefix(type);
            if (this.getClass() != TextValueOut.class) {
                TextWire.this.bytes.append('\"');
            }
            TextWire.this.append(Base64.getEncoder().encodeToString(byteArray));
            if (this.getClass() != TextValueOut.class) {
                TextWire.this.bytes.append('\"');
            }
            this.elementSeparator();
            this.endTypePrefix();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull String type, @Nullable BytesStore bytesStore) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (bytesStore == null) {
                return this.nu11();
            }
            this.prependSeparator();
            this.typePrefix(type);
            TextWire.this.append(Base64.getEncoder().encodeToString(bytesStore.toByteArray()));
            this.endTypePrefix();
            TextWire.this.append(END_FIELD);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            if (this.dropDefault) {
                if (i8 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(i8);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            if (this.dropDefault) {
                if (u8 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(u8);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            if (this.dropDefault) {
                if (i16 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(i16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            if (this.dropDefault) {
                if (u16 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(u16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            if (this.dropDefault) {
                if (codepoint == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            StringBuilder stringBuilder = TextWire.this.acquireStringBuilder();
            stringBuilder.appendCodePoint(codepoint);
            this.text(stringBuilder);
            this.sep = BytesStore.empty();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            if (this.dropDefault) {
                if (i32 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(i32);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            if (this.dropDefault) {
                if (u32 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(u32);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            boolean addTimeStamp;
            if (this.dropDefault) {
                if (i64 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.append(i64);
            this.elementSeparator();
            boolean bl = addTimeStamp = TextWire.this.addTimeStamps && !this.leaf;
            if (addTimeStamp) {
                this.addTimeStamp(i64);
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int128forBinding(long i64x0, long i64x1, TwoLongValue longValue) {
            throw new UnsupportedOperationException("todo");
        }

        public void addTimeStamp(long i64) {
            if (1000000000000L < i64 && i64 < 4111000000000L) {
                TextWire.this.bytes.append(", # ");
                TextWire.this.bytes.appendDateMillis(i64);
                TextWire.this.bytes.append("T");
                TextWire.this.bytes.appendTimeMillis(i64);
                this.sep = NEW_LINE;
            } else if (1000000000000000000L < i64 && i64 < 4111000000000000000L) {
                long millis = i64 / 1000000L;
                long nanos = i64 % 1000000L;
                TextWire.this.bytes.append(", # ");
                TextWire.this.bytes.appendDateMillis(millis);
                TextWire.this.bytes.append("T");
                TextWire.this.bytes.appendTimeMillis(millis);
                TextWire.this.bytes.append((char)(48L + nanos / 100000L));
                TextWire.this.bytes.append((char)(48L + nanos / 100000L % 10L));
                TextWire.this.bytes.append((char)(48L + nanos / 10000L % 10L));
                TextWire.this.bytes.append((char)(48L + nanos / 1000L % 10L));
                TextWire.this.bytes.append((char)(48L + nanos / 100L % 10L));
                TextWire.this.bytes.append((char)(48L + nanos / 10L % 10L));
                TextWire.this.bytes.append((char)(48L + nanos % 10L));
                this.sep = NEW_LINE;
            }
        }

        @Override
        @NotNull
        public WireOut int64_0x(long i64) {
            if (this.dropDefault) {
                if (i64 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            ((Bytes)((Bytes)TextWire.this.bytes.writeUnsignedByte(48)).writeUnsignedByte(120)).appendBase16(i64);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            TextLongArrayReference.write(TextWire.this.bytes, capacity);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            long pos = TextWire.this.bytes.writePosition();
            TextLongArrayReference.write(TextWire.this.bytes, capacity);
            ((Byteable)((Object)values)).bytesStore(TextWire.this.bytes, pos, TextWire.this.bytes.lengthWritten(pos));
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            if (this.dropDefault) {
                if (f == 0.0f) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            double af = Math.abs(f);
            if (af >= 0.001 && af < 1000000.0) {
                TextWire.this.bytes.append(f);
            } else {
                TextWire.this.bytes.append(this.floatToString(f));
            }
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            if (this.dropDefault) {
                if (d == 0.0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            double ad = Math.abs(d);
            if (ad >= 1.0E-7 && ad < 1.0E15) {
                if ((double)((int)(ad / 1000000.0)) * 1000000.0 == ad) {
                    ((Bytes)TextWire.this.bytes.append((int)(d / 1000000.0))).append("E6");
                } else if ((double)((int)(ad / 1000.0)) * 1000.0 == ad) {
                    ((Bytes)TextWire.this.bytes.append((int)(d / 1000.0))).append("E3");
                } else if (ad < 0.001) {
                    double d7 = (double)Math.round(d * 1.0E16) / 1.0E9;
                    double ad7 = Math.abs(d7);
                    if (ad7 < 10.0) {
                        ((Bytes)TextWire.this.bytes.append(d7)).append("E-7");
                    } else if (ad7 < 100.0) {
                        ((Bytes)TextWire.this.bytes.append(d7 / 10.0)).append("E-6");
                    } else if (ad7 < 1000.0) {
                        ((Bytes)TextWire.this.bytes.append(d7 / 100.0)).append("E-5");
                    } else if (ad7 < 10000.0) {
                        ((Bytes)TextWire.this.bytes.append(d7 / 1000.0)).append("E-4");
                    } else {
                        ((Bytes)TextWire.this.bytes.append(d7 / 10000.0)).append("E-3");
                    }
                } else {
                    TextWire.this.bytes.append(d);
                }
            } else {
                TextWire.this.bytes.append(this.doubleToString(d));
            }
            this.elementSeparator();
            return TextWire.this;
        }

        protected String doubleToString(double d) {
            return Double.toString(d);
        }

        protected String floatToString(float f) {
            return Float.toString(f);
        }

        @Override
        @NotNull
        public WireOut time(LocalTime localTime) {
            return this.asText(localTime);
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@Nullable ZonedDateTime zonedDateTime) {
            String s;
            if (zonedDateTime == null) {
                return this.nu11();
            }
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            return (s = zonedDateTime.toString()).endsWith("]") ? this.text(s) : this.asText(s);
        }

        @Override
        @NotNull
        public WireOut date(LocalDate localDate) {
            return this.asText(localDate);
        }

        @Override
        @NotNull
        public WireOut dateTime(LocalDateTime localDateTime) {
            return this.asText(localDateTime);
        }

        @NotNull
        private WireOut asText(@Nullable Object stringable) {
            if (this.dropDefault) {
                if (stringable == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (stringable == null) {
                this.nu11();
            } else {
                this.prependSeparator();
                String s = stringable.toString();
                Quotes quotes = TextWire.this.needsQuotesEscaped(s);
                this.asTestQuoted(s, quotes);
                this.elementSeparator();
            }
            return TextWire.this;
        }

        protected void asTestQuoted(String s, Quotes quotes) {
            if (quotes == Quotes.NONE) {
                TextWire.this.append(s);
            } else {
                TextWire.this.escape0(s, quotes);
            }
        }

        @Override
        @NotNull
        public ValueOut optionalTyped(Class aClass) {
            return this.typePrefix(aClass);
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.bytes.writeUnsignedByte(33);
            TextWire.this.append(typeName);
            TextWire.this.bytes.writeUnsignedByte(32);
            this.sep = BytesStore.empty();
            return this;
        }

        @Override
        public ClassLookup classLookup() {
            return TextWire.this.classLookup();
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes<?>> typeTranslator, Class type) {
            if (this.dropDefault) {
                if (type == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextWire.this.append(TYPE);
            typeTranslator.accept(type, TextWire.this.bytes);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@Nullable CharSequence type) {
            if (this.dropDefault) {
                if (type == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (type == null) {
                return this.nu11();
            }
            this.prependSeparator();
            TextWire.this.append(TYPE);
            TextWire.this.escape(type);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            return this.asText(uuid);
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextIntReference.write(TextWire.this.bytes, value);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!(intValue instanceof TextIntReference)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = TextWire.this.bytes.writePosition();
            TextIntReference.write(TextWire.this.bytes, value);
            long length = TextWire.this.bytes.lengthWritten(offset);
            ((Byteable)((Object)intValue)).bytesStore(TextWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextLongReference.write(TextWire.this.bytes, value);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!(longValue instanceof TextLongReference)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = TextWire.this.bytes.writePosition();
            TextLongReference.write(TextWire.this.bytes, value);
            long length = TextWire.this.bytes.lengthWritten(offset);
            ((Byteable)((Object)longValue)).bytesStore(TextWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut boolForBinding(boolean value, @NotNull BooleanValue longValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!(longValue instanceof TextBooleanReference)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = TextWire.this.bytes.writePosition();
            TextBooleanReference.write(value, TextWire.this.bytes, offset);
            long length = TextWire.this.bytes.lengthWritten(offset);
            ((Byteable)((Object)longValue)).bytesStore(TextWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, @NotNull BiConsumer<T, ValueOut> writer) {
            this.startBlock('[');
            boolean leaf = this.leaf;
            if (!leaf) {
                this.newLine();
            } else {
                TextWire.this.bytes.writeUnsignedByte(32);
            }
            long pos = TextWire.this.bytes.writePosition();
            writer.accept(t, this);
            if (!leaf) {
                this.addNewLine(pos);
            }
            this.popState();
            this.leaf = leaf;
            if (!leaf) {
                this.indent();
            } else {
                this.addSpace(pos);
            }
            this.endBlock(this.leaf, ']');
            return this.wireOut();
        }

        public void startBlock(char c) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!this.sep.isEmpty()) {
                TextWire.this.append(this.sep);
                this.trimWhiteSpace();
                this.indent();
                this.sep = EMPTY;
            }
            this.pushState();
            TextWire.this.bytes.writeUnsignedByte(c);
        }

        @Override
        @NotNull
        public <T, K> WireOut sequence(T t, K kls, @NotNull TriConsumer<T, K, ValueOut> writer) {
            boolean leaf = this.leaf;
            this.startBlock('[');
            if (leaf) {
                this.sep = SPACE;
            } else {
                this.newLine();
            }
            long pos = TextWire.this.bytes.readPosition();
            writer.accept(t, kls, this);
            if (leaf) {
                this.addSpace(pos);
            } else {
                this.addNewLine(pos);
            }
            this.popState();
            if (!leaf) {
                this.indent();
            }
            this.endBlock(this.leaf, ']');
            return this.wireOut();
        }

        public void endBlock(boolean leaf, char c) {
            TextWire.this.bytes.writeUnsignedByte(c);
            this.sep = leaf ? COMMA_SPACE : COMMA_NEW_LINE;
        }

        protected void addNewLine(long pos) {
            if (TextWire.this.bytes.writePosition() > pos + 1L) {
                TextWire.this.bytes.writeUnsignedByte(10);
            }
        }

        protected void addSpace(long pos) {
            if (TextWire.this.bytes.writePosition() > pos + 1L) {
                TextWire.this.bytes.writeUnsignedByte(32);
            }
        }

        protected void newLine() {
            this.sep = NEW_LINE;
        }

        protected void popState() {
            this.sep = this.seps.remove(this.seps.size() - 1);
            --this.indentation;
            this.leaf = false;
            this.dropDefault = false;
        }

        protected void pushState() {
            ++this.indentation;
            this.seps.add(this.sep);
            this.sep = EMPTY;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(object.getClass());
            boolean wasLeaf0 = this.leaf;
            if (this.indentation > 1 && wm.isLeaf()) {
                this.leaf = true;
            }
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (TextWire.this.trimFirstCurly && TextWire.this.bytes.writePosition() == 0L) {
                object.writeMarshallable(TextWire.this);
                if (TextWire.this.bytes.writePosition() == 0L) {
                    TextWire.this.bytes.append("{}");
                }
                return TextWire.this;
            }
            boolean wasLeaf = this.leaf;
            this.startBlock('{');
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            object.writeMarshallable(TextWire.this);
            BytesStore popSep = null;
            if (wasLeaf) {
                if (this.sep.endsWith(' ')) {
                    TextWire.this.append(" ");
                }
                this.trimWhiteSpace();
                this.leaf = false;
                this.popState();
            } else if (!this.seps.isEmpty()) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.newLine();
            }
            if (this.sep.startsWith(',')) {
                TextWire.this.append(this.sep, 1, this.sep.length() - 1);
                this.trimWhiteSpace();
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            this.endBlock(this.leaf, '}');
            this.leaf = wasLeaf0;
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (TextWire.this.bytes.writePosition() == 0L) {
                this.writeSerializable(object);
                return TextWire.this;
            }
            boolean wasLeaf = this.leaf;
            if (!wasLeaf) {
                this.pushState();
            }
            this.prependSeparator();
            TextWire.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 91 : 123);
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            this.writeSerializable(object);
            @Nullable BytesStore popSep = null;
            if (wasLeaf) {
                this.leaf = false;
            } else if (this.seps.size() > 0) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.newLine();
            }
            if (this.sep.startsWith(',')) {
                TextWire.this.append(this.sep, 1, this.sep.length() - 1);
                this.trimWhiteSpace();
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            TextWire.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 93 : 125);
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return TextWire.this;
        }

        private void writeSerializable(@NotNull Serializable object) {
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(TextWire.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, TextWire.this);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        protected void afterClose() {
            this.newLine();
            this.appendSep();
        }

        protected void afterOpen() {
            this.sep = SPACE;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.marshallable(map, Object.class, Object.class, false);
            return TextWire.this;
        }

        protected void endField() {
            this.sep = END_FIELD;
        }

        protected void fieldValueSeperator() {
            TextWire.this.writeTwo(':', ' ');
        }

        @NotNull
        public ValueOut write() {
            if (this.dropDefault) {
                this.eventName = "";
            } else {
                this.appendSep();
                TextWire.this.writeTwo('\"', '\"');
                this.endEvent();
            }
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            if (this.dropDefault) {
                this.eventName = key.name().toString();
            } else {
                this.write(key.name());
            }
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull CharSequence name) {
            if (this.dropDefault) {
                this.eventName = name.toString();
            } else {
                this.prependSeparator();
                TextWire.this.escape(name);
                this.fieldValueSeperator();
            }
            return this;
        }

        @NotNull
        public ValueOut write(Class expectedType, @NotNull Object objectKey) {
            if (this.dropDefault) {
                if (expectedType != String.class) {
                    throw new UnsupportedOperationException();
                }
                this.eventName = objectKey.toString();
            } else {
                this.prependSeparator();
                TextWire.this.writeStartEvent();
                this.object(expectedType, objectKey);
                this.endEvent();
            }
            return this;
        }

        private void writeSavedEventName() {
            if (this.eventName == null) {
                return;
            }
            this.prependSeparator();
            TextWire.this.escape(this.eventName);
            this.fieldValueSeperator();
            this.eventName = null;
        }

        public void endEvent() {
            if (TextWire.this.bytes.readByte(TextWire.this.bytes.writePosition() - 1L) <= 32) {
                TextWire.this.bytes.writeSkip(-1L);
            }
            this.fieldValueSeperator();
            this.sep = BytesStore.empty();
        }

        public void writeComment(@NotNull CharSequence s) {
            if (this.hasCommentAnnotation) {
                if (!this.sep.endsWith('\n')) {
                    return;
                }
                this.sep = COMMA_SPACE;
            }
            this.prependSeparator();
            if (this.hasCommentAnnotation) {
                TextWire.this.writeTwo('\t', '\t');
            }
            TextWire.this.writeTwo('#', ' ');
            TextWire.this.append(s);
            TextWire.this.bytes.writeUnsignedByte(10);
            this.sep = EMPTY_AFTER_COMMENT;
        }
    }

    static enum NoObject {
        NO_OBJECT;

    }
}

