/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testFirstLowerCase() {
        Assert.assertEquals((Object)"", (Object)StringUtils.firstLowerCase(""));
        Assert.assertEquals((Object)"99", (Object)StringUtils.firstLowerCase("99"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.firstLowerCase("A"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.firstLowerCase("a"));
        Assert.assertEquals((Object)"aA", (Object)StringUtils.firstLowerCase("AA"));
        Assert.assertEquals((Object)"aa", (Object)StringUtils.firstLowerCase("Aa"));
    }

    @Test
    public void testToTitleCase() {
        Assert.assertEquals((Object)"", (Object)StringUtils.toTitleCase(""));
        Assert.assertEquals((Object)"99", (Object)StringUtils.toTitleCase("99"));
        Assert.assertEquals((Object)"A", (Object)StringUtils.toTitleCase("A"));
        Assert.assertEquals((Object)"A", (Object)StringUtils.toTitleCase("a"));
        Assert.assertEquals((Object)"AA", (Object)StringUtils.toTitleCase("AA"));
        Assert.assertEquals((Object)"AA", (Object)StringUtils.toTitleCase("Aa"));
        Assert.assertEquals((Object)"AAA", (Object)StringUtils.toTitleCase("AAA"));
        Assert.assertEquals((Object)"AA_A", (Object)StringUtils.toTitleCase("AaA"));
        Assert.assertEquals((Object)"A_AA", (Object)StringUtils.toTitleCase("AAa"));
        Assert.assertEquals((Object)"AAA", (Object)StringUtils.toTitleCase("Aaa"));
        Assert.assertEquals((Object)"AAAA", (Object)StringUtils.toTitleCase("AAAA"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase("AaAA"));
        Assert.assertEquals((Object)"A_AA_A", (Object)StringUtils.toTitleCase("AAaA"));
        Assert.assertEquals((Object)"AAA_A", (Object)StringUtils.toTitleCase("AaaA"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase("AAAa"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase("AaAa"));
        Assert.assertEquals((Object)"A_AAA", (Object)StringUtils.toTitleCase("AAaa"));
        Assert.assertEquals((Object)"AAAA", (Object)StringUtils.toTitleCase("Aaaa"));
    }

    @Test
    public void shouldGetCharsOfStringBuilder() {
        StringBuilder sb = new StringBuilder(11).append("foobar_nine");
        char[] chars = StringUtils.extractChars(sb);
        Assert.assertEquals((Object)sb.toString(), (Object)new String(chars));
    }

    @Test
    public void shouldGetCharsOfString() {
        String s = "foobar_nine";
        char[] chars = StringUtils.extractChars("foobar_nine");
        Assert.assertEquals((Object)"foobar_nine", (Object)new String(chars));
    }

    @Test
    public void shouldExtractBytesFromString() {
        Assume.assumeTrue((boolean)Jvm.isJava9Plus());
        MatcherAssert.assertThat((String)"Is this test running on JDK9 with compact strings disabled?", (Object)StringUtils.extractBytes("foobar"), (Matcher)CoreMatchers.is((Object)"foobar".getBytes(StandardCharsets.US_ASCII)));
    }

    @Ignore(value="picks up dead chars at end of string builder value array")
    @Test
    public void shouldExtractBytesFromStringBuilder() {
        Assume.assumeTrue((boolean)Jvm.isJava9Plus());
        MatcherAssert.assertThat((String)"Is this test running on JDK9 with compact strings disabled?", (Object)StringUtils.extractBytes(new StringBuilder("foobar")), (Matcher)CoreMatchers.is((Object)"foobar".getBytes(StandardCharsets.US_ASCII)));
    }

    @Test
    public void shouldCreateNewStringFromChars() {
        char[] chars = new char[]{'A', 'B', 'C'};
        Assert.assertEquals((Object)new String(chars), (Object)StringUtils.newString(chars));
    }

    @Test
    public void shouldCreateNewStringFromBytes() {
        Assume.assumeTrue((boolean)Jvm.isJava9Plus());
        byte[] bytes = new byte[]{65, 66, 67};
        Assert.assertEquals((Object)StringUtils.newStringFromBytes(bytes), (Object)new String(bytes));
    }

    @Test
    public void testParseDouble() {
        for (double d : new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, -1.0, 1.0, 9999.0}) {
            Assert.assertEquals((double)d, (double)StringUtils.parseDouble(Double.toString(d)), (double)0.0);
        }
        Assert.assertEquals((double)1.0, (double)StringUtils.parseDouble("1"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)StringUtils.parseDouble("-0"), (double)0.0);
        Assert.assertEquals((double)123.0, (double)StringUtils.parseDouble("123"), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)StringUtils.parseDouble("-1"), (double)0.0);
    }

    @Test
    public void testIsEqual() {
        StringBuilder emptySb = new StringBuilder();
        Assert.assertTrue((boolean)StringUtils.isEqual(emptySb, (CharSequence)emptySb));
        Assert.assertTrue((boolean)StringUtils.isEqual(null, null));
        Assert.assertFalse((boolean)StringUtils.isEqual(emptySb, null));
        Assert.assertFalse((boolean)StringUtils.isEqual(null, (CharSequence)emptySb));
        Assert.assertFalse((boolean)StringUtils.isEqual(new StringBuilder(), (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.isEqual(new StringBuilder().append("a"), (CharSequence)"b"));
        Assert.assertFalse((boolean)StringUtils.isEqual(new StringBuilder().append("test"), (CharSequence)"Test"));
        Assert.assertTrue((boolean)StringUtils.isEqual(new StringBuilder().append("TheSame"), (CharSequence)"TheSame"));
        Assert.assertFalse((boolean)StringUtils.isEqual(new StringBuilder().append("\u0394"), (CharSequence)"\u0393"));
        Assert.assertFalse((boolean)StringUtils.isEqual(new StringBuilder().append("\u0394\u0394\u0394\u0394\u0394"), (CharSequence)"\u0394\u0394\u20ac\u0394\u0394"));
        Assert.assertTrue((boolean)StringUtils.isEqual(new StringBuilder().append("\u0394\u0394\u0394\u0394\u0394"), (CharSequence)"\u0394\u0394\u0394\u0394\u0394"));
        Assert.assertTrue((boolean)StringUtils.isEqual(new StringBuilder(), (CharSequence)""));
    }
}

