/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.LongTime;
import org.junit.Assert;
import org.junit.Test;

public class LongTimeTest {
    @Test
    public void secs() {
        long epoch = 0L;
        Assert.assertTrue((boolean)LongTime.isSecs(epoch));
        Assert.assertTrue((boolean)LongTime.isSecs(9223372036L));
        Assert.assertFalse((boolean)LongTime.isSecs(9223372037L));
        Assert.assertTrue((boolean)LongTime.isSecs(0x8CBCCCL));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs(LongTime.toSecs(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs(LongTime.toMillis(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs(LongTime.toMicros(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs(LongTime.toNanos(epoch)));
    }

    @Test
    public void millis() {
        long epoch = 9223372037L;
        Assert.assertTrue((boolean)LongTime.isMillis(epoch));
        Assert.assertTrue((boolean)LongTime.isMillis(9223372036854L));
        Assert.assertFalse((boolean)LongTime.isMillis(9223372037000L));
        Assert.assertTrue((boolean)LongTime.isMillis(9223372036000L));
        Assert.assertTrue((boolean)LongTime.isMillis(9223372037L));
        Assert.assertEquals((long)(epoch - epoch % 1000L), (long)LongTime.toMillis(LongTime.toSecs(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMillis(LongTime.toMillis(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMillis(LongTime.toMicros(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMillis(LongTime.toNanos(epoch)));
    }

    @Test
    public void micros() {
        long epoch = 9223372037000L;
        Assert.assertTrue((boolean)LongTime.isMicros(epoch));
        Assert.assertTrue((boolean)LongTime.isMicros(9223372036854775L));
        Assert.assertFalse((boolean)LongTime.isMicros(9223372037000000L));
        Assert.assertTrue((boolean)LongTime.isMicros(9223372036854000L));
        Assert.assertTrue((boolean)LongTime.isMicros(9223372037000L));
        Assert.assertEquals((long)(epoch - epoch % 1000000L), (long)LongTime.toMicros(LongTime.toSecs(epoch)));
        Assert.assertEquals((long)(epoch - epoch % 1000L), (long)LongTime.toMicros(LongTime.toMillis(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMicros(LongTime.toMicros(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMicros(LongTime.toNanos(epoch)));
    }

    @Test
    public void nanos() {
        long epoch = 9223372037000000L;
        Assert.assertTrue((boolean)LongTime.isNanos(epoch));
        Assert.assertTrue((boolean)LongTime.isNanos(Long.MAX_VALUE));
        Assert.assertTrue((boolean)LongTime.isNanos(9223372036854775000L));
        Assert.assertEquals((long)(epoch - epoch % 1000000000L), (long)LongTime.toNanos(LongTime.toSecs(epoch)));
        Assert.assertEquals((long)(epoch - epoch % 1000000L), (long)LongTime.toNanos(LongTime.toMillis(epoch)));
        Assert.assertEquals((long)(epoch - epoch % 1000L), (long)LongTime.toNanos(LongTime.toMicros(epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toNanos(LongTime.toNanos(epoch)));
    }
}

