/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.pool.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class StringInternerTest {
    private String[] uppercase;

    @Test
    public void testIntern() throws IllegalArgumentException {
        @NotNull StringInterner si = new StringInterner(128);
        for (int i = 0; i < 100; ++i) {
            si.intern("" + i);
        }
        Assert.assertEquals((long)82L, (long)si.valueCount());
    }

    @Test
    public void testInternIndex() throws IllegalArgumentException {
        @NotNull StringInterner si = new StringInterner(128);
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)("" + i), (Object)si.get(si.index("" + i, null)));
        }
    }

    @Test
    public void testToUppercaseInternIndex() throws IllegalArgumentException {
        @NotNull StringInterner si = new StringInterner(128);
        this.uppercase = new String[si.capacity()];
        for (int i = 0; i < 100; ++i) {
            String lowerCaseString = this.randomLowercaseString();
            System.out.println(lowerCaseString.toString());
            int index = si.index(lowerCaseString, this::changed);
            if (index == -1) continue;
            Assert.assertEquals((Object)lowerCaseString.toUpperCase(), (Object)this.uppercase[index]);
        }
    }

    private void changed(int index, String value) {
        this.uppercase[index] = value.toUpperCase();
    }

    private String randomLowercaseString() {
        String CHARS = "abcdefghijklmnopqrstuvwxyz";
        StringBuilder sb = new StringBuilder();
        int count = 1 + (int)(Math.random() * 10.0);
        for (int i = 0; i < count; ++i) {
            sb.append("abcdefghijklmnopqrstuvwxyz".charAt((int)(Math.random() * (double)"abcdefghijklmnopqrstuvwxyz".length())));
        }
        return sb.toString();
    }
}

