/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.core.io.Closeable;
import org.junit.Assert;
import org.junit.Test;

public class CloseableTest {
    @Test
    public void closeQuietlyHandlesNull() {
        CloseableImpl closeable = new CloseableImpl();
        Closeable.closeQuietly(null, null, null, closeable);
        Assert.assertTrue((boolean)closeable.wasClosed);
    }

    @Test
    public void closeQuietlyCallsCloseOnAutoCloseable() {
        AutoCloseableImpl autoCloseable = new AutoCloseableImpl();
        Closeable.closeQuietly((Object)autoCloseable);
        Assert.assertTrue((boolean)autoCloseable.wasClosed);
    }

    @Test
    public void closeQuietlyCallsCloseOnCloseable() {
        CloseableImpl closeable = new CloseableImpl();
        Closeable.closeQuietly((Object)closeable);
        Assert.assertTrue((boolean)closeable.wasClosed);
    }

    @Test
    public void closeQuietlyClosesCollections() {
        List<CloseableImpl> closeables = Arrays.asList(new CloseableImpl(), new CloseableImpl(), new CloseableImpl(), new CloseableImpl());
        Closeable.closeQuietly(closeables);
        for (CloseableImpl closeable : closeables) {
            Assert.assertTrue((boolean)closeable.wasClosed);
        }
    }

    @Test
    public void closeQuietlyClosesReferences() {
        CloseableImpl closeable = new CloseableImpl();
        SoftReference<CloseableImpl> closeableRef = new SoftReference<CloseableImpl>(closeable);
        Closeable.closeQuietly(closeableRef);
        Assert.assertTrue((boolean)closeable.wasClosed);
    }

    @Test
    public void closeQuietlyClosesRecursively() {
        CloseableImpl closeable1 = new CloseableImpl();
        CloseableImpl closeable2 = new CloseableImpl();
        CloseableImpl closeable3 = new CloseableImpl();
        CloseableImpl closeable4 = new CloseableImpl();
        SoftReference<List<List>> structure = new SoftReference<List<List>>(Arrays.asList(Arrays.asList(closeable1, closeable2), Arrays.asList(closeable3, closeable4)));
        Closeable.closeQuietly(structure);
        Assert.assertTrue((boolean)closeable1.wasClosed);
        Assert.assertTrue((boolean)closeable2.wasClosed);
        Assert.assertTrue((boolean)closeable3.wasClosed);
        Assert.assertTrue((boolean)closeable4.wasClosed);
    }

    static class AutoCloseableImpl
    implements AutoCloseable {
        boolean wasClosed = false;

        AutoCloseableImpl() {
        }

        @Override
        public void close() {
            this.wasClosed = true;
        }
    }

    static class CloseableImpl
    implements Closeable {
        public boolean wasClosed = false;

        CloseableImpl() {
        }

        @Override
        public void close() {
            this.wasClosed = true;
        }

        @Override
        public boolean isClosed() {
            return this.wasClosed;
        }
    }
}

