/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StoreAppenderTest
extends QueueTestCommon {
    public static final String TEST_TEXT = "Some text some text some text";
    @Rule
    public final TemporaryFolder queueDirectory = new TemporaryFolder();

    @Test
    public void clearUsedByThreadThrowsUnsupportedOperationException() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)this.queueDirectory.newFolder()).build();){
            Assert.assertThrows(UnsupportedOperationException.class, () -> ((StoreAppender)queue.acquireAppender()).clearUsedByThread());
        }
    }

    @Test
    public void resetUsedByThreadThrowsUnsupportedOperationException() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)this.queueDirectory.newFolder()).build();){
            Assert.assertThrows(UnsupportedOperationException.class, () -> ((StoreAppender)queue.acquireAppender()).resetUsedByThread());
        }
    }

    @Test
    public void writingDocumentAcquisitionWorksAfterInterruptedAttempt() throws InterruptedException, IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)this.queueDirectory.newFolder()).build();){
            BlockingWriter blockingWriter = new BlockingWriter(queue);
            BlockedWriter blockedWriter = new BlockedWriter(queue);
            this.writeSomeText((ChronicleQueue)queue, 5);
            blockedWriter.makeSuccessfulWrite();
            this.writeSomeText((ChronicleQueue)queue, 5);
            this.expectTestText((ChronicleQueue)queue, 11);
            blockingWriter.blockWrites();
            blockedWriter.makeInterruptedAttemptToWrite();
            blockingWriter.unblockWrites();
            this.writeSomeText((ChronicleQueue)queue, 5);
            blockedWriter.makePostInterruptAttemptToWrite();
            this.expectTestText((ChronicleQueue)queue, 16);
        }
    }

    private void expectTestText(ChronicleQueue chronicleQueue, int times) {
        try (ExcerptTailer tailer = chronicleQueue.createTailer();){
            for (int i = 0; i < times; ++i) {
                Assert.assertEquals((Object)TEST_TEXT, (Object)tailer.readText());
            }
        }
    }

    private void writeSomeText(ChronicleQueue chronicleQueue, int times) {
        try (ExcerptAppender appender = chronicleQueue.acquireAppender();){
            for (int i = 0; i < times; ++i) {
                appender.writeText((CharSequence)TEST_TEXT);
            }
        }
    }

    private static void acquire(Semaphore semaphore) {
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"This shouldn't happen");
        }
    }

    private static void waitForThreads(Semaphore semaphore) {
        while (!semaphore.hasQueuedThreads()) {
            Jvm.pause((long)10L);
        }
    }

    static class BlockingWriter {
        private Thread t;
        private final SingleChronicleQueue queue;
        private final Semaphore inWritingDocument = new Semaphore(0);

        public BlockingWriter(SingleChronicleQueue queue) {
            this.queue = queue;
        }

        public void blockWrites() {
            this.t = new Thread(this::acquireWritingDocumentThenBlock);
            this.t.setName("blocking-writer");
            this.t.start();
            StoreAppenderTest.waitForThreads(this.inWritingDocument);
        }

        public void unblockWrites() throws InterruptedException {
            this.inWritingDocument.release(1);
            this.t.join();
            this.t = null;
        }

        private void acquireWritingDocumentThenBlock() {
            try (ExcerptAppender appender = this.queue.acquireAppender();
                 DocumentContext documentContext = appender.writingDocument();){
                StoreAppenderTest.acquire(this.inWritingDocument);
                documentContext.rollbackOnClose();
            }
        }
    }

    static class BlockedWriter {
        private Thread t;
        private final SingleChronicleQueue queue;
        private Semaphore waitingToAcquire;
        private Semaphore waitingAfterInterrupt;

        public BlockedWriter(SingleChronicleQueue queue) {
            this.queue = queue;
        }

        public void makeSuccessfulWrite() {
            this.waitingToAcquire = new Semaphore(0);
            this.waitingAfterInterrupt = new Semaphore(0);
            this.t = new Thread(this::makeInterruptedWriteAttemptThenTryAgain);
            this.t.setName("blocked-writer");
            this.t.start();
            StoreAppenderTest.waitForThreads(this.waitingToAcquire);
        }

        public void makeInterruptedAttemptToWrite() {
            this.waitingToAcquire.release(1);
            Jvm.pause((long)10L);
            this.t.interrupt();
            StoreAppenderTest.waitForThreads(this.waitingAfterInterrupt);
        }

        public void makePostInterruptAttemptToWrite() throws InterruptedException {
            this.waitingAfterInterrupt.release();
            this.t.join();
        }

        private void makeInterruptedWriteAttemptThenTryAgain() {
            ExcerptAppender appender = this.queue.acquireAppender();
            Throwable throwable = null;
            try {
                appender.writeText((CharSequence)StoreAppenderTest.TEST_TEXT);
                StoreAppenderTest.acquire(this.waitingToAcquire);
                try {
                    DocumentContext documentContext = appender.writingDocument();
                    Throwable throwable2 = null;
                    try {
                        try {
                            throw new AssertionError((Object)"We shouldn't get here");
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (documentContext != null) {
                            if (throwable2 != null) {
                                try {
                                    documentContext.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                documentContext.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (InterruptedRuntimeException e) {
                    Thread.interrupted();
                    StoreAppenderTest.acquire(this.waitingAfterInterrupt);
                    appender.writeText((CharSequence)StoreAppenderTest.TEST_TEXT);
                    if (appender != null) {
                        if (throwable != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            appender.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                try {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    if (appender != null) {
                        if (throwable != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            appender.close();
                        }
                    }
                    throw throwable8;
                }
            }
        }
    }
}

