/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.BinarySearch;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.internal.reader.InternalDummyMethodReaderQueueEntryHandler;
import net.openhft.chronicle.queue.internal.reader.MessageCountingMessageConsumer;
import net.openhft.chronicle.queue.internal.reader.PatternFilterMessageConsumer;
import net.openhft.chronicle.queue.internal.reader.queueentryreaders.CustomPluginQueueEntryReader;
import net.openhft.chronicle.queue.internal.reader.queueentryreaders.MethodReaderQueueEntryReader;
import net.openhft.chronicle.queue.internal.reader.queueentryreaders.VanillaQueueEntryReader;
import net.openhft.chronicle.queue.reader.ChronicleReaderPlugin;
import net.openhft.chronicle.queue.reader.ContentBasedLimiter;
import net.openhft.chronicle.queue.reader.MessageConsumer;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.queue.reader.QueueEntryReader;
import net.openhft.chronicle.queue.reader.Reader;
import net.openhft.chronicle.queue.reader.comparator.BinarySearchComparator;
import net.openhft.chronicle.queue.util.ToolsUtil;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChronicleReader
implements Reader {
    private static final long UNSET_VALUE = Long.MIN_VALUE;
    private final List<Pattern> inclusionRegex = new ArrayList<Pattern>();
    private final List<Pattern> exclusionRegex = new ArrayList<Pattern>();
    private final Pauser pauser = Pauser.millis(1, 100);
    private Path basePath;
    private long startIndex = Long.MIN_VALUE;
    private boolean tailInputSource = false;
    private long maxHistoryRecords = Long.MIN_VALUE;
    private boolean readOnly = true;
    private ChronicleReaderPlugin customPlugin;
    private Consumer<String> messageSink;
    private Function<ExcerptTailer, DocumentContext> pollMethod = ExcerptTailer::readingDocument;
    private WireType wireType = WireType.TEXT;
    private Supplier<QueueEntryHandler> entryHandlerFactory = () -> QueueEntryHandler.messageToText(this.wireType);
    private boolean displayIndex = true;
    private Class<?> methodReaderInterface;
    private BinarySearchComparator binarySearch;
    private String arg;
    private boolean showMessageHistory;
    private volatile boolean running = true;
    private TailerDirection tailerDirection = TailerDirection.FORWARD;
    private long matchLimit = 0L;
    private ContentBasedLimiter contentBasedLimiter;
    private String limiterArg;
    private ThreadLocal<ExcerptTailer> tlTailer;

    private static boolean isSet(long configValue) {
        return configValue != Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean retryLastOperation;
        this.configureContentBasedLimiter();
        long highestReachedIndex = 0L;
        boolean isFirstIteration = true;
        do {
            try (ChronicleQueue queue = this.createQueue();
                 ExcerptTailer tailer = queue.createTailer();){
                boolean queueHasBeenModified;
                MessageHistory.set(new VanillaMessageHistory());
                this.tlTailer = ThreadLocal.withInitial(queue::createTailer);
                MessageCountingMessageConsumer messageConsumer = new MessageCountingMessageConsumer(this.matchLimit, this.createMessageConsumers());
                QueueEntryReader queueEntryReader = this.createQueueEntryReader(tailer, messageConsumer);
                do {
                    long lastObservedTailIndex;
                    if (highestReachedIndex != 0L) {
                        tailer.moveToIndex(highestReachedIndex);
                    }
                    try {
                        this.moveToSpecifiedPosition(queue, tailer, isFirstIteration);
                        lastObservedTailIndex = tailer.index();
                        while (!Thread.currentThread().isInterrupted()) {
                            if (this.shouldHaltReadingDueToContentBasedLimit(tailer)) {
                                this.running = false;
                                break;
                            }
                            if (!queueEntryReader.read()) {
                                if (this.tailInputSource) {
                                    this.pauser.pause();
                                }
                                break;
                            }
                            if (messageConsumer.matchLimitReached()) {
                                break;
                            }
                            this.pauser.reset();
                        }
                    }
                    finally {
                        highestReachedIndex = tailer.index();
                        isFirstIteration = false;
                    }
                    queueHasBeenModified = this.queueHasBeenModifiedSinceLastCheck(lastObservedTailIndex);
                    retryLastOperation = false;
                    if (this.running && !messageConsumer.matchLimitReached()) continue;
                    return;
                } while (this.tailerDirection != TailerDirection.BACKWARD && (this.tailInputSource || queueHasBeenModified));
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof DateTimeParseException) {
                    retryLastOperation = true;
                    continue;
                }
                throw e;
            }
        } while (retryLastOperation);
    }

    private void configureContentBasedLimiter() {
        if (this.contentBasedLimiter != null) {
            this.contentBasedLimiter.configure(this);
        }
    }

    /*
     * Loose catch block
     */
    private boolean shouldHaltReadingDueToContentBasedLimit(ExcerptTailer tailer) {
        if (this.contentBasedLimiter == null) {
            return false;
        }
        long originalIndex = tailer.index();
        try {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (documentContext.isPresent()) {
                    boolean bl = this.contentBasedLimiter.shouldHaltReading(documentContext);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            tailer.moveToIndex(originalIndex);
        }
    }

    private QueueEntryReader createQueueEntryReader(ExcerptTailer tailer, MessageConsumer messageConsumer) {
        if (this.methodReaderInterface == null) {
            if (this.customPlugin == null) {
                return new VanillaQueueEntryReader(tailer, this.pollMethod, this.entryHandlerFactory.get(), messageConsumer);
            }
            return new CustomPluginQueueEntryReader(tailer, this.pollMethod, this.customPlugin, messageConsumer);
        }
        return new MethodReaderQueueEntryReader(tailer, messageConsumer, this.wireType, this.methodReaderInterface, this.showMessageHistory);
    }

    private MessageConsumer createMessageConsumers() {
        MessageConsumer tail = this::writeToSink;
        if (!this.exclusionRegex.isEmpty()) {
            tail = new PatternFilterMessageConsumer(this.exclusionRegex, false, tail);
        }
        if (!this.inclusionRegex.isEmpty()) {
            tail = new PatternFilterMessageConsumer(this.inclusionRegex, true, tail);
        }
        return tail;
    }

    private boolean writeToSink(long index, String text) {
        if (this.displayIndex) {
            this.messageSink.accept("0x" + Long.toHexString(index) + ": ");
        }
        this.messageSink.accept(text);
        return true;
    }

    public ChronicleReader withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ChronicleReader withMatchLimit(long matchLimit) {
        this.matchLimit = matchLimit;
        return this;
    }

    @Override
    public ChronicleReader withMessageSink(@NotNull Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    public Consumer<String> messageSink() {
        return this.messageSink;
    }

    @Override
    public ChronicleReader withBasePath(@NotNull Path path) {
        this.basePath = path;
        return this;
    }

    @Override
    public ChronicleReader withInclusionRegex(@NotNull String regex) {
        this.inclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ChronicleReader withExclusionRegex(@NotNull String regex) {
        this.exclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ChronicleReader withCustomPlugin(@NotNull ChronicleReaderPlugin customPlugin) {
        this.customPlugin = customPlugin;
        return this;
    }

    @Override
    public ChronicleReader withStartIndex(long index) {
        this.startIndex = index;
        return this;
    }

    @Override
    public ChronicleReader tail() {
        this.tailInputSource = true;
        return this;
    }

    @Override
    public ChronicleReader historyRecords(long maxHistoryRecords) {
        this.maxHistoryRecords = maxHistoryRecords;
        return this;
    }

    @Override
    public ChronicleReader asMethodReader(@Nullable String methodReaderInterface) {
        if (methodReaderInterface == null) {
            this.entryHandlerFactory = () -> new InternalDummyMethodReaderQueueEntryHandler(this.wireType);
        } else {
            try {
                this.methodReaderInterface = Class.forName(methodReaderInterface);
            }
            catch (ClassNotFoundException e) {
                throw Jvm.rethrow(e);
            }
        }
        return this;
    }

    @Override
    public ChronicleReader showMessageHistory(boolean showMessageHistory) {
        this.showMessageHistory = showMessageHistory;
        return this;
    }

    @Override
    public ChronicleReader withBinarySearch(@NotNull String binarySearchClass) {
        try {
            Class<?> clazz = Class.forName(binarySearchClass);
            this.binarySearch = (BinarySearchComparator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.binarySearch.accept(this);
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
        return this;
    }

    @Override
    public ChronicleReader withContentBasedLimiter(ContentBasedLimiter contentBasedLimiter) {
        this.contentBasedLimiter = contentBasedLimiter;
        return this;
    }

    @Override
    public ChronicleReader withArg(String arg) {
        this.arg = arg;
        return this;
    }

    @Override
    public ChronicleReader withLimiterArg(@NotNull String limiterArg) {
        this.limiterArg = limiterArg;
        return this;
    }

    @Override
    public ChronicleReader withWireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public ChronicleReader inReverseOrder() {
        this.tailerDirection = TailerDirection.BACKWARD;
        return this;
    }

    @Override
    public ChronicleReader suppressDisplayIndex() {
        this.displayIndex = false;
        return this;
    }

    @Override
    public String arg() {
        return this.arg;
    }

    @Override
    public String limiterArg() {
        return this.limiterArg;
    }

    @Override
    public Class<?> methodReaderInterface() {
        return this.methodReaderInterface;
    }

    public ChronicleReader withDocumentPollMethod(Function<ExcerptTailer, DocumentContext> pollMethod) {
        this.pollMethod = pollMethod;
        return this;
    }

    private boolean queueHasBeenModifiedSinceLastCheck(long lastObservedTailIndex) {
        long currentTailIndex = this.indexOfEnd();
        return currentTailIndex > lastObservedTailIndex;
    }

    private void moveToSpecifiedPosition(ChronicleQueue ic, ExcerptTailer tailer, boolean isFirstIteration) {
        if (isFirstIteration) {
            tailer.direction(this.tailerDirection);
            if (this.tailerDirection == TailerDirection.BACKWARD) {
                tailer.toEnd();
            }
            if (ChronicleReader.isSet(this.startIndex)) {
                if (this.startIndex < ic.firstIndex()) {
                    throw new IllegalArgumentException(String.format("startIndex 0x%xd is less than first index 0x%xd", this.startIndex, ic.firstIndex()));
                }
                if (this.tailerDirection == TailerDirection.BACKWARD && this.startIndex > ic.lastIndex()) {
                    throw new IllegalArgumentException(String.format("startIndex 0x%xd is greater than last index 0x%xd", this.startIndex, ic.lastIndex()));
                }
                boolean firstTime = true;
                while (!tailer.moveToIndex(this.startIndex)) {
                    if (firstTime) {
                        this.messageSink.accept("Waiting for startIndex " + Long.toHexString(this.startIndex));
                        firstTime = false;
                    }
                    Jvm.pause(100L);
                }
            } else if (this.binarySearch != null) {
                this.seekBinarySearch(tailer);
            }
            if (this.tailerDirection == TailerDirection.FORWARD) {
                if (ChronicleReader.isSet(this.maxHistoryRecords)) {
                    tailer.toEnd();
                    this.moveToIndexNFromTheEnd(tailer, this.maxHistoryRecords);
                } else if (this.tailInputSource) {
                    tailer.toEnd();
                }
            }
        }
    }

    private void seekBinarySearch(ExcerptTailer tailer) {
        TailerDirection originalDirection = tailer.direction();
        try {
            Wire key = this.binarySearch.wireKey();
            long rv = BinarySearch.search((SingleChronicleQueue)tailer.queue(), key, this.binarySearch);
            if (rv == -1L) {
                tailer.toStart();
            } else if (rv < 0L) {
                this.scanToFirstEntryFollowingMatch(tailer, key, -rv);
            } else {
                this.scanToFirstMatchingEntry(tailer, key, rv);
            }
            tailer.direction(originalDirection);
        }
        catch (ParseException e) {
            throw Jvm.rethrow(e);
        }
    }

    /*
     * Exception decompiling
     */
    private void scanToFirstMatchingEntry(ExcerptTailer tailer, Wire key, long matchingIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void scanToFirstEntryFollowingMatch(ExcerptTailer tailer, Wire key, long indexAdjacentMatch) {
        long indexToMoveTo = -1L;
        tailer.direction(this.tailerDirection);
        tailer.moveToIndex(indexAdjacentMatch);
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) break;
                if ((tailer.direction() != TailerDirection.FORWARD || this.binarySearch.compare(dc.wire(), key) < 0) && (tailer.direction() != TailerDirection.BACKWARD || this.binarySearch.compare(dc.wire(), key) > 0)) continue;
                indexToMoveTo = dc.index();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
        if (indexToMoveTo >= 0L) {
            tailer.moveToIndex(indexToMoveTo);
        }
    }

    private void moveToIndexNFromTheEnd(ExcerptTailer tailer, long numberOfEntriesFromEnd) {
        tailer.direction(TailerDirection.BACKWARD).toEnd();
        int i = 0;
        while ((long)i < numberOfEntriesFromEnd - 1L) {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (!documentContext.isPresent()) {
                    break;
                }
            }
            ++i;
        }
        tailer.direction(TailerDirection.FORWARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long indexOfEnd() {
        ExcerptTailer excerptTailer = this.tlTailer.get();
        long index = excerptTailer.index();
        try {
            long l = excerptTailer.toEnd().index();
            return l;
        }
        finally {
            excerptTailer.moveToIndex(index);
        }
    }

    @NotNull
    private ChronicleQueue createQueue() {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path '%s' does not exist (absolute path '%s')", this.basePath, this.basePath.toAbsolutePath()));
        }
        return SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(this.readOnly).storeFileListener(StoreFileListener.NO_OP).build();
    }

    @Override
    public void stop() {
        this.running = false;
    }

    static {
        ToolsUtil.warnIfResourceTracing();
    }
}

