/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.junit.Assert;
import org.junit.Test;

public class LatinCharTest
extends QueueTestCommon {
    @Test
    public void shouldCorrectlyEncodeDecode() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("temp")).rollCycle((RollCycle)RollCycles.MINUTELY).build();
             ExcerptAppender appender = queue.acquireAppender();
             ExcerptTailer tailer = queue.createTailer("test-tailer");){
            Message expected = new Message("aw\u00e9some-message-1", 1L);
            appender.writeDocument((WriteMarshallable)expected);
            Message actual = new Message();
            tailer.readDocument((ReadMarshallable)actual);
            Assert.assertEquals((Object)((Object)expected), (Object)((Object)actual));
        }
    }

    private static class Message
    extends SelfDescribingMarshallable {
        String s;
        long l;

        Message(String s, long l) {
            this.s = s;
            this.l = l;
        }

        Message() {
        }
    }
}

