/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.InternalChronicleChannel;
import net.openhft.chronicle.wire.channel.OkHeader;
import net.openhft.chronicle.wire.channel.RedirectHeader;
import net.openhft.chronicle.wire.channel.SystemContext;
import net.openhft.chronicle.wire.channel.impl.BufferedChronicleChannel;
import net.openhft.chronicle.wire.channel.impl.TCPChronicleChannel;

public class ChronicleServiceMain
extends SelfDescribingMarshallable
implements Closeable {
    int port;
    Marshallable microservice;
    boolean buffered;
    transient ServerSocketChannel ssc;
    volatile transient boolean closed;
    transient Set<ChronicleChannel> channels;

    public static void main(String ... args) throws IOException {
        ChronicleServiceMain main = Marshallable.fromFile(ChronicleServiceMain.class, args[0]);
        main.buffered = Jvm.getBoolean("buffered", main.buffered);
        main.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        Object channelCfg;
        this.channels = Collections.newSetFromMap(new WeakHashMap());
        Jvm.startup().on(this.getClass(), "Starting " + this);
        Thread.currentThread().setName("acceptor");
        ExecutorService service = Executors.newCachedThreadPool(new NamedThreadFactory("connections"));
        try {
            this.ssc = ServerSocketChannel.open();
            this.ssc.bind(new InetSocketAddress(this.port));
            channelCfg = new ChronicleChannelCfg().port(this.port);
            Function<ChannelHeader, ChannelHeader> redirectFunction = this::replaceOutHeader;
            while (!this.isClosed()) {
                SocketChannel sc = this.ssc.accept();
                sc.socket().setTcpNoDelay(true);
                TCPChronicleChannel connection0 = new TCPChronicleChannel(SystemContext.INSTANCE, (ChronicleChannelCfg)channelCfg, sc, h -> h, redirectFunction);
                InternalChronicleChannel channel = this.buffered ? new BufferedChronicleChannel(connection0, Pauser.balanced()) : connection0;
                this.channels.add(channel);
                service.submit(() -> new ConnectionHandler(channel).run());
            }
        }
        catch (Throwable e) {
            if (!this.isClosed()) {
                Jvm.error().on(this.getClass(), e);
            }
        }
        finally {
            this.close();
            Jvm.pause(100L);
            channelCfg = Wires.class;
            synchronized (Wires.class) {
                AffinityLock.dumpLocks();
                service.shutdownNow();
                // ** MonitorExit[channelCfg /* !! */ ] (shouldn't be in output)
                try {
                    service.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Jvm.warn().on(this.getClass(), e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected ChannelHeader replaceOutHeader(ChannelHeader channelHandler) {
        if (channelHandler instanceof OkHeader) {
            return new OkHeader();
        }
        return new RedirectHeader(Collections.EMPTY_LIST);
    }

    @Override
    public void close() {
        this.closed = true;
        Closeable.closeQuietly((Object)this.ssc);
        Closeable.closeQuietly(this.channels);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    class ConnectionHandler {
        final ChronicleChannel channel;

        public ConnectionHandler(ChronicleChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() {
            try {
                Jvm.debug().on(ChronicleServiceMain.class, "Server got " + this.channel.headerIn());
                Marshallable microservice = (Marshallable)ChronicleServiceMain.this.microservice.deepCopy();
                Field field = Jvm.getFieldOrNull(microservice.getClass(), "out");
                if (field == null) {
                    throw new IllegalStateException("Microservice " + microservice + " must have a field called out");
                }
                Object out = this.channel.methodWriter(field.getType(), new Class[0]);
                try (AffinityLock lock = AffinityLock.acquireLock();){
                    field.set(microservice, out);
                    this.channel.eventHandlerAsRunnable(microservice).run();
                }
                catch (ClosedIORuntimeException e) {
                    Thread.yield();
                    if (!((Closeable)((Object)microservice)).isClosed()) {
                        Jvm.debug().on(this.getClass(), "readOne threw " + e);
                    }
                }
                catch (Exception e) {
                    Thread.yield();
                    if (!((Closeable)((Object)microservice)).isClosed() && !this.channel.isClosed()) {
                        Jvm.warn().on(this.getClass(), "readOne threw ", e);
                    }
                }
            }
            catch (Throwable t) {
                Jvm.error().on(this.getClass(), t);
            }
            finally {
                Closeable.closeQuietly((Object)this.channel);
            }
        }
    }
}

