/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

class PretoucherState {
    public static final int FACTOR = 4;
    private static final int HEAD_ROOM = Jvm.getInteger("PretoucherState.headRoom", 0x100000);
    @NotNull
    private final LongSupplier posSupplier;
    private int minHeadRoom;
    private long lastTouchedPage = 0L;
    private long lastTouchedPos = 0L;
    private long lastPos = 0L;
    private int lastBytesHashcode = -1;
    private long averageMove = 0L;

    public PretoucherState(@NotNull LongSupplier posSupplier) {
        this(posSupplier, HEAD_ROOM);
    }

    public PretoucherState(@NotNull LongSupplier posSupplier, int minHeadRoom) {
        this.posSupplier = posSupplier;
        this.minHeadRoom = minHeadRoom;
    }

    static File getFile(MappedBytes bytes) {
        if (bytes == null) {
            return new File("none");
        }
        return bytes.mappedFile().file();
    }

    public void pretouch(MappedBytes bytes) {
        long pos;
        try {
            pos = this.posSupplier.getAsLong();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Encountered an NPE, possibly because the store was released by something else", npe);
        }
        int pageSize = OS.pageSize();
        if (this.lastBytesHashcode != System.identityHashCode(bytes)) {
            this.lastTouchedPage = pos - pos % (long)pageSize;
            this.lastTouchedPos = pos;
            this.lastBytesHashcode = System.identityHashCode(bytes);
            this.averageMove = OS.pageSize();
            this.lastPos = pos;
            if (Jvm.isDebugEnabled(this.getClass())) {
                String message = PretoucherState.getFile(bytes) + " - Reset pretoucher to pos " + pos + " as the underlying MappedBytes changed.";
                this.debug(message);
            }
        } else {
            long moved = pos - this.lastPos;
            this.averageMove = moved / 4L + this.averageMove * 3L / 4L;
            long neededHeadRoom = Math.max((long)this.minHeadRoom, this.averageMove * 4L);
            long neededEnd = pos + neededHeadRoom;
            if (this.lastTouchedPage < neededEnd) {
                Thread thread = Thread.currentThread();
                int count = 0;
                int pretouch = 0;
                while (this.lastTouchedPage < neededEnd) {
                    if (bytes != null) {
                        bytes.throwExceptionIfClosed();
                    }
                    if (thread.isInterrupted()) break;
                    long realCapacity = bytes == null ? 0L : bytes.realCapacity();
                    long capacity = 0L;
                    try {
                        capacity = bytes == null ? -1L : bytes.bytesStore().capacity();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    long safeLimit = 0L;
                    try {
                        safeLimit = bytes == null ? -1L : bytes.bytesStore().safeLimit();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    try {
                        if (this.touchPage(bytes, this.lastTouchedPage)) {
                            Thread.yield();
                            ++pretouch;
                        }
                    }
                    catch (Throwable t) {
                        try {
                            bytes.throwExceptionIfClosed();
                            bytes.throwExceptionIfReleased();
                            throw new IllegalStateException("bytes.realCapacity: " + realCapacity + ", bytes:capacity: " + capacity + ", bytes:safeLimit: " + safeLimit + ", lastTouchedPage: " + this.lastTouchedPage);
                        }
                        catch (Exception e) {
                            e.initCause(t);
                            throw e;
                        }
                    }
                    ++count;
                    this.lastTouchedPage += (long)pageSize;
                }
                this.onTouched(count);
                if (pretouch < count) {
                    this.minHeadRoom += 262144;
                    if (Jvm.isDebugEnabled(this.getClass())) {
                        this.debug("pretouch for only " + pretouch + " of " + count + " min: " + (this.minHeadRoom >> 20) + " MB.");
                    }
                }
                long pos2 = this.posSupplier.getAsLong();
                if (Jvm.isDebugEnabled(this.getClass())) {
                    String message = PretoucherState.getFile(bytes) + ": Advanced " + (pos - this.lastTouchedPos) / 1024L + " KB, avg " + this.averageMove / 1024L + " KB between pretouch() and " + (pos2 - pos) / 1024L + " KB while mapping of " + pretouch * pageSize / 1024 + " KB ";
                    this.debug(message);
                }
                this.lastTouchedPos = pos;
            }
            this.lastPos = pos;
        }
    }

    protected void debug(String message) {
        Jvm.debug().on(this.getClass(), message);
    }

    protected boolean touchPage(MappedBytes bytes, long offset) {
        return bytes != null && bytes.compareAndSwapLong(offset, 0L, 0L);
    }

    protected void onTouched(int count) {
    }
}

