/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class ConcurrentAppendersOutOfSpaceTest {
    private static final int BLOCK_SIZE = 524288;
    private static final int MSG_SIZE = 256;
    private static final long MSGS_PER_SECOND = 1000L;
    private static final long NANO_DELAY = 1000000L;
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final String QUEUE_PATH = "concappenders";

    public static void main(String[] args) throws InterruptedException {
        Thread writer1 = new Thread(new EndlessUpdate());
        writer1.start();
        Thread permissionsThread = new Thread(new PermissionsManipulation());
        permissionsThread.start();
        Jvm.pause((long)10000L);
        Thread writer2 = new Thread(new EndlessUpdate());
        writer2.start();
        permissionsThread.join();
        writer1.join();
        writer2.join();
    }

    private static class EndlessUpdate
    implements Runnable {
        private EndlessUpdate() {
        }

        @Override
        public void run() {
            int threadNo = threadCount.incrementAndGet();
            System.out.println("Writer " + threadNo + ": started");
            int messagesWritten = 0;
            byte[] sample = new byte[256];
            ThreadLocalRandom r = ThreadLocalRandom.current();
            for (int i = 0; i < 256; ++i) {
                sample[i] = (byte)r.nextInt();
            }
            while (true) {
                try {
                    SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((String)ConcurrentAppendersOutOfSpaceTest.QUEUE_PATH).blockSize(524288).build();
                    ExcerptAppender appender = q.acquireAppender();
                    Throwable throwable = null;
                    try {
                        try {
                            while (true) {
                                boolean written = true;
                                try (DocumentContext dc = appender.writingDocument();){
                                    dc.wire().writeBytes(bytes -> bytes.write(sample, 0, r.nextInt(8, 256)));
                                }
                                catch (Exception e) {
                                    System.out.println("Writer " + threadNo + ": failed to write message, sleeping for 1 sec");
                                    e.printStackTrace();
                                    Jvm.pause((long)1000L);
                                    written = false;
                                }
                                if (written) {
                                    ++messagesWritten;
                                }
                                if ((long)messagesWritten % 1000L == 0L) {
                                    System.out.println("Writer " + threadNo + ": " + messagesWritten + " messages written");
                                }
                                LockSupport.parkNanos(1000000L);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (appender != null) {
                            if (throwable != null) {
                                try {
                                    appender.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                appender.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    System.out.println("Writer " + threadNo + ": failed to acquire appender, sleeping for 1 sec");
                    e.printStackTrace();
                    Jvm.pause((long)1000L);
                    continue;
                }
                break;
            }
        }
    }

    private static class PermissionsManipulation
    implements Runnable {
        private PermissionsManipulation() {
        }

        @Override
        public void run() {
            boolean success;
            System.out.println("Permissions: started");
            Jvm.pause((long)5000L);
            File queueDir = new File(ConcurrentAppendersOutOfSpaceTest.QUEUE_PATH);
            if (!queueDir.exists()) {
                System.out.println("Permissions: dir not found");
            }
            if (!queueDir.isDirectory()) {
                System.out.println("Permissions: not a dir");
            }
            System.out.println("Permissions: removing write permissions for queue files");
            for (File f : queueDir.listFiles()) {
                success = f.setWritable(false);
                if (success) continue;
                System.out.println("Permissions: failed to remove write permissions for " + f);
            }
            Jvm.pause((long)10000L);
            System.out.println("Permissions: adding write permissions for queue files");
            for (File f : queueDir.listFiles()) {
                success = f.setWritable(true);
                if (success) continue;
                System.out.println("Permissions: failed to add write permissions for " + f);
            }
        }
    }
}

