/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueMultiThreadedJLBHBenchmark2
implements JLBHTask {
    private static final String PATH = System.getProperty("path", "/dev/shm") + "/replica";
    private static final int MSGSIZE = 512;
    private static final String CPU1 = System.getProperty("cpu1", "last-1");
    private static final String CPU2 = System.getProperty("cpu2", "last-2");
    private static final int ITERATIONS = 2000000000;
    private static final long BLOCKSIZE = 0x40000000000L;
    private static final int RUNS = 3;
    private static volatile long startTime;
    private static volatile Thread thread;
    private final Datum datum = new Datum();
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private boolean stopped = false;
    private Thread tailerThread;
    private JLBH jlbh;
    private NanoSampler writeProbe;
    private ScheduledExecutorService pretoucher;

    public static void main(String[] args) {
        System.out.println("-Dpath=" + PATH + " -Dcpu1=" + CPU1 + " -Dcpu2=" + CPU2);
        QueueMultiThreadedJLBHBenchmark2.warmUp();
        QueueMultiThreadedJLBHBenchmark2 bench = new QueueMultiThreadedJLBHBenchmark2();
        for (int r = 0; r <= 1; ++r) {
            int[] throughputs;
            for (int throughput : throughputs = new int[]{1500000, 250000}) {
                System.out.println("Throughput: " + throughput / 1000 + "k msgs/s");
                bench.run1(throughput, r == 0 ? 150000000 : 2000000000);
            }
        }
    }

    private static void warmUp() {
        System.setProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle", "true");
        MappedFile.warmup();
    }

    void run1(int throughput, int iterations) {
        JLBHOptions lth = new JLBHOptions().warmUpIterations(5000000).iterations(iterations).throughput(throughput).recordOSJitter(false).accountForCoordinatedOmission(false).skipFirstRun(true).acquireLock(() -> AffinityLock.acquireLock((String)CPU1)).runs(1).jlbhTask((JLBHTask)new QueueMultiThreadedJLBHBenchmark2());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        this.jlbh = jlbh;
        IOTools.deleteDirWithFiles((String)PATH, (int)10);
        this.sinkQueue = this.sourceQueue = SingleChronicleQueueBuilder.single((String)PATH).blockSize(0x40000000000L).rollCycle((RollCycle)RollCycles.HUGE_DAILY).build();
        this.appender = this.sourceQueue.acquireAppender();
        this.tailer = this.sinkQueue.createTailer().disableThreadSafetyCheck(true);
        NanoSampler readProbe = jlbh.addProbe("read");
        this.writeProbe = jlbh.addProbe("write");
        this.pretoucher = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("pretoucher", Boolean.valueOf(true)));
        this.pretoucher.scheduleAtFixedRate(() -> this.sourceQueue.acquireAppender().pretouch(), 1L, 200L, TimeUnit.MILLISECONDS);
        this.tailerThread = new Thread(() -> {
            try (AffinityLock lock = AffinityLock.acquireLock((String)CPU2);){
                Datum datum2 = new Datum();
                while (!this.stopped) {
                    long beforeReadNs = System.nanoTime();
                    DocumentContext dc = this.tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (dc.wire() == null) continue;
                        datum2.readMarshallable((BytesIn)dc.wire().bytes());
                        long now = System.nanoTime();
                        jlbh.sample(now - datum2.ts);
                        readProbe.sampleNanos(now - beforeReadNs);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                    }
                }
            }
        });
        this.tailerThread.start();
    }

    public void run(long startTimeNS) {
        startTime = startTimeNS;
        if (thread == null) {
            thread = Thread.currentThread();
        }
        this.datum.ts = startTimeNS;
        try (DocumentContext dc = this.appender.writingDocument();){
            Jvm.safepoint();
            this.datum.writeMarshallable((BytesOut)dc.wire().bytes());
        }
        long nanos = System.nanoTime() - startTimeNS;
        this.writeProbe.sampleNanos(nanos);
        startTime = Long.MAX_VALUE;
    }

    public void complete() {
        this.pretoucher.shutdownNow();
        this.stopped = true;
        try {
            this.tailerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sinkQueue.close();
        this.sourceQueue.close();
        TeamCityHelper.teamCityStatsLastRun((String)this.getClass().getSimpleName(), (JLBH)this.jlbh, (long)2000000000L, (PrintStream)System.out);
    }

    private static class Datum
    implements BytesMarshallable {
        public long ts = 0L;
        public byte[] filler = new byte[504];

        private Datum() {
        }

        public void readMarshallable(BytesIn bytes) throws IORuntimeException {
            this.ts = bytes.readLong();
            bytes.read(this.filler);
        }

        public void writeMarshallable(BytesOut bytes) {
            bytes.writeLong(this.ts);
            bytes.write(this.filler);
        }
    }
}

