/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueMultiThreadedJLBHBenchmark
implements JLBHTask {
    private static final int ITERATIONS = 1000000;
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private Datum datum = new Datum();
    private boolean stopped = false;
    private Thread tailerThread;
    private JLBH jlbh;
    private NanoSampler writeProbe;

    public static void main(String[] args) {
        JLBHOptions lth = new JLBHOptions().warmUpIterations(50000).iterations(1000000).throughput(100000).recordOSJitter(false).accountForCoordinatedOmission(false).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new QueueMultiThreadedJLBHBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        this.jlbh = jlbh;
        IOTools.deleteDirWithFiles((String)"replica", (int)10);
        this.sourceQueue = SingleChronicleQueueBuilder.single((String)"replica").build();
        this.sinkQueue = SingleChronicleQueueBuilder.single((String)"replica").build();
        this.appender = this.sourceQueue.acquireAppender();
        this.tailer = this.sinkQueue.createTailer().disableThreadSafetyCheck(true);
        NanoSampler readProbe = jlbh.addProbe("read");
        this.writeProbe = jlbh.addProbe("write");
        this.tailerThread = new Thread(() -> {
            Datum datum2 = new Datum();
            while (!this.stopped) {
                long beforeReadNs = System.nanoTime();
                DocumentContext dc = this.tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (dc.wire() == null) continue;
                    datum2.readMarshallable((BytesIn)dc.wire().bytes());
                    long now = System.nanoTime();
                    jlbh.sample(now - datum2.ts);
                    readProbe.sampleNanos(now - beforeReadNs);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
        });
        this.tailerThread.start();
    }

    public void run(long startTimeNS) {
        this.datum.ts = startTimeNS;
        try (DocumentContext dc = this.appender.writingDocument();){
            this.datum.writeMarshallable((BytesOut)dc.wire().bytes());
        }
        this.writeProbe.sampleNanos(System.nanoTime() - startTimeNS);
    }

    public void complete() {
        this.stopped = true;
        try {
            this.tailerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sinkQueue.close();
        this.sourceQueue.close();
        TeamCityHelper.teamCityStatsLastRun((String)this.getClass().getSimpleName(), (JLBH)this.jlbh, (long)1000000L, (PrintStream)System.out);
    }

    private static class Datum
    implements BytesMarshallable {
        public long ts = 0L;
        public byte[] filler = new byte[4088];

        private Datum() {
        }

        public void readMarshallable(BytesIn bytes) throws IORuntimeException {
            this.ts = bytes.readLong();
            bytes.read(this.filler);
        }

        public void writeMarshallable(BytesOut bytes) {
            bytes.writeLong(this.ts);
            bytes.write(this.filler);
        }
    }
}

