/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.function.Supplier;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;

public class OnDemandEventLoop
implements EventLoop {
    private final Supplier<EventLoop> eventLoopSupplier;
    private volatile EventLoop eventLoop;

    public OnDemandEventLoop(Supplier<EventLoop> eventLoopSupplier) {
        this.eventLoopSupplier = eventLoopSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventLoop eventLoop() {
        EventLoop el = this.eventLoop;
        if (el != null) {
            return el;
        }
        OnDemandEventLoop onDemandEventLoop = this;
        synchronized (onDemandEventLoop) {
            el = this.eventLoop;
            if (el != null) {
                return el;
            }
            this.eventLoop = this.eventLoopSupplier.get();
            return this.eventLoop;
        }
    }

    public boolean hasEventLoop() {
        return this.eventLoop != null;
    }

    @Override
    public String name() {
        return this.eventLoop().name();
    }

    @Override
    public void addHandler(EventHandler handler) {
        this.eventLoop().addHandler(handler);
    }

    @Override
    public void start() {
        this.eventLoop().start();
    }

    @Override
    public void unpause() {
        if (this.hasEventLoop()) {
            this.eventLoop().unpause();
        }
    }

    @Override
    public void stop() {
        if (this.hasEventLoop()) {
            this.eventLoop().stop();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.hasEventLoop() || this.eventLoop().isClosed();
    }

    @Override
    public boolean isAlive() {
        return this.hasEventLoop() && this.eventLoop().isAlive();
    }

    @Override
    public boolean isStopped() {
        EventLoop el = this.eventLoop;
        return el != null && el.isStopped();
    }

    @Override
    public void awaitTermination() {
        if (this.hasEventLoop()) {
            this.eventLoop().awaitTermination();
        }
    }

    @Override
    public void close() {
        if (this.hasEventLoop()) {
            this.eventLoop().close();
        }
    }
}

