/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class ChunkCountTest {
    @Test
    public void chunks() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)IOTools.createTempFile((String)"chunks")).blockSize(65536).rollCycle((RollCycle)RollCycles.DAILY).build();
             ExcerptAppender appender = queue.acquireAppender();){
            Assert.assertEquals((long)0L, (long)queue.chunkCount());
            appender.writeText((CharSequence)"Hello");
            Assert.assertEquals((long)1L, (long)queue.chunkCount());
            for (int i = 0; i < 100; ++i) {
                long pos;
                try (DocumentContext dc = appender.writingDocument();){
                    pos = dc.wire().bytes().writePosition();
                    dc.wire().bytes().writeSkip(16000L);
                }
                Assert.assertEquals((String)("i: " + i), (long)(1L + (pos >> 18)), (long)queue.chunkCount());
            }
        }
    }
}

