/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.shutdown.PriorityHook;
import net.openhft.chronicle.core.util.Time;
import org.jetbrains.annotations.NotNull;

public class DirectoryUtils {
    @NotNull
    public static File tempDir(String name) {
        String replacedName = name.replaceAll("[\\[\\]\\s]+", "_").replace(':', '_');
        File tmpDir = new File(OS.getTarget(), replacedName + "-" + Time.uniqueId());
        DeleteStatic.INSTANCE.add(tmpDir);
        if (OS.isMacOSX()) {
            Jvm.debug().on(DirectoryUtils.class, "Tmp dir: " + tmpDir);
        }
        return tmpDir;
    }

    public static void deleteDir(@NotNull String dir) {
        IOTools.deleteDirWithFiles((File)new File(dir));
    }

    public static void deleteDir(@NotNull File dir) {
        IOTools.deleteDirWithFiles((File)dir);
    }

    static enum DeleteStatic {
        INSTANCE;

        final Set<File> toDeleteList = Collections.synchronizedSet(new LinkedHashSet());

        private DeleteStatic() {
            PriorityHook.add((int)100, () -> this.toDeleteList.forEach(DirectoryUtils::deleteDir));
        }

        synchronized void add(File path) {
            this.toDeleteList.add(path);
        }
    }
}

