/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.cleaner.CleanerServiceLocator;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.util.Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.nio.ch.IOStatus;

public final class IOTools {
    static volatile Map<Class, AtomicInteger> COUNTER_MAP = new ConcurrentHashMap<Class, AtomicInteger>();
    public static final int IOSTATUS_INTERRUPTED = -3;

    private IOTools() {
    }

    public static boolean shallowDeleteDirWithFiles(@NotNull String directory) throws IORuntimeException {
        return IOTools.shallowDeleteDirWithFiles(new File(directory));
    }

    public static boolean shallowDeleteDirWithFiles(@NotNull File dir) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(dir, 1);
    }

    public static boolean deleteDirWithFiles(String ... dirs) throws IORuntimeException {
        boolean result = true;
        for (String dir : dirs) {
            boolean r = IOTools.deleteDirWithFiles(dir, 20);
            result &= r;
        }
        return result;
    }

    public static boolean deleteDirWithFiles(@NotNull String dir, int maxDepth) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(new File(dir), maxDepth);
    }

    public static boolean deleteDirWithFiles(@NotNull File dir) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(dir, 20);
    }

    public static boolean deleteDirWithFiles(@NotNull File dir, int maxDepth) throws IORuntimeException {
        @Nullable File[] entries = dir.listFiles();
        if (entries == null) {
            return false;
        }
        Stream.of(entries).filter(File::isDirectory).forEach(f -> {
            if (maxDepth < 1) {
                throw new AssertionError((Object)("Contains directory " + f));
            }
            IOTools.deleteDirWithFiles(f, maxDepth - 1);
        });
        Stream.of(entries).forEach(f -> {
            try {
                Files.delete(f.toPath());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                Jvm.debug().on(Closeable.class, "Failed to delete " + f, e);
            }
        });
        return dir.delete();
    }

    public static void deleteDirWithFilesOrThrow(String ... dirs) throws IORuntimeException {
        File[] files = (File[])Arrays.stream(dirs).map(File::new).toArray(File[]::new);
        IOTools.deleteDirWithFilesOrThrow(files);
    }

    public static void deleteDirWithFilesOrThrow(File ... dirs) throws IORuntimeException {
        for (File dir : dirs) {
            if (!IOTools.deleteDirWithFiles(dir) && dir.exists()) {
                throw new AssertionError((Object)("Could not delete " + dir));
            }
        }
    }

    public static void deleteDirWithFilesOrWait(long timeoutMs, @NotNull File dir) {
        long startTs = System.currentTimeMillis();
        do {
            if (IOTools.deleteDirWithFiles(dir)) {
                return;
            }
            if (!dir.exists()) {
                return;
            }
            Jvm.pause(50L);
        } while (System.currentTimeMillis() - startTs < timeoutMs);
        throw new AssertionError((Object)("Failed to delete dir " + dir + " within " + timeoutMs + "ms"));
    }

    @NotNull
    public static URL urlFor(Class clazz, String name) throws FileNotFoundException {
        return IOTools.urlFor(clazz.getClassLoader(), name);
    }

    @NotNull
    public static URL urlFor(ClassLoader classLoader, String name) throws FileNotFoundException {
        URL url = classLoader.getResource(name);
        if (url == null && name.startsWith("/")) {
            url = classLoader.getResource(name.substring(1));
        }
        if (url == null) {
            url = classLoader.getResource(name + ".gz");
        }
        if (url == null && new File(name).exists()) {
            try {
                url = new URL("file", "", new File(name).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                FileNotFoundException fnfe = new FileNotFoundException(name);
                fnfe.initCause(e);
                throw fnfe;
            }
        }
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        return url;
    }

    public static InputStream open(URL url) throws IOException {
        InputStream in = url.openStream();
        if (url.getFile().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static byte[] readFile(Class clazz, @NotNull String name) throws IOException {
        URL url = IOTools.urlFor(clazz, name);
        InputStream is = IOTools.open(url);
        return IOTools.readAsBytes(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsBytes(InputStream is) throws IOException {
        if (is instanceof FileInputStream) {
            try (FileInputStream fis = (FileInputStream)is;){
                byte[] bytes = new byte[fis.available()];
                int read = fis.read(bytes);
                if (read != bytes.length) {
                    throw new AssertionError();
                }
                byte[] byArray = bytes;
                return byArray;
            }
        }
        try {
            int len;
            @NotNull ByteArrayOutputStream out = new ByteArrayOutputStream(Math.min(512, is.available()));
            @NotNull byte[] bytes = new byte[1024];
            while ((len = is.read(bytes)) > 0) {
                out.write(bytes, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Closeable.closeQuietly((Object)is);
        }
    }

    public static void writeFile(@NotNull String filename, @NotNull byte[] bytes) throws IOException {
        try (@NotNull FileOutputStream out0 = new FileOutputStream(filename);){
            OutputStream out = out0;
            if (filename.endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).close();
        }
    }

    @NotNull
    public static String tempName(@NotNull String filename) {
        int ext = filename.lastIndexOf(46);
        if (ext > 0 && ext > filename.length() - 5) {
            return filename.substring(0, ext) + System.nanoTime() + filename.substring(ext);
        }
        return filename + System.nanoTime();
    }

    public static void clean(ByteBuffer bb) {
        CleanerServiceLocator.cleanerService().clean(bb);
    }

    public static void createDirectories(Path dir) throws IOException {
        block6: {
            if (dir == null || dir.getNameCount() == 0 || Files.isDirectory(dir, new LinkOption[0])) {
                return;
            }
            IOTools.createDirectories(dir.getParent());
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isSymbolicLink(dir)) {
                    throw new IOException("Symbolic link from " + dir + " to " + Files.readSymbolicLink(dir) + " is broken", e);
                }
                if (Files.isRegularFile(dir, new LinkOption[0])) {
                    throw new IOException("Cannot create a directory with the same name as a file " + dir, e);
                }
            }
            catch (AccessDeniedException e) {
                if (dir.toFile().canWrite()) break block6;
                throw new IOException("Cannot write to " + dir, e);
            }
        }
    }

    static AtomicInteger counter(Class type) {
        return COUNTER_MAP.computeIfAbsent(type, k -> new AtomicInteger());
    }

    public static File createTempFile(String s) {
        File file = IOTools.createTempDirectory(s).toFile();
        file.deleteOnExit();
        return file;
    }

    public static Path createTempDirectory(String s) {
        new File(OS.getTarget()).mkdir();
        return Paths.get(OS.getTarget(), s + "-" + Time.uniqueId() + ".tmp");
    }

    public static void unmonitor(Object t) {
        IOTools.unmonitor(t, 4);
    }

    private static void unmonitor(Object t, int depth) {
        if (t == null) {
            return;
        }
        if (t instanceof Serializable || t instanceof MonitorReferenceCounted) {
            return;
        }
        if (t instanceof Closeable) {
            AbstractCloseable.unmonitor((Closeable)t);
        }
        if (t instanceof ReferenceCounted) {
            AbstractReferenceCounted.unmonitor((ReferenceCounted)t);
        }
        if (depth > 0) {
            IOTools.unmonitor(t.getClass(), t, depth - 1);
        }
    }

    private static <T> void unmonitor(Class aClass, Object t, int depth) {
        if (aClass == null || aClass == Object.class) {
            return;
        }
        IOTools.unmonitor(aClass.getSuperclass(), t, depth);
        for (Field field : aClass.getDeclaredFields()) {
            if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
            }
            catch (Exception e) {
                if (Jvm.isJava9Plus()) continue;
                Jvm.warn().on(IOTools.class, e);
                continue;
            }
            try {
                Object o = field.get(t);
                if (o == null) continue;
                IOTools.unmonitor(o, depth);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Jvm.warn().on(IOTools.class, e);
            }
        }
    }

    public static boolean isDirectBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.isDirect();
    }

    public static long addressFor(ByteBuffer byteBuffer) {
        return DirectBufferUtil.addressOrThrow(byteBuffer);
    }

    public static int normaliseIOStatus(int n) {
        return IOStatus.normalize(n);
    }
}

