/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AppendableUtil {

    private static final String MALFORMED_INPUT_AROUND_BYTE = "malformed input around byte ";

    public static void setCharAt(@NotNull Appendable sb, int index, char ch) throws IllegalArgumentException, BufferOverflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setCharAt(index, ch);
        } else if (sb instanceof Bytes) {
            try {
                ((Bytes)sb).writeByte((long)index, ch);
            }
            catch (ArithmeticException | IllegalStateException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void parseUtf8(@NotNull BytesStore bs, StringBuilder sb, boolean utf, int length) throws UTFDataFormatRuntimeException, BufferUnderflowException, IllegalStateException {
        BytesInternal.parseUtf8(bs, bs.readPosition(), sb, utf, length);
    }

    public static void setLength(@NotNull Appendable sb, int newLength) throws IllegalArgumentException, IllegalStateException, BufferUnderflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setLength(newLength);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).readPositionRemaining(0L, newLength);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, double value) throws IllegalArgumentException, BufferOverflowException, IllegalStateException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, long value) throws IllegalArgumentException, BufferOverflowException, IllegalStateException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(@NotNull ACS sb, String str) {
        try {
            sb.append(str);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharsTester tester) throws IllegalStateException {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte(), bytes.peekUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    public static void readUTFAndAppend(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws BufferUnderflowException, IllegalStateException {
        try {
            AppendableUtil.readUtf8AndAppend(bytes, appendable, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readUtf8AndAppend(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws BufferUnderflowException, IOException, IllegalStateException {
        block15: {
            do lbl-1000:
            // 3 sources

            {
                block16: {
                    if ((c = bytes.readUnsignedByte()) >= 128) {
                        bytes.readSkip(-1L);
                        break block15;
                    }
                    if (c != 91 || bytes.peekUnsignedByte() != 93) break block16;
                    appendable.append((char)c);
                    appendable.append((char)bytes.readUnsignedByte());
                    if (bytes.readRemaining() != 0L) ** GOTO lbl-1000
                    return;
                }
                if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                    return;
                }
                appendable.append((char)c);
            } while (bytes.readRemaining() != 0L);
            return;
        }
        block6: while ((c = bytes.readUnsignedByte()) >= 0) {
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    char2 = bytes.readUnsignedByte();
                    if ((char2 & 192) != 128) {
                        throw AppendableUtil.newUTFDataFormatException(char2);
                    }
                    c2 = (char)((c & 31) << 6 | char2 & 63);
                    if (tester.isStopChar(c2, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    char2 = bytes.readUnsignedByte();
                    char3 = bytes.readUnsignedByte();
                    if ((char2 & 192) != 128) {
                        throw AppendableUtil.newUTFDataFormatException(char2);
                    }
                    if ((char3 & 192) != 128) {
                        throw AppendableUtil.newUTFDataFormatException(char3);
                    }
                    c3 = (char)((c & 15) << 12 | (char2 & 63) << 6 | char3 & 63);
                    if (tester.isStopChar(c3, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            throw AppendableUtil.newUTFDataFormatException(c);
        }
    }

    private static UTFDataFormatException newUTFDataFormatException(int c) {
        return new UTFDataFormatException(MALFORMED_INPUT_AROUND_BYTE + Integer.toHexString(c));
    }

    public static void parse8bit_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int length) throws BufferUnderflowException, IllegalStateException {
        if ((long)length > bytes.readRemaining()) {
            throw new BufferUnderflowException();
        }
        @Nullable NativeBytesStore nbs = (NativeBytesStore)bytes.bytesStore();
        long offset = bytes.readPosition();
        int count = BytesInternal.parse8bit_SB1(offset, nbs, sb, length);
        bytes.readSkip(count);
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws BufferUnderflowException, IOException, IllegalStateException {
        if (appendable instanceof StringBuilder) {
            @NotNull StringBuilder sb = (StringBuilder)appendable;
            if (bytes instanceof Bytes && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore) {
                AppendableUtil.parse8bit_SB1((Bytes)bytes, sb, utflen);
            } else {
                BytesInternal.parse8bit1(bytes, sb, utflen);
            }
        } else {
            BytesInternal.parse8bit1(bytes, appendable, utflen);
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(ACS a, CharSequence cs, long start, long len) throws ArithmeticException, BufferUnderflowException, IllegalStateException, BufferOverflowException {
        if (a instanceof StringBuilder) {
            if (cs instanceof Bytes) {
                ((StringBuilder)a).append(Bytes.toString((Bytes)cs, start, len));
            } else {
                ((StringBuilder)a).append(cs.subSequence(Maths.toInt32(start), Maths.toInt32(len)));
            }
        } else if (a instanceof Bytes) {
            ((Bytes)a).appendUtf8(cs, Maths.toInt32(start), Maths.toInt32(len));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static long findUtf8Length(@NotNull CharSequence str) throws IndexOutOfBoundsException {
        int strlen = str.length();
        long utflen = strlen;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull byte[] bytes, byte coder) {
        long utflen;
        if (coder == 0) {
            int strlen = bytes.length;
            utflen = bytes.length;
            for (int i = 0; i < strlen; ++i) {
                int b = bytes[i] & 0xFF;
                if (b <= 127) continue;
                ++utflen;
            }
        } else {
            int strlen = bytes.length;
            utflen = 0L;
            for (int i = 0; i < strlen; i += 2) {
                char c = (char)((bytes[i + 1] & 0xFF) << 8 | bytes[i] & 0xFF);
                if (c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c <= '\u07ff') {
                    utflen += 2L;
                    continue;
                }
                utflen += 3L;
            }
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull byte[] chars) {
        int c;
        long utflen = 0L;
        int strlen = chars.length;
        for (int i = 0; i < strlen && (c = chars[i] & 0xFF) != 0; ++i) {
            if (c >= 240) {
                utflen += 4L;
                i += 3;
                continue;
            }
            if (c >= 224) {
                utflen += 3L;
                i += 2;
                continue;
            }
            if (c >= 192) {
                utflen += 2L;
                ++i;
                continue;
            }
            ++utflen;
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull char[] chars, int offset, int length) {
        long utflen = length;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            char c = chars[i];
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull char[] chars) {
        return AppendableUtil.findUtf8Length(chars, 0, chars.length);
    }
}

