/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleDefaultingTest
extends QueueTestCommon {
    @Test
    public void alias() {
        Assert.assertEquals(RollCycles.class, (Object)ObjectUtils.implementationToUse(RollCycle.class));
    }

    @Test
    public void correctConfigGetsLoaded() {
        String aClass = RollCycles.HOURLY.getClass().getName();
        String configuredCycle = aClass + ":HOURLY";
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertEquals((Object)RollCycles.HOURLY, (Object)builder.rollCycle());
    }

    @Test
    public void customDefinitionGetsLoaded() {
        String configuredCycle = MyRollcycle.class.getName();
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertTrue((boolean)(builder.rollCycle() instanceof MyRollcycle));
    }

    @Test
    public void unknownClassDefaultsToDaily() {
        this.expectException("Default roll cycle class: foobarblah was not found");
        String configuredCycle = "foobarblah";
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertEquals((Object)RollCycles.DEFAULT, (Object)builder.rollCycle());
    }

    @Test
    public void nonRollCycleDefaultsToDaily() {
        this.expectException("Configured default rollcycle is not a subclass of RollCycle");
        String configuredCycle = String.class.getName();
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertEquals((Object)RollCycles.DEFAULT, (Object)builder.rollCycle());
    }

    public static class MyRollcycle
    implements RollCycle {
        private final RollCycle delegate = RollCycles.TEST_SECONDLY;

        @NotNull
        public String format() {
            return "xyz";
        }

        public int lengthInMillis() {
            return this.delegate.lengthInMillis();
        }

        public int defaultIndexCount() {
            return this.delegate.defaultIndexCount();
        }

        public int defaultIndexSpacing() {
            return this.delegate.defaultIndexSpacing();
        }

        public int current(TimeProvider time, long epoch) {
            return this.delegate.current(time, epoch);
        }

        public long toIndex(int cycle, long sequenceNumber) {
            return this.delegate.toIndex(cycle, sequenceNumber);
        }

        public long toSequenceNumber(long index) {
            return this.delegate.toSequenceNumber(index);
        }

        public int toCycle(long index) {
            return this.delegate.toCycle(index);
        }

        public long maxMessagesPerCycle() {
            return 0L;
        }
    }
}

