/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.threads.EventLoopLifecycle;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLifecycleEventLoop
extends AbstractCloseable
implements EventLoop {
    private final AtomicReference<EventLoopLifecycle> lifecycle = new AtomicReference<EventLoopLifecycle>(EventLoopLifecycle.NEW);
    protected final String name;

    protected AbstractLifecycleEventLoop(@NotNull String name) {
        this.name = name;
        this.disableThreadSafetyCheck(true);
    }

    @Override
    public final void start() {
        this.throwExceptionIfClosed();
        if (this.lifecycle.compareAndSet(EventLoopLifecycle.NEW, EventLoopLifecycle.STARTED)) {
            this.performStart();
        }
    }

    @Override
    public final String name() {
        return this.name;
    }

    protected abstract void performStart();

    @Override
    public final void stop() {
        if (this.lifecycle.compareAndSet(EventLoopLifecycle.NEW, EventLoopLifecycle.STOPPING)) {
            this.performStopFromNew();
            this.lifecycle.set(EventLoopLifecycle.STOPPED);
        } else if (this.lifecycle.compareAndSet(EventLoopLifecycle.STARTED, EventLoopLifecycle.STOPPING)) {
            this.performStopFromStarted();
            this.lifecycle.set(EventLoopLifecycle.STOPPED);
        }
        this.awaitTermination();
    }

    protected abstract void performStopFromNew();

    protected abstract void performStopFromStarted();

    @Override
    public final void awaitTermination() {
        while (!Thread.currentThread().isInterrupted()) {
            if (this.lifecycle.get() == EventLoopLifecycle.STOPPED) {
                return;
            }
            Jvm.pause(1L);
        }
        if (this.lifecycle.get() != EventLoopLifecycle.STOPPED) {
            Jvm.warn().on(this.getClass(), "awaitTermination() interrupted, returning in state " + (Object)((Object)this.lifecycle.get()));
        }
    }

    @Override
    protected void performClose() {
        this.stop();
    }

    protected boolean isStarted() {
        return this.lifecycle.get() == EventLoopLifecycle.STARTED;
    }
}

