/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;

public class TSQueueLock
extends AbstractTSQueueLock
implements QueueLock {
    private static final String LOCK_KEY = "chronicle.queue.lock";
    private final long timeout;

    public TSQueueLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, long timeoutMs) {
        super(LOCK_KEY, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (this.isLockHeldByCurrentThread(tid)) {
            return;
        }
        int count = 0;
        long lockValueFromTid = this.getLockValueFromTid(tid);
        long value = this.lock.getVolatileValue();
        Pauser tlPauser = (Pauser)this.pauser.get();
        try {
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, lockValueFromTid)) {
                if (count++ > 1000 && Thread.currentThread().isInterrupted()) {
                    throw new InterruptedRuntimeException("Interrupted");
                }
                tlPauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                value = this.lock.getVolatileValue();
            }
        }
        catch (TimeoutException e) {
            this.warnLock("Overriding the lock. Couldn't acquire lock", value);
            this.forceUnlock(value);
            this.acquireLock();
        }
        finally {
            tlPauser.reset();
        }
    }

    private long getLockValueFromTid(long tid) {
        return tid << 32 | PID;
    }

    @Override
    public void waitForLock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (this.isLockHeldByCurrentThread(tid)) {
            return;
        }
        long value = this.lock.getVolatileValue();
        Pauser tlPauser = (Pauser)this.pauser.get();
        try {
            while (value != Long.MIN_VALUE) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedRuntimeException("Interrupted");
                }
                tlPauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                value = this.lock.getVolatileValue();
            }
        }
        catch (TimeoutException e) {
            this.warnLock("Queue lock is still held", value);
            this.forceUnlock(value);
            this.waitForLock();
        }
        catch (NullPointerException ex) {
            if (!this.tableStore.isClosed()) {
                throw ex;
            }
            throw new IllegalStateException("The table store is closed!", ex);
        }
        finally {
            tlPauser.reset();
        }
    }

    private void warnLock(String msg, long value) {
        String pid = (long)((int)value) == PID ? "me" : Integer.toString((int)value);
        String warningMsg = msg + " after " + this.timeout + "ms for the lock file:" + this.path + ". Lock is held by PID: " + pid + ", TID: " + (int)(value >>> 32);
        if (this.dontRecoverLockTimeout) {
            throw new UnrecoverableTimeoutException(new IllegalStateException(warningMsg));
        }
        Jvm.warn().on(this.getClass(), warningMsg + ". Unlocking forcibly");
    }

    @Override
    public void unlock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (!this.lock.compareAndSwapValue(this.getLockValueFromTid(tid), Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Queue lock was locked by another thread, currentID=" + tid + ", lock-tid=" + this.lock.getVolatileValue() + " so this lock was not removed.");
        }
    }

    @Override
    public void quietUnlock() {
        long tid;
        this.throwExceptionIfClosed();
        if (this.lockedBy() != Long.MIN_VALUE && !this.lock.compareAndSwapValue(this.getLockValueFromTid(tid = Thread.currentThread().getId()), Long.MIN_VALUE)) {
            long value = this.lock.getVolatileValue();
            if (value == Long.MIN_VALUE) {
                return;
            }
            Jvm.warn().on(this.getClass(), "Queue lock was locked by another thread, current-thread-tid=" + tid + ", lock value=" + value + ", this lock was not removed.");
        }
    }

    @Override
    public boolean isLocked() {
        return this.lockedBy() != Long.MIN_VALUE;
    }

    private boolean isLockHeldByCurrentThread(long tid) {
        return this.lock.getVolatileValue() == this.getLockValueFromTid(tid);
    }
}

