/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.CommonMappedBytes;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleMappedBytes
extends CommonMappedBytes {
    public SingleMappedBytes(@NotNull MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected SingleMappedBytes(@NotNull MappedFile mappedFile, String name) throws IllegalStateException {
        super(mappedFile, name);
        try {
            this.bytesStore((BytesStore)mappedFile.acquireByteStore(this, 0L));
            assert (this.bytesStore.reservedBy(this));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    @NotNull
    public SingleMappedBytes write(long offsetInRDO, byte[] bytes, int offset, int length) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        long wp = offsetInRDO;
        if (length + offset > bytes.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + bytes.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        int remaining = length;
        while (remaining > 0) {
            long safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= (long)remaining) {
                this.bytesStore.write(wp, bytes, offset, remaining);
                return this;
            }
            this.bytesStore.write(wp, bytes, offset, (int)safeCopySize);
            offset = (int)((long)offset + safeCopySize);
            wp += safeCopySize;
            remaining = (int)((long)remaining - safeCopySize);
        }
        return this;
    }

    @Override
    @NotNull
    public SingleMappedBytes write(long writeOffset, RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        long safeCopySize;
        this.throwExceptionIfClosed();
        long wp = writeOffset;
        if (length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        for (long remaining = length; remaining > 0L; remaining -= safeCopySize) {
            safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= remaining) {
                this.bytesStore.write(wp, bytes, readOffset, remaining);
                return this;
            }
            this.bytesStore.write(wp, bytes, readOffset, safeCopySize);
            readOffset += safeCopySize;
            wp += safeCopySize;
        }
        return this;
    }

    private long copySize(long writePosition) {
        long size = this.mappedFile.chunkSize();
        return size - writePosition % size;
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(long position, long remaining) throws BufferUnderflowException, IllegalStateException {
        long limit = position + remaining;
        try {
            if (this.writeLimit < limit) {
                this.writeLimit(limit);
            }
            if (Jvm.isAssertEnabled()) {
                this.readLimit(limit);
            } else {
                this.uncheckedWritePosition(limit);
            }
            return this.readPosition(position);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long checkSize(long adding) {
        if (adding < 0L || adding > 0x7FFFFFFFFFFFFFF0L) {
            throw new IllegalArgumentException("Invalid size " + adding);
        }
        return adding;
    }

    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(this.writePosition(), Math.min(128L, bytesToSkip));
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @NotNull
    private BufferOverflowException writeBufferOverflowException(long offset) {
        BufferOverflowException exception = new BufferOverflowException();
        exception.initCause(new IllegalArgumentException("Offset out of bound " + offset));
        return exception;
    }

    @Override
    @NotNull
    public Bytes<Void> clear() throws IllegalStateException {
        long start;
        this.readPosition = start = 0L;
        this.uncheckedWritePosition(start);
        this.writeLimit = this.mappedFile.capacity();
        return this;
    }

    @Override
    public int peekVolatileInt() throws IllegalStateException {
        @Nullable MappedBytesStore bytesStore = this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(this.readPosition);
        @Nullable Memory memory = bytesStore.memory;
        if ((address & 0x3FL) <= 60L) {
            ObjectUtils.requireNonNull(memory);
            UnsafeMemory.unsafeLoadFence();
            return UnsafeMemory.unsafeGetInt(address);
        }
        return memory.readVolatileInt(address);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (offset < 0L || offset > this.capacity()) {
            throw this.writeBufferOverflowException(offset);
        }
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }
}

