/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import net.openhft.affinity.lockchecker.FileLockBasedLockChecker;
import net.openhft.affinity.lockchecker.LockChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum LockCheck {

    private static final Logger LOGGER = LoggerFactory.getLogger(LockCheck.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();
    static final boolean IS_LINUX = OS.startsWith("linux");
    private static final int EMPTY_PID = Integer.MIN_VALUE;
    private static final LockChecker lockChecker = FileLockBasedLockChecker.getInstance();

    static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    static boolean canOSSupportOperation() {
        return IS_LINUX;
    }

    public static boolean isCpuFree(int cpu) {
        if (!LockCheck.canOSSupportOperation()) {
            return true;
        }
        if (LockCheck.isLockFree(cpu)) {
            return true;
        }
        int currentProcess = 0;
        try {
            currentProcess = LockCheck.getProcessForCpu(cpu);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("Failed to determine process on cpu " + cpu, e);
            e.printStackTrace();
            return true;
        }
        if (!LockCheck.isProcessRunning(currentProcess)) {
            lockChecker.releaseLock(cpu);
            return true;
        }
        return false;
    }

    static void replacePid(int cpu, long processID) throws IOException {
        LockCheck.storePid(processID, cpu);
    }

    static boolean isProcessRunning(long pid) {
        if (LockCheck.canOSSupportOperation()) {
            return new File("/proc/" + pid).exists();
        }
        throw new UnsupportedOperationException("this is only supported on LINUX");
    }

    private static synchronized void storePid(long processID, int cpu) throws IOException {
        if (!lockChecker.obtainLock(cpu, Long.toString(processID))) {
            throw new IOException(String.format("Cannot obtain file lock for cpu %d", cpu));
        }
    }

    private static synchronized boolean isLockFree(int id) {
        return lockChecker.isLockFree(id);
    }

    static int getProcessForCpu(int core) throws IOException {
        String meta = lockChecker.getMetaInfo(core);
        if (meta != null && !meta.isEmpty()) {
            try {
                return Integer.parseInt(meta);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    static void updateCpu(int cpu) {
        if (!LockCheck.canOSSupportOperation()) {
            return;
        }
        try {
            LockCheck.replacePid(cpu, LockCheck.getPID());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to update lock file for cpu " + cpu, e);
            e.printStackTrace();
        }
    }

    public static void releaseLock(int cpu) {
        lockChecker.releaseLock(cpu);
    }
}

