/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class StuckQueueTest
extends ChronicleQueueTestBase {
    @Test
    public void test() throws IOException {
        Assume.assumeFalse((boolean)Jvm.isMacArm());
        Assume.assumeFalse((boolean)OS.isWindows());
        Path tmpDir = this.getTmpDir().toPath();
        this.expectException("Failback to readonly tablestore");
        this.expectException("reading control code as text");
        tmpDir.toFile().mkdirs();
        Path templatePath = Paths.get(StuckQueueTest.class.getResource("/stuck.queue.test/20180508-1249.cq4").getFile(), new String[0]);
        Path to = tmpDir.resolve(templatePath.getFileName());
        Files.copy(templatePath, to, StandardCopyOption.REPLACE_EXISTING);
        try (SingleChronicleQueue q = ChronicleQueue.singleBuilder((Path)tmpDir).rollCycle((RollCycle)RollCycles.MINUTELY).readOnly(true).build();
             ExcerptTailer tailer = q.createTailer();){
            int cycle = q.rollCycle().toCycle(109219854401142784L);
            try (SingleChronicleQueueStore wireStore = q.storeForCycle(cycle, q.epoch(), false, null);){
                String absolutePath = wireStore.file().getAbsolutePath();
                Assert.assertTrue((boolean)absolutePath.endsWith("20180508-1249.cq4"));
            }
            DocumentContext dc = tailer.readingDocument();
            var10_14 = null;
            if (dc != null) {
                if (var10_14 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable absolutePath) {
                        var10_14.addSuppressed(absolutePath);
                    }
                } else {
                    dc.close();
                }
            }
            var10_14 = null;
            try (SingleChronicleQueue q2 = ChronicleQueue.singleBuilder((Path)tmpDir).rollCycle((RollCycle)RollCycles.MINUTELY).build();
                 DocumentContext dc2 = q2.acquireAppender().writingDocument();){
                dc2.wire().write((CharSequence)"hello").text("world");
            }
            catch (Throwable throwable) {
                var10_14 = throwable;
                throw throwable;
            }
            ExcerptTailer tailer2 = q.createTailer();
            try (DocumentContext dc3 = tailer2.readingDocument();){
                Assert.assertTrue((boolean)dc3.isPresent());
                String actual = dc3.wire().read("hello").text();
                Assert.assertEquals((Object)"world", (Object)actual);
            }
        }
    }
}

