/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.IndexNotAvailableException;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class StoreAppenderDoubleBufferTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreAppenderDoubleBufferTest.class);
    private final int iterations;
    private final Class<? extends BlockedWriterScenario> scenarioClass;

    public StoreAppenderDoubleBufferTest(int iterations, Class<? extends BlockedWriterScenario> scenarioClass) {
        this.iterations = iterations;
        this.scenarioClass = scenarioClass;
    }

    @Parameterized.Parameters(name="iterations={0},scenarioClass={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({1, RawBlockedWriterScenario.class}, {2, RawBlockedWriterScenario.class}, {3, RawBlockedWriterScenario.class}, {1, MethodWriterBlockedWriterScenario.class}, {2, MethodWriterBlockedWriterScenario.class}, {3, MethodWriterBlockedWriterScenario.class}, {5, RollbackBlockedWriterScenario.class}, {1, CallIndexWhileBlockedWriterScenario.class});
    }

    @Test
    public void disabled() {
    }

    public void testDoubleBuffering() throws InterruptedException, ExecutionException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("q")).doubleBuffer(true).rollCycle((RollCycle)RollCycles.MINUTELY).timeProvider(() -> 0L).build();){
            BlockedWriterScenario blockedWriterScenario = this.scenarioClass.getConstructor(ChronicleQueue.class, Integer.class).newInstance(q, this.iterations);
            blockedWriterScenario.run();
            ExcerptTailer tailer = q.createTailer();
            for (int i = 0; i < this.iterations; ++i) {
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertEquals((Object)"blocker-before", (Object)dc.wire().read().text());
                    Assert.assertEquals((Object)"blocker-after", (Object)dc.wire().read().text());
                }
                blockedWriterScenario.readBlockeeRecordForIteration(i, tailer);
            }
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
        }
    }

    static class CallIndexWhileBlockedWriterScenario
    extends RawBlockedWriterScenario {
        public CallIndexWhileBlockedWriterScenario(ChronicleQueue queue, Integer iterations) {
            super(queue, iterations);
        }

        @Override
        protected void writeRecordContents(int iteration, DocumentContext documentContext) {
            try {
                documentContext.index();
                Assert.fail();
            }
            catch (IndexNotAvailableException e) {
                super.writeRecordContents(iteration, documentContext);
            }
        }
    }

    static class RollbackBlockedWriterScenario
    extends RawBlockedWriterScenario {
        public RollbackBlockedWriterScenario(ChronicleQueue queue, Integer iterations) {
            super(queue, iterations);
            if (iterations < 3) {
                throw new IllegalArgumentException("This test is only meaningful with at least three iterations");
            }
        }

        @Override
        protected void writeRecordContents(int iteration, DocumentContext documentContext) {
            super.writeRecordContents(iteration, documentContext);
            if (this.shouldRollBack(iteration)) {
                documentContext.rollbackOnClose();
            }
        }

        @Override
        public void readBlockeeRecordForIteration(int iteration, ExcerptTailer tailer) {
            if (this.shouldRollBack(iteration)) {
                return;
            }
            super.readBlockeeRecordForIteration(iteration, tailer);
        }

        private boolean shouldRollBack(int iteration) {
            return iteration % 2 == 0;
        }
    }

    static class RawBlockedWriterScenario
    extends BlockedWriterScenario {
        public RawBlockedWriterScenario(ChronicleQueue queue, Integer iterations) {
            super(queue, iterations);
        }

        @Override
        protected void writeBlockeeRecordForIteration(int iteration, ExcerptAppender appender) throws BrokenBarrierException, InterruptedException {
            try (DocumentContext dc = appender.writingDocument();){
                this.blockeeHasDocumentContext.await();
                this.writeRecordContents(iteration, dc);
            }
        }

        protected void writeRecordContents(int iteration, DocumentContext documentContext) {
            documentContext.wire().write().text("blocked!");
        }

        @Override
        public void readBlockeeRecordForIteration(int iteration, ExcerptTailer tailer) {
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)"blocked!", (Object)dc.wire().read().text());
            }
        }
    }

    static class MethodWriterBlockedWriterScenario
    extends BlockedWriterScenario {
        public MethodWriterBlockedWriterScenario(ChronicleQueue queue, Integer iterations) {
            super(queue, iterations);
        }

        @Override
        protected void writeBlockeeRecordForIteration(int iteration, ExcerptAppender appender) {
            Foo foo = (Foo)appender.methodWriterBuilder(Foo.class).updateInterceptor((name, arg) -> {
                if ("foo".equals(name)) {
                    try {
                        this.blockeeHasDocumentContext.await();
                    }
                    catch (InterruptedException | BrokenBarrierException e) {
                        Assert.fail();
                    }
                }
                return true;
            }).build();
            foo.foo("foo").bar("bar");
        }

        @Override
        public void readBlockeeRecordForIteration(int iteration, ExcerptTailer tailer) {
            CountingFoo countingFoo = new CountingFoo();
            try (MethodReader methodReader = tailer.methodReaderBuilder().build(new Object[]{countingFoo});){
                Assert.assertTrue((boolean)methodReader.readOne());
                Assert.assertEquals((long)1L, (long)countingFoo.fooCount);
                Assert.assertEquals((long)1L, (long)countingFoo.barCount);
            }
        }

        static class CountingFoo
        implements Foo {
            int fooCount = 0;
            int barCount = 0;

            CountingFoo() {
            }

            @Override
            public Bar foo(String str) {
                ++this.fooCount;
                return msg -> ++this.barCount;
            }
        }

        static interface Bar {
            public void bar(String var1);
        }

        static interface Foo {
            public Bar foo(String var1);
        }
    }

    private static abstract class BlockedWriterScenario {
        protected final ChronicleQueue queue;
        protected final CyclicBarrier everyoneHasAppenders = new CyclicBarrier(2, () -> LOGGER.info("Everyone has appenders"));
        protected final CyclicBarrier blockerHasDocumentContext = new CyclicBarrier(2, () -> LOGGER.info("Blocker has DC"));
        protected final CyclicBarrier blockeeHasDocumentContext = new CyclicBarrier(2, () -> LOGGER.info("Blockee has DC"));
        protected final CyclicBarrier iterationFinished = new CyclicBarrier(2, () -> LOGGER.info("Iteration finished"));
        protected final int iterations;

        public BlockedWriterScenario(ChronicleQueue queue, Integer iterations) {
            this.queue = queue;
            this.iterations = iterations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ExecutionException, InterruptedException {
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            try {
                Future<?> blockerFuture = executorService.submit(this::runBlocker);
                Future<?> blockedFuture = executorService.submit(this::runBlockee);
                blockedFuture.get();
                blockerFuture.get();
            }
            finally {
                executorService.shutdown();
            }
        }

        public void runBlocker() {
            LOGGER.info("--- Starting {} iterations ({}) --", (Object)this.iterations, (Object)this.getClass().getSimpleName());
            try (ExcerptAppender appender = this.queue.acquireAppender();){
                this.everyoneHasAppenders.await();
                for (int i = 0; i < this.iterations; ++i) {
                    LOGGER.info("--- Starting iteration {}/{} --", (Object)(i + 1), (Object)this.iterations);
                    try (DocumentContext ctx = appender.writingDocument();){
                        this.blockerHasDocumentContext.await();
                        ctx.wire().write().text("blocker-before");
                        this.blockeeHasDocumentContext.await();
                        ctx.wire().write().text("blocker-after");
                    }
                    this.iterationFinished.await();
                }
                LOGGER.info("Blocker finished");
            }
            catch (InterruptedException | BrokenBarrierException ex) {
                Assert.fail();
            }
        }

        public void runBlockee() {
            try (ExcerptAppender appender = this.queue.acquireAppender();){
                this.everyoneHasAppenders.await();
                for (int i = 0; i < this.iterations; ++i) {
                    this.blockerHasDocumentContext.await();
                    this.writeBlockeeRecordForIteration(i, appender);
                    this.iterationFinished.await();
                }
                LOGGER.info("Blockee finished");
            }
            catch (InterruptedException | BrokenBarrierException e) {
                Assert.fail();
            }
        }

        protected abstract void writeBlockeeRecordForIteration(int var1, ExcerptAppender var2) throws InterruptedException, BrokenBarrierException;

        public abstract void readBlockeeRecordForIteration(int var1, ExcerptTailer var2);
    }
}

