/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class QueueWriteDocumentContextTest {
    static void writeThreeKeys(MarshallableOut wire) {
        try (DocumentContext dc0 = wire.acquireWritingDocument(false);){
            for (int i = 0; i < 3; ++i) {
                try (DocumentContext dc = wire.acquireWritingDocument(false);){
                    dc.wire().write((CharSequence)"key").int32(i);
                }
                Assert.assertTrue((boolean)dc0.isNotComplete());
            }
        }
    }

    static void writeThreeChainedKeys(MarshallableOut wire) {
        for (int i = 0; i < 3; ++i) {
            try (WriteDocumentContext dc = (WriteDocumentContext)wire.acquireWritingDocument(false);){
                dc.wire().write((CharSequence)"key").int32(i);
                dc.chainedElement(i < 2);
                continue;
            }
        }
    }

    @Test
    public void nestedPlainText() {
        String s = "/nestedPlainText";
        try (SingleChronicleQueue cq = this.createQueue(s);){
            QueueWriteDocumentContextTest.writeThreeKeys((MarshallableOut)cq.acquireAppender());
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 176, header: 0\n--- !!data #binary\nlisting.highestCycle: 18554\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 18554\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 3\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n# 130596 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    392,\n    1683627180032\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 296, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 392, header: 0\n--- !!data #binary\nkey: 0\nkey: 1\nkey: 2\n...\n# 130656 bytes remaining\n", (Object)cq.dump());
        }
    }

    @Test
    public void chainedPlainText() {
        String s = "/chainedPlainText";
        try (SingleChronicleQueue cq = this.createQueue(s);){
            QueueWriteDocumentContextTest.writeThreeChainedKeys((MarshallableOut)cq.acquireAppender());
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T1', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 176, header: 0\n--- !!data #binary\nlisting.highestCycle: 18554\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 18554\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 3\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n# 130596 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    392,\n    1683627180032\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 196,\n    lastIndex: 1\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  296,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 296, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  392,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 392, header: 0\n--- !!data #binary\nkey: 0\nkey: 1\nkey: 2\n...\n# 130656 bytes remaining\n", (Object)cq.dump());
        }
    }

    @NotNull
    protected SingleChronicleQueue createQueue(String s) {
        return SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir(s)).rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider((TimeProvider)new SetTimeProvider("2020/10/19T01:01:01")).testBlockSize().build();
    }
}

