/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.wire.MessageHistory;
import org.junit.After;
import org.junit.Before;

public class QueueTestCommon {
    private final Map<Predicate<ExceptionKey>, String> ignoreExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();
    private final Map<Predicate<ExceptionKey>, String> expectedExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();
    protected ThreadDump threadDump;
    protected Map<ExceptionKey, Integer> exceptions;
    protected boolean finishedNormally;

    @Before
    public void assumeFinishedNormally() {
        this.finishedNormally = true;
    }

    @Before
    public void clearMessageHistory() {
        MessageHistory.get().reset();
    }

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptions = Jvm.recordExceptions();
    }

    public void ignoreException(String message) {
        this.ignoreException(k -> k.message.contains(message) || k.throwable != null && k.throwable.getMessage().contains(message), message);
    }

    public void expectException(String message) {
        this.expectException(k -> k.message.contains(message) || k.throwable != null && k.throwable.getMessage().contains(message), message);
    }

    public void ignoreException(Predicate<ExceptionKey> predicate, String description) {
        this.ignoreExceptions.put(predicate, description);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.expectedExceptions.put(predicate, description);
    }

    public void checkExceptions() {
        for (Map.Entry<Predicate<ExceptionKey>, String> expectedException : this.expectedExceptions.entrySet()) {
            if (!this.exceptions.keySet().removeIf(expectedException.getKey())) {
                throw new AssertionError((Object)("No error for " + expectedException.getValue()));
            }
        }
        this.expectedExceptions.clear();
        for (Map.Entry<Predicate<ExceptionKey>, String> expectedException : this.ignoreExceptions.entrySet()) {
            if (this.exceptions.keySet().removeIf(expectedException.getKey())) continue;
            Slf4jExceptionHandler.DEBUG.on(this.getClass(), "No error for " + expectedException.getValue());
        }
        this.ignoreExceptions.clear();
        for (String msg : "Shrinking ,Allocation of , ms to add mapping for ,jar to the classpath, ms to pollDiskSpace for , us to linearScan by position from ,File released ,Overriding roll length from existing metadata, was 3600000, overriding to 86400000   ".split(",")) {
            this.exceptions.keySet().removeIf(e -> e.message.contains(msg));
        }
        if (Jvm.hasException(this.exceptions)) {
            Jvm.dumpException(this.exceptions);
            Jvm.resetExceptionHandlers();
            throw new AssertionError(this.exceptions.keySet());
        }
    }

    protected boolean hasExceptions(Map<ExceptionKey, Integer> exceptions) {
        return Jvm.hasException(this.exceptions);
    }

    @After
    public void afterChecks() {
        SystemTimeProvider.CLOCK = SystemTimeProvider.INSTANCE;
        this.preAfter();
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        System.gc();
        AbstractCloseable.waitForCloseablesToClose((long)100L);
        if (this.finishedNormally) {
            this.assertReferencesReleased();
            this.checkThreadDump();
            this.checkExceptions();
        }
        this.tearDown();
    }

    protected void preAfter() {
    }

    protected void tearDown() {
    }
}

