/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.AbstractLifecycleEventLoop;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class BlockingEventLoop
extends AbstractLifecycleEventLoop
implements EventLoop {
    @NotNull
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> handlers = new CopyOnWriteArrayList<EventHandler>();
    private final NamedThreadFactory threadFactory;
    private final Pauser pauser = Pauser.balanced();

    public BlockingEventLoop(@NotNull EventLoop parent, @NotNull String name) {
        super(name);
        this.parent = parent;
        this.threadFactory = new NamedThreadFactory(name, null, null, true);
        this.service = Executors.newCachedThreadPool(this.threadFactory);
    }

    public BlockingEventLoop(@NotNull String name) {
        super(name);
        this.parent = this;
        this.threadFactory = new NamedThreadFactory(name, null, null, true);
        this.service = Executors.newCachedThreadPool(this.threadFactory);
    }

    @Override
    public synchronized void addHandler(@NotNull EventHandler handler) {
        if (DEBUG_ADDING_HANDLERS) {
            Jvm.startup().on(this.getClass(), "Adding " + (Object)((Object)handler.priority()) + " " + handler + " to " + this.name);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed");
        }
        this.handlers.add(handler);
        handler.eventLoop(this.parent);
        if (this.isStarted()) {
            this.startHandler(handler);
        }
    }

    @Override
    protected synchronized void performStart() {
        this.handlers.forEach(this::startHandler);
    }

    private void startHandler(EventHandler handler) {
        block2: {
            try {
                this.service.submit(new Runner(handler));
            }
            catch (RejectedExecutionException e) {
                if (this.service.isShutdown()) break block2;
                Jvm.warn().on(this.getClass(), e);
            }
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
        Threads.unpark(this.service);
    }

    @Override
    protected void performStopFromNew() {
        this.shutdownExecutorService();
        this.handlers.forEach(Threads::loopFinishedQuietly);
    }

    @Override
    protected void performStopFromStarted() {
        this.shutdownExecutorService();
    }

    private void shutdownExecutorService() {
        this.service.shutdownNow();
        this.unpause();
        Threads.shutdown(this.service);
    }

    @Override
    public boolean isAlive() {
        return !this.service.isShutdown();
    }

    @Override
    protected void performClose() {
        super.performClose();
        Closeable.closeQuietly(this.handlers);
    }

    @Override
    public String toString() {
        return "BlockingEventLoop{name=" + this.name + '}';
    }

    private final class Runner
    implements Runnable {
        private final EventHandler handler;
        private boolean endedGracefully = false;

        public Runner(EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                BlockingEventLoop.this.throwExceptionIfClosed();
                this.handler.loopStarted();
                while (BlockingEventLoop.this.isStarted()) {
                    if (this.handler.action()) {
                        BlockingEventLoop.this.pauser.reset();
                        continue;
                    }
                    BlockingEventLoop.this.pauser.pause();
                }
                this.endedGracefully = true;
            }
            catch (InvalidEventHandlerException invalidEventHandlerException) {
            }
            catch (Throwable t) {
                if (!BlockingEventLoop.this.isClosed()) {
                    Jvm.warn().on(this.handler.getClass(), this.asString(this.handler) + " threw ", t);
                }
            }
            finally {
                if (Jvm.isDebugEnabled(this.handler.getClass())) {
                    Jvm.debug().on(this.handler.getClass(), "handler " + this.asString(this.handler) + " done.");
                }
                Threads.loopFinishedQuietly(this.handler);
                if (!this.endedGracefully) {
                    BlockingEventLoop.this.handlers.remove(this.handler);
                    Closeable.closeQuietly((Object)this.handler);
                }
            }
        }

        private String asString(Object handler) {
            return Integer.toHexString(System.identityHashCode(handler));
        }
    }
}

