/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public class DistributedUniqueTimeProvider
extends SimpleCloseable
implements TimeProvider {
    private static final String USE_NAME = System.getProperty("user.name", "unknown");
    private static final String TIME_STAMP_DIR = System.getProperty("timestamp.dir", OS.TMP);
    static final String TIME_STAMP_PATH = System.getProperty("timestamp.path", TIME_STAMP_DIR + File.separator + ".time-stamp." + USE_NAME + ".dat");
    private static final Integer DEFAULT_HOST_ID = Integer.getInteger("hostId", 0);
    public static final DistributedUniqueTimeProvider INSTANCE = new DistributedUniqueTimeProvider(DEFAULT_HOST_ID, true);
    private static final int LAST_TIME = 128;
    private static final int HOST_IDS = 100;
    private static final int NANOS_PER_MICRO = 1000;
    private final Bytes bytes;
    private final MappedFile file;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;
    private int hostId;

    private DistributedUniqueTimeProvider(int hostId, boolean unmonitor) {
        this.hostId(hostId);
        try {
            this.file = MappedFile.ofSingle(new File(TIME_STAMP_PATH), OS.pageSize(), false);
            this.bytes = this.file.acquireBytesForWrite(this, 0L);
            this.bytes.append8bit("&TSF\nTime stamp file used for sharing a unique id\n");
            if (unmonitor) {
                IOTools.unmonitor(this.file);
                IOTools.unmonitor(this.bytes);
            }
        }
        catch (Exception ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public static DistributedUniqueTimeProvider forHostId(int hostId) {
        return new DistributedUniqueTimeProvider(hostId, false);
    }

    public DistributedUniqueTimeProvider hostId(int hostId) {
        if (hostId < 0) {
            throw new IllegalArgumentException("Invalid hostId: " + hostId);
        }
        this.hostId = hostId % 100;
        return this;
    }

    public DistributedUniqueTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() throws IllegalStateException {
        long timeus = this.provider.currentTimeMicros() / 100L;
        long time0us;
        long time;
        long time0;
        while (!this.bytes.compareAndSwapLong(128L, time0, time = (time0us = (time0 = this.bytes.readVolatileLong(128L)) / 100000L) >= timeus ? (time0us + 1L) * 100000L : timeus * 100000L)) {
            Jvm.nanoPause();
        }
        return time / 1000L + (long)this.hostId;
    }

    public static long timestampFor(long timestampWithHostId) {
        return timestampWithHostId - timestampWithHostId % 100L;
    }

    public static long hostIdFor(long timestampWithHostId) {
        return timestampWithHostId % 100L;
    }

    @Override
    protected void performClose() {
        super.performClose();
        this.bytes.release(this);
        this.file.releaseLast();
    }

    @Override
    public long currentTimeNanos() throws IllegalStateException {
        long time = this.provider.currentTimeNanos();
        long time0 = this.bytes.readVolatileLong(128L);
        long timeN = DistributedUniqueTimeProvider.timestampFor(time) + (long)this.hostId;
        if (timeN > time0 && this.bytes.compareAndSwapLong(128L, time0, timeN)) {
            return timeN;
        }
        return this.currentTimeNanosLoop();
    }

    private long currentTimeNanosLoop() {
        while (true) {
            long time0;
            long next;
            if ((next = DistributedUniqueTimeProvider.timestampFor(time0 = this.bytes.readVolatileLong(128L)) + (long)this.hostId) <= time0) {
                next += 100L;
            }
            if (this.bytes.compareAndSwapLong(128L, time0, next)) {
                return next;
            }
            Jvm.nanoPause();
        }
    }
}

