/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.bench.QueueMultiThreadedJLBHBenchmark;

public class QueueMultiThreadedJLBHBenchmark2 {
    private static final String PATH = System.getProperty("path", "/dev/shm") + "/replica";
    private static final int MSGSIZE = 512;
    private static final String CPU1 = System.getProperty("cpu1", "last-1");
    private static final String CPU2 = System.getProperty("cpu2", "last-2");
    private static final int ITERATIONS = 2000000000;
    private static final long BLOCKSIZE = 0x40000000000L;

    public static void main(String[] args) {
        System.out.println("-Dpath=" + PATH + " -Dcpu1=" + CPU1 + " -Dcpu2=" + CPU2);
        QueueMultiThreadedJLBHBenchmark2.warmUp();
        QueueMultiThreadedJLBHBenchmark.Builder commonOptions = new QueueMultiThreadedJLBHBenchmark.Builder().runs(1).path(PATH).producerAffinity(CPU1).consumerAffinity(CPU2).warmupIterations(5000000).usePretoucher(true).useSingleQueueInstance(true).messageSize(512).blockSize(0x40000000000L).rollCycle((RollCycle)RollCycles.HUGE_DAILY).testClass(QueueMultiThreadedJLBHBenchmark2.class);
        for (int r = 0; r <= 1; ++r) {
            int[] throughputs;
            for (int throughput : throughputs = new int[]{1500000, 250000}) {
                System.out.println("Throughput: " + throughput / 1000 + "k msgs/s");
                commonOptions.throughput(throughput).iterations(r == 0 ? 150000000 : 2000000000).run();
            }
        }
    }

    private static void warmUp() {
        System.setProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle", "true");
        MappedFile.warmup();
    }
}

