/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.TimeLimitExceededException;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.nio.ch.FileChannelImpl;

public final class OS {
    public static final String TMP = System.getProperty("java.io.tmpdir");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final Exception TIME_LIMIT = new TimeLimitExceededException();
    public static final int SAFE_PAGE_SIZE = 65536;
    static final ClassLocal<MethodHandle> MAP0_MH = ClassLocal.withInitial(c -> {
        try {
            Method map0 = Jvm.isJava14Plus() ? Jvm.getMethod(c, "map0", Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE) : Jvm.getMethod(c, "map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            return MethodHandles.lookup().unreflect(map0);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    });
    private static final String TARGET = OS.findTarget();
    private static final String HOST_NAME = OS.getHostName0();
    private static final String USER_NAME = System.getProperty("user.name");
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private static final boolean IS64BIT = OS.is64Bit0();
    private static final AtomicInteger PROCESS_ID = new AtomicInteger();
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_LINUX = OS_NAME.startsWith("linux");
    private static final boolean IS_MAC = OS_NAME.contains("mac");
    private static final boolean IS_WIN = OS_NAME.startsWith("win");
    private static final boolean IS_WIN10 = OS_NAME.equals("windows 10");
    private static final AtomicLong memoryMapped = new AtomicLong();
    private static final MethodHandle UNMAPP0_MH;
    private static final MethodHandle READ0_MH;
    private static final MethodHandle WRITE0_MH;
    private static final MethodHandle WRITE0_MH2;
    private static final String PROC_SELF = "/proc/self";
    private static final String PROC_SYS_KERNEL_PID_MAX = "/proc/sys/kernel/pid_max";
    private static int pageSize;
    private static int mapAlignment;

    private OS() {
    }

    @NotNull
    private static String findTarget() {
        String target = System.getProperty("project.build.directory");
        if (target != null) {
            return target;
        }
        for (File dir = new File(System.getProperty("user.dir")); dir != null; dir = dir.getParentFile()) {
            @NotNull File mavenTarget = new File(dir, "target");
            if (mavenTarget.exists()) {
                return mavenTarget.getAbsolutePath();
            }
            @NotNull File gradleTarget = new File(dir, "build");
            if (!gradleTarget.exists()) continue;
            return gradleTarget.getAbsolutePath();
        }
        return TMP + "/target";
    }

    @NotNull
    public static String findDir(@NotNull String suffix) throws FileNotFoundException {
        for (String s : System.getProperty("java.class.path").split(":")) {
            if (!s.endsWith(suffix) || !new File(s).isDirectory()) continue;
            return s;
        }
        throw new FileNotFoundException(suffix);
    }

    @NotNull
    public static File findFile(String ... path) {
        @NotNull File dir = new File(".").getAbsoluteFile();
        for (int i = 0; i < path.length - 1; ++i) {
            @NotNull File dir2 = new File(dir, path[i]);
            if (!dir2.isDirectory()) continue;
            dir = dir2;
        }
        return new File(dir, path[path.length - 1]);
    }

    public static String getHostName() {
        return HOST_NAME;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getTarget() {
        return TARGET;
    }

    private static String getHostName0() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    @NotNull
    public static Memory memory() {
        return UnsafeMemory.INSTANCE;
    }

    public static long pageAlign(long size) {
        long mask = (long)OS.pageSize() - 1L;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int pageSize() {
        if (pageSize == 0) {
            pageSize = OS.memory().pageSize();
        }
        return pageSize;
    }

    public static long mapAlign(long offset) {
        int chunkMultiple = (int)OS.mapAlignment();
        return (offset + (long)chunkMultiple - 1L) / (long)chunkMultiple * (long)chunkMultiple;
    }

    public static long mapAlignment() {
        if (mapAlignment == 0) {
            mapAlignment = OS.isWindows() ? 65536 : OS.pageSize();
        }
        return mapAlignment;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        int id = PROCESS_ID.get();
        if (id == 0) {
            id = OS.getProcessId0();
            PROCESS_ID.set(id);
        }
        return id;
    }

    private static int getProcessId0() {
        @Nullable String pid = null;
        @NotNull File self = new File(PROC_SELF);
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid != null) {
            try {
                return Integer.parseInt(pid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int minPid = 2;
        int rpid = 2 + new SecureRandom().nextInt(65534);
        Jvm.warn().on(OS.class, "Unable to determine PID, picked a random number=" + rpid);
        return rpid;
    }

    public static boolean isWindows() {
        return IS_WIN;
    }

    public static boolean isMacOSX() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getPidMax() {
        if (OS.isLinux()) {
            @NotNull File file = new File(PROC_SYS_KERNEL_PID_MAX);
            if (file.canRead()) {
                try (Scanner scanner = new Scanner(file);){
                    long l = Maths.nextPower2(scanner.nextLong(), 1L);
                    return l;
                }
                catch (FileNotFoundException e) {
                    Jvm.debug().on(OS.class, e);
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
            }
        } else if (OS.isMacOSX()) {
            return 0x1000000L;
        }
        if (!IS_WIN10) return 65536L;
        return 0x100000000L;
    }

    public static long map(@NotNull FileChannel fileChannel, FileChannel.MapMode mode, long start, long size) throws IOException, IllegalArgumentException {
        if (OS.isWindows() && size > 0x100000000L) {
            throw new IllegalArgumentException("Mapping more than 4096 MiB is unusable on Windows, size = " + (size >> 20) + " MiB");
        }
        long address = OS.map0(fileChannel, OS.imodeFor(mode), OS.mapAlign(start), OS.pageAlign(size));
        long threshold = Math.min(64L * size, 0x200000000000L);
        if (OS.isLinux() && address > 0L && address < threshold && Jvm.is64bit()) {
            double ratio = (double)threshold / (double)address;
            long durationMs = Math.max(5000L, (long)(250.0 * ratio * ratio * ratio));
            System.err.println("Running low on virtual memory, pausing " + durationMs + " ms, address: " + Long.toUnsignedString(address, 16));
            Jvm.pause(durationMs);
        }
        return address;
    }

    private static long invokeFileChannelMap0(@NotNull MethodHandle map0, @NotNull FileChannel fileChannel, int imode, long start, long size, @NotNull ThrowingFunction<OutOfMemoryError, Long, IOException> errorHandler) throws IOException {
        try {
            if (Jvm.isJava14Plus()) {
                return map0.invokeExact((FileChannelImpl)fileChannel, imode, start, size, false);
            }
            return map0.invokeExact((FileChannelImpl)fileChannel, imode, start, size);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Method map0 is not accessible", e);
        }
        catch (OutOfMemoryError oom) {
            return errorHandler.apply(oom);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    static long map0(@NotNull FileChannel fileChannel, int imode, long start, long size) throws IOException {
        MethodHandle map0 = (MethodHandle)MAP0_MH.get(fileChannel.getClass());
        long address = OS.invokeFileChannelMap0(map0, fileChannel, imode, start, size, oome1 -> {
            System.gc();
            Jvm.pause(100L);
            return OS.invokeFileChannelMap0(map0, fileChannel, imode, start, size, oome2 -> {
                throw new IOException("Map failed", (Throwable)oome2);
            });
        });
        memoryMapped.addAndGet(size);
        return address;
    }

    public static void unmap(long address, long size) throws IOException {
        try {
            long size2 = OS.pageAlign(size);
            int n = UNMAPP0_MH.invokeExact(address, size2);
            memoryMapped.addAndGet(-size2);
        }
        catch (Throwable e) {
            throw OS.asAnIOException(e);
        }
    }

    public static long memoryMapped() {
        return memoryMapped.get();
    }

    @NotNull
    private static IOException asAnIOException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (FileChannel.MapMode.READ_ONLY.equals(mode)) {
            imode = 0;
        } else if (FileChannel.MapMode.READ_WRITE.equals(mode)) {
            imode = 1;
        } else if (FileChannel.MapMode.PRIVATE.equals(mode)) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    public static long spaceUsed(@NotNull String filename) {
        return OS.spaceUsed(new File(filename));
    }

    private static long spaceUsed(@NotNull File file) {
        if (!OS.isWindows()) {
            try {
                String du = OS.run("du", "-ks", file.getAbsolutePath());
                return Long.parseLong(du.substring(0, du.indexOf(9)));
            }
            catch (IOException | NumberFormatException e) {
                Jvm.warn().on(OS.class, e);
            }
        }
        return file.length();
    }

    private static String run(String ... cmds) throws IOException {
        @NotNull ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        @NotNull StringWriter sw = new StringWriter();
        @NotNull char[] chars = new char[1024];
        try (@NotNull InputStreamReader r = new InputStreamReader(process.getInputStream());){
            int len;
            while ((len = r.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        return sw.toString();
    }

    public static String userDir() {
        return USER_DIR;
    }

    public static int read0(FileDescriptor fd, long address, int len) throws IOException {
        try {
            return READ0_MH.invokeExact(fd, address, len);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static int write0(FileDescriptor fd, long address, int len) throws IOException {
        try {
            if (WRITE0_MH2 == null) {
                return WRITE0_MH.invokeExact(fd, address, len);
            }
            return WRITE0_MH2.invokeExact(fd, address, len, false);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    static {
        Jvm.debug();
        try {
            Method unmap0 = Jvm.getMethod(FileChannelImpl.class, "unmap0", Long.TYPE, Long.TYPE);
            UNMAPP0_MH = MethodHandles.lookup().unreflect(unmap0);
            Class<?> fdi = Class.forName("sun.nio.ch.FileDispatcherImpl");
            Method read0 = Jvm.getMethod(fdi, "read0", FileDescriptor.class, Long.TYPE, Integer.TYPE);
            READ0_MH = MethodHandles.lookup().unreflect(read0);
            WriteZero wz = new WriteZero(fdi);
            WRITE0_MH = wz.write0Mh;
            WRITE0_MH2 = wz.write0Mh2;
            TIME_LIMIT.setStackTrace(new StackTraceElement[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class Unmapper
    implements Runnable {
        private final long size;
        private volatile long address;

        public Unmapper(long address, long size) throws IllegalStateException {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                OS.unmap(this.address, this.size);
                this.address = 0L;
            }
            catch (IOException e) {
                Jvm.warn().on(OS.class, "Error on unmap and release", e);
            }
        }
    }

    private static final class WriteZero {
        private MethodHandle write0Mh = null;
        private MethodHandle write0Mh2 = null;

        public WriteZero(Class<?> fdi) throws IllegalAccessException {
            try {
                Method write0 = Jvm.getMethod(fdi, "write0", FileDescriptor.class, Long.TYPE, Integer.TYPE);
                this.write0Mh = MethodHandles.lookup().unreflect(write0);
            }
            catch (AssertionError ae) {
                Method write0 = Jvm.getMethod(fdi, "write0", FileDescriptor.class, Long.TYPE, Integer.TYPE, Boolean.TYPE);
                this.write0Mh2 = MethodHandles.lookup().unreflect(write0);
            }
        }
    }
}

