/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import org.jetbrains.annotations.NotNull;

public class TableStoreWriteLock
extends AbstractTSQueueLock
implements WriteLock {
    public static final String APPEND_LOCK_KEY = "chronicle.append.lock";
    private static final String LOCK_KEY = "chronicle.write.lock";
    private final long timeout;
    private Thread lockedByThread = null;
    private StackTrace lockedHere;

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs, String lockKey) {
        super(lockKey, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs) {
        super(LOCK_KEY, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        this.throwExceptionIfClosed();
        assert (this.checkNotAlreadyLocked());
        long value = 0L;
        TimingPauser tlPauser = (TimingPauser)this.pauser.get();
        try {
            value = this.lock.getVolatileValue();
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedRuntimeException("Interrupted for the lock file:" + this.path);
                }
                tlPauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                value = this.lock.getVolatileValue();
            }
            assert ((this.lockedByThread = Thread.currentThread()) != null && (this.lockedHere = new StackTrace()) != null);
        }
        catch (TimeoutException e) {
            String lockedBy = this.getLockedBy(value);
            String warningMsg = "Couldn't acquire write lock after " + this.timeout + " ms for the lock file:" + this.path + ". Lock was held by " + lockedBy;
            if (this.dontRecoverLockTimeout) {
                throw new UnrecoverableTimeoutException((Exception)new IllegalStateException(warningMsg + ". You can manually unlock with net.openhft.chronicle.queue.main.UnlockMain"));
            }
            Jvm.warn().on(this.getClass(), warningMsg + ". Unlocking forcibly");
            this.forceUnlock(value);
            tlPauser.reset();
            this.lock();
        }
        finally {
            tlPauser.reset();
        }
    }

    @NotNull
    protected String getLockedBy(long value) {
        return value == Long.MIN_VALUE ? "unknown" : (value == PID ? "me" : Long.toString((int)value));
    }

    private boolean checkNotAlreadyLocked() {
        if (!this.locked()) {
            return true;
        }
        if (this.lockedByThread == null) {
            return true;
        }
        if (this.lockedByThread == Thread.currentThread()) {
            throw new AssertionError("Lock is already acquired by current thread and is not reentrant - nested document context?", (Throwable)this.lockedHere);
        }
        return true;
    }

    @Override
    public void unlock() {
        this.throwExceptionIfClosed();
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            long value = this.lock.getVolatileValue();
            if (value == Long.MIN_VALUE) {
                Jvm.warn().on(this.getClass(), "Write lock was already unlocked. For the lock file:" + this.path);
            } else {
                Jvm.warn().on(this.getClass(), "Write lock was locked by someone else! For the lock file:" + this.path + " by PID: " + this.getLockedBy(value));
            }
        }
        this.lockedByThread = null;
        this.lockedHere = null;
    }

    @Override
    public boolean locked() {
        this.throwExceptionIfClosed();
        return this.lock.getVolatileValue(Long.MIN_VALUE) != Long.MIN_VALUE;
    }

    public void forceUnlock() {
        this.throwExceptionIfClosed();
        if (this.locked()) {
            this.forceUnlock(this.lockedBy());
        }
    }

    public void forceUnlockQuietly() {
        this.lock.setValue(Long.MIN_VALUE);
    }
}

