/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class MultipleNamedTailersTest {
    @Test
    public void multipleTailers() {
        File tmpDir = new File(OS.getTarget(), "multipleTailers" + System.nanoTime());
        try (SingleChronicleQueue q1 = SingleChronicleQueueBuilder.single((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
             ExcerptAppender appender = q1.acquireAppender();
             ExcerptTailer tailer1 = q1.createTailer();
             ExcerptTailer namedTailer1 = q1.createTailer("named1");
             SingleChronicleQueue q2 = SingleChronicleQueueBuilder.single((File)tmpDir).testBlockSize().build();
             ExcerptTailer tailer2 = q2.createTailer();
             ExcerptTailer namedTailer2 = q2.createTailer("named2");){
            for (int i = 0; i < 1000000; ++i) {
                String id0 = "" + i;
                appender.writeText((CharSequence)id0);
                long index0 = appender.lastIndexAppended();
                this.check(tailer1, id0, index0);
                this.check(namedTailer1, id0, index0);
                this.check(tailer2, id0, index0);
                this.check(namedTailer2, id0, index0);
            }
        }
    }

    private void check(ExcerptTailer tailer1, String id0, long index0) {
        try (DocumentContext dc = tailer1.readingDocument();){
            Assert.assertTrue((boolean)dc.isPresent());
            Assert.assertEquals((long)index0, (long)tailer1.index());
            Assert.assertEquals((Object)id0, (Object)dc.wire().getValueIn().text());
        }
    }
}

