/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.examples;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.wire.Base64LongConverter;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;

public class WireExamples2 {
    public static void main(String ... args) {
        ClassAliasPool.CLASS_ALIASES.addAlias(TextObject.class);
        BinaryWire wire = new BinaryWire(Bytes.allocateElasticOnHeap());
        wire.getValueOut().object(new TextObject("SAMPLETEXT"));
        System.out.println("encoded to=" + wire.bytes().toHexString());
        System.out.println("deserialized=" + wire.getValueIn().object());
    }

    public static class TextObject
    extends SelfDescribingMarshallable {
        transient StringBuilder temp = new StringBuilder();
        @LongConversion(value=Base64LongConverter.class)
        private long text;

        public TextObject(CharSequence text) {
            this.text = Base64LongConverter.INSTANCE.parse(text);
        }

        public CharSequence text() {
            Base64LongConverter.INSTANCE.append(this.temp, this.text);
            return this.temp;
        }
    }
}

