/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedBytesStoreFactory;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.internal.ChunkedMappedBytes;
import net.openhft.chronicle.core.CleaningRandomAccessFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.jetbrains.annotations.NotNull;

public class ChunkedMappedFile
extends MappedFile {
    static final boolean RETAIN = Jvm.getBoolean("mappedFile.retain");
    @NotNull
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkSize;
    private final long overlapSize;
    private final List<MappedBytesStore> stores = new ArrayList<MappedBytesStore>();
    private final long capacity;
    private long[] chunkCount = new long[]{0L};

    public ChunkedMappedFile(@NotNull File file, @NotNull RandomAccessFile raf, long chunkSize, long overlapSize, long capacity, boolean readOnly) throws IORuntimeException {
        super(file, readOnly);
        this.raf = raf;
        this.fileChannel = raf.getChannel();
        this.chunkSize = OS.mapAlign(chunkSize);
        this.overlapSize = overlapSize > 0L && overlapSize < 65536L ? chunkSize : OS.mapAlign(overlapSize);
        this.capacity = capacity;
        Jvm.doNotCloseOnInterrupt(this.getClass(), this.fileChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmup() {
        ArrayList<IOException> errorsDuringWarmup = new ArrayList<IOException>();
        try {
            Jvm.setExceptionHandlers(Slf4jExceptionHandler.ERROR, null, null);
            Path path = Files.createTempDirectory("warmup", new FileAttribute[0]);
            File file = File.createTempFile("delete_warming_up", "me", path.toFile());
            file.deleteOnExit();
            long mapAlignment = OS.mapAlignment();
            int chunks = 64;
            int compileThreshold = Jvm.compileThreshold();
            for (int j = 0; j <= compileThreshold; j += 64) {
                try {
                    try (@NotNull CleaningRandomAccessFile raf = new CleaningRandomAccessFile(file, "rw");
                         ChunkedMappedFile mappedFile = new ChunkedMappedFile(file, raf, mapAlignment, 0L, mapAlignment * 64L, false);){
                        ChunkedMappedFile.warmup0(mapAlignment, 64, mappedFile);
                    }
                    Thread.yield();
                    continue;
                }
                catch (IOException e) {
                    errorsDuringWarmup.add(e);
                }
            }
            Thread.yield();
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            Jvm.resetExceptionHandlers();
            Jvm.warn().on(ChunkedMappedFile.class, "Error during warmup", e);
        }
        finally {
            Jvm.resetExceptionHandlers();
            if (!errorsDuringWarmup.isEmpty()) {
                Jvm.warn().on(ChunkedMappedFile.class, errorsDuringWarmup.size() + " errors during warmup: " + errorsDuringWarmup);
            }
        }
    }

    private static void warmup0(long mapAlignment, int chunks, @NotNull ChunkedMappedFile mappedFile) {
        try {
            ReferenceOwner warmup = ReferenceOwner.temporary("warmup");
            for (int i = 0; i < chunks; ++i) {
                mappedFile.acquireBytesForRead(warmup, (long)i * mapAlignment).release(warmup);
                mappedFile.acquireBytesForWrite(warmup, (long)i * mapAlignment).release(warmup);
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MappedBytesStore acquireByteStore(ReferenceOwner owner, long position, BytesStore oldByteStore, @NotNull MappedBytesStoreFactory mappedBytesStoreFactory) throws IOException, IllegalArgumentException, IllegalStateException {
        MappedBytesStore mbs;
        this.throwExceptionIfClosed();
        if (position < 0L) {
            throw new IOException("Attempt to access a negative position: " + position);
        }
        int chunk = (int)(position / this.chunkSize);
        List<MappedBytesStore> list = this.stores;
        synchronized (list) {
            while (this.stores.size() <= chunk) {
                this.stores.add(null);
            }
            mbs = this.stores.get(chunk);
        }
        if (mbs != null) {
            if (mbs == oldByteStore) {
                return mbs;
            }
            if (mbs.tryReserve(owner)) {
                return mbs;
            }
        }
        this.resizeRafIfTooSmall(chunk);
        list = this.stores;
        synchronized (list) {
            MappedBytesStore mbs1 = this.stores.get(chunk);
            if (mbs1 != null && mbs1.tryReserve(owner)) {
                return mbs1;
            }
            long mappedSize = this.chunkSize + this.overlapSize;
            FileChannel.MapMode mode = this.readOnly() ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            long startOfMap = (long)chunk * this.chunkSize;
            long beginNs = System.nanoTime();
            this.throwExceptionIfClosed();
            long address = OS.map(this.fileChannel, mode, startOfMap, mappedSize);
            MappedBytesStore mbs2 = mappedBytesStoreFactory.create(owner, this, (long)chunk * this.chunkSize, address, mappedSize, this.chunkSize);
            if (RETAIN) {
                mbs2.reserve(this);
            }
            this.stores.set(chunk, mbs2);
            long elapsedNs = System.nanoTime() - beginNs;
            if (this.newChunkListener != null) {
                this.newChunkListener.onNewChunk(this.file().getPath(), chunk, elapsedNs / 1000L);
            }
            this.chunkCount[0] = this.chunkCount[0] + 1L;
            if (elapsedNs >= 2000000L) {
                Jvm.perf().on(this.getClass(), "Took " + elapsedNs / 1000000L + " ms to add mapping for " + this.file());
            }
            return mbs2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeRafIfTooSmall(int chunk) throws IOException {
        Jvm.safepoint();
        long minSize = ((long)chunk + 1L) * this.chunkSize + this.overlapSize;
        long size = this.fileChannel.size();
        Jvm.safepoint();
        if (size >= minSize || this.readOnly()) {
            return;
        }
        try {
            String string = this.internalizedToken();
            synchronized (string) {
                size = this.fileChannel.size();
                if (size < minSize) {
                    long beginNs = System.nanoTime();
                    try (FileLock ignore = this.fileChannel.lock();){
                        size = this.fileChannel.size();
                        if (size < minSize) {
                            Jvm.safepoint();
                            this.raf.setLength(minSize);
                            Jvm.safepoint();
                        }
                    }
                    long elapsedNs = System.nanoTime() - beginNs;
                    if (elapsedNs >= 1000000L) {
                        Jvm.perf().on(this.getClass(), "Took " + elapsedNs / 1000L + " us to grow file " + this.file());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("Failed to resize to " + minSize, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRelease() {
        try {
            List<MappedBytesStore> list = this.stores;
            synchronized (list) {
                for (int i = 0; i < this.stores.size(); ++i) {
                    MappedBytesStore mbs = this.stores.get(i);
                    if (mbs != null && RETAIN) {
                        try {
                            mbs.release(this);
                        }
                        catch (IllegalStateException e) {
                            Jvm.debug().on(this.getClass(), e);
                        }
                    }
                    this.stores.set(i, null);
                }
            }
        }
        finally {
            Closeable.closeQuietly((Object)this.raf);
            this.setClosed();
        }
    }

    @Override
    @NotNull
    public String referenceCounts() {
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        for (MappedBytesStore mbs : this.stores) {
            long count = 0L;
            if (mbs != null) {
                count = mbs.refCount();
            }
            sb.append(", ").append(count);
        }
        return sb.toString();
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long chunkSize() {
        return this.chunkSize;
    }

    @Override
    public long overlapSize() {
        return this.overlapSize;
    }

    @Override
    public NewChunkListener getNewChunkListener() {
        return this.newChunkListener;
    }

    @Override
    public void setNewChunkListener(NewChunkListener listener) {
        this.newChunkListener = listener;
    }

    @Override
    public long actualSize() throws IORuntimeException, IllegalStateException {
        boolean interrupted = Thread.interrupted();
        try {
            long l = this.fileChannelSize();
            return l;
        }
        catch (ArrayIndexOutOfBoundsException aiooe) {
            long l = this.actualSize();
            return l;
        }
        catch (ClosedByInterruptException cbie) {
            this.close();
            interrupted = true;
            throw new IllegalStateException(cbie);
        }
        catch (IOException e) {
            boolean open = this.fileChannel.isOpen();
            if (open) {
                throw new IORuntimeException(e);
            }
            this.close();
            throw new IllegalStateException(e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private long fileChannelSize() throws IOException, ArrayIndexOutOfBoundsException {
        return this.fileChannel.size();
    }

    @Override
    @NotNull
    public RandomAccessFile raf() {
        return this.raf;
    }

    @Override
    protected void finalize() throws Throwable {
        this.warnAndReleaseIfNotReleased();
        super.finalize();
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.fileChannel.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.fileChannel.tryLock(position, size, shared);
    }

    @Override
    public long chunkCount() {
        return this.chunkCount[0];
    }

    @Override
    public void chunkCount(long[] chunkCount) {
        this.chunkCount = chunkCount;
    }

    @Override
    public MappedBytes createBytesFor() {
        return new ChunkedMappedBytes(this);
    }
}

