/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.PretoucherTest;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherDontWriteTest
extends ChronicleQueueTestBase {
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private final List<Integer> capturedCycles = new ArrayList<Integer>();
    private final PretoucherTest.CapturingChunkListener chunkListener = new PretoucherTest.CapturingChunkListener();

    @Test
    public void dontWrite() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             SingleChronicleQueue pretoucherQueue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(pretoucherQueue, (NewChunkListener)this.chunkListener, this.capturedCycles::add, false, false);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertEquals((double)((double)i + 0.5), (double)this.capturedCycles.size(), (double)0.5);
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((long)(i + 1), (long)this.capturedCycles.size());
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(5L));
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                Assert.assertEquals((double)((double)i + 1.5), (double)this.capturedCycles.size(), (double)0.5);
            });
            Assert.assertEquals((double)10.5, (double)this.capturedCycles.size(), (double)0.5);
        }
    }
}

