/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class Base64LongConverter
implements LongConverter {
    public static final int MAX_LENGTH = LongConverter.maxParseLength(64);
    public static final Base64LongConverter INSTANCE = new Base64LongConverter();
    static final char[] CODES = ".ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+".toCharArray();
    static final byte[] LOOKUP = new byte[128];

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            byte b = LOOKUP[text.charAt(i)];
            if (b < 0) continue;
            v = (v << 6) + (long)(b & 0xFF);
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        while (value != 0L) {
            text.append(CODES[(int)(value & 0x3FL)]);
            value >>>= 6;
        }
        StringUtils.reverse(text, start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }

    static {
        Arrays.fill(LOOKUP, (byte)-1);
        for (int i = 0; i < CODES.length; ++i) {
            char code = CODES[i];
            Base64LongConverter.LOOKUP[code] = (byte)i;
        }
    }
}

