/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.IntConsumer;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.Wire;

public final class Pretoucher
extends AbstractCloseable {
    static final long PRETOUCHER_PREROLL_TIME_DEFAULT_MS = 2000L;
    private static final long PRETOUCHER_PREROLL_TIME_MS = Long.getLong("SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs", 2000L);
    private static final boolean EARLY_ACQUIRE_NEXT_CYCLE = Jvm.getBoolean("SingleChronicleQueueExcerpts.earlyAcquireNextCycle", false);
    private static final boolean CAN_WRITE = !Jvm.getBoolean("SingleChronicleQueueExcerpts.dontWrite");
    private final SingleChronicleQueue queue;
    private final NewChunkListener chunkListener;
    private final IntConsumer cycleChangedListener;
    private final boolean earlyAcquireNextCycle;
    private final boolean canWrite;
    private final PretoucherState pretoucherState;
    private final TimeProvider pretouchTimeProvider;
    private int currentCycle = Integer.MIN_VALUE;
    private SingleChronicleQueueStore currentCycleWireStore;
    private MappedBytes currentCycleMappedBytes;

    public Pretoucher(SingleChronicleQueue queue) {
        this(queue, null, c -> {}, EARLY_ACQUIRE_NEXT_CYCLE, CAN_WRITE);
    }

    public Pretoucher(SingleChronicleQueue queue, NewChunkListener chunkListener, IntConsumer cycleChangedListener, boolean earlyAcquireNextCycle, boolean canWrite) {
        this.queue = queue;
        this.chunkListener = chunkListener;
        this.cycleChangedListener = cycleChangedListener;
        this.earlyAcquireNextCycle = earlyAcquireNextCycle;
        this.canWrite = canWrite;
        queue.addCloseListener(this);
        this.pretoucherState = new PretoucherState(this::getStoreWritePosition);
        this.pretouchTimeProvider = () -> queue.time().currentTimeMillis() + (EARLY_ACQUIRE_NEXT_CYCLE ? PRETOUCHER_PREROLL_TIME_MS : 0L);
    }

    public void execute() throws InvalidEventHandlerException {
        if (this.isClosed()) {
            throw new InvalidEventHandlerException();
        }
        this.throwExceptionIfClosed();
        try {
            this.assignCurrentCycle();
            if (this.currentCycleMappedBytes != null) {
                this.pretoucherState.pretouch(this.currentCycleMappedBytes);
            }
        }
        catch (IllegalStateException e) {
            if (this.queue.isClosed()) {
                throw new InvalidEventHandlerException(e);
            }
            Jvm.warn().on(this.getClass(), e);
        }
    }

    public void shutdown() {
        this.throwExceptionIfClosed();
        this.queue.close();
    }

    private void assignCurrentCycle() {
        int qCycle = this.queue.cycle(this.pretouchTimeProvider);
        if (qCycle != this.currentCycle) {
            this.releaseResources();
            if (this.canWrite) {
                this.queue.writeLock().lock();
            }
            try {
                if (!this.earlyAcquireNextCycle && this.currentCycleWireStore != null && this.canWrite) {
                    try {
                        Wire wire = (Wire)this.queue.wireType().apply(this.currentCycleMappedBytes);
                        wire.usePadding(this.currentCycleWireStore.dataVersion() > 0);
                        this.currentCycleWireStore.writeEOF(wire, this.queue.timeoutMS);
                    }
                    catch (Exception ex) {
                        Jvm.warn().on(this.getClass(), "unable to write the EOF file=" + this.currentCycleMappedBytes.mappedFile().file(), ex);
                    }
                }
                SingleChronicleQueueStore oldStore = this.currentCycleWireStore;
                this.currentCycleWireStore = this.queue.storeForCycle(qCycle, this.queue.epoch(), this.earlyAcquireNextCycle || this.canWrite, this.currentCycleWireStore);
                if (oldStore != null && oldStore != this.currentCycleWireStore) {
                    oldStore.close();
                }
            }
            finally {
                if (this.canWrite) {
                    this.queue.writeLock().unlock();
                }
            }
            if (this.currentCycleWireStore != null) {
                this.currentCycleMappedBytes = this.currentCycleWireStore.bytes();
                this.currentCycle = qCycle;
                if (this.chunkListener != null) {
                    this.currentCycleMappedBytes.setNewChunkListener(this.chunkListener);
                }
                this.cycleChangedListener.accept(qCycle);
                if (this.earlyAcquireNextCycle && Jvm.isDebugEnabled(this.getClass())) {
                    Jvm.debug().on(this.getClass(), "Pretoucher ROLLING early to next file=" + this.currentCycleWireStore.file());
                }
            }
        }
    }

    private long getStoreWritePosition() {
        return this.currentCycleWireStore.writePosition();
    }

    private void releaseResources() {
        if (this.currentCycleWireStore != null) {
            this.queue.closeStore(this.currentCycleWireStore);
            this.currentCycleWireStore = null;
        }
        if (this.currentCycleMappedBytes != null) {
            this.currentCycleMappedBytes.close();
            this.currentCycleMappedBytes = null;
        }
    }

    @Override
    protected void performClose() {
        this.releaseResources();
    }
}

