/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.cleanup;

import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.FlakyTestRunner;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Test;

public class OnReleaseTest
extends QueueTestCommon {
    @Test
    public void onRelease() {
        FlakyTestRunner.run(this::onRelease0);
    }

    public void onRelease0() {
        String path = OS.getTarget() + "/onRelease-" + Time.uniqueId();
        SetTimeProvider stp = new SetTimeProvider();
        AtomicInteger writeRoll = new AtomicInteger();
        AtomicInteger readRoll = new AtomicInteger();
        try (SingleChronicleQueue writeQ = SingleChronicleQueueBuilder.binary((String)path).rollCycle((RollCycle)RollCycles.MINUTELY).timeProvider((TimeProvider)stp).storeFileListener((c, f) -> {
            System.out.println("write released " + f);
            writeRoll.incrementAndGet();
        }).build();
             SingleChronicleQueue readQ = SingleChronicleQueueBuilder.binary((String)path).rollCycle((RollCycle)RollCycles.MINUTELY).timeProvider((TimeProvider)stp).storeFileListener((c, f) -> {
            System.out.println("read released " + f);
            readRoll.incrementAndGet();
        }).build();){
            ExcerptAppender appender = writeQ.acquireAppender();
            ExcerptTailer tailer = readQ.createTailer();
            for (int i = 0; i < 500; ++i) {
                appender.writeText((CharSequence)("hello-" + i));
                Assert.assertNotNull((Object)tailer.readText());
                BackgroundResourceReleaser.releasePendingResources();
                Assert.assertEquals((long)i, (long)writeRoll.get());
                Assert.assertEquals((long)i, (long)readRoll.get());
                stp.advanceMillis(66000L);
            }
        }
    }
}

