/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.EnumCache;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DynamicEnum;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SerializationStrategies implements SerializationStrategy
{
    MARSHALLABLE{

        @NotNull
        public Object readUsing(Class clazz, @NotNull Object o, @NotNull ValueIn in, BracketType bracketType) {
            WireIn wireIn = in.wireIn();
            if (wireIn.useSelfDescribingMessage((CommonMarshallable)o) && o instanceof ReadMarshallable) {
                ((ReadMarshallable)o).readMarshallable(wireIn);
            } else {
                ((ReadBytesMarshallable)o).readMarshallable(wireIn.bytes());
            }
            return o;
        }

        @NotNull
        public Class type() {
            return Marshallable.class;
        }

        @Override
        @Nullable
        public Object newInstanceOrNull(@NotNull Class type) {
            return type.isInterface() || Modifier.isAbstract(type.getModifiers()) ? null : super.newInstanceOrNull(type);
        }
    }
    ,
    ANY_OBJECT{

        @Nullable
        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            return in.objectWithInferredType(o, ANY_NESTED, null);
        }

        @NotNull
        public Class type() {
            return Object.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.UNKNOWN;
        }
    }
    ,
    ANY_SCALAR{

        @Nullable
        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            return in.objectWithInferredType(o, ANY_NESTED, null);
        }

        @NotNull
        public Class type() {
            return Object.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.NONE;
        }
    }
    ,
    ENUM{

        @Nullable
        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            return in.text();
        }

        @NotNull
        public Class type() {
            return Enum.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.NONE;
        }
    }
    ,
    DYNAMIC_ENUM{
        private Field ordinal = Jvm.getField(Enum.class, "ordinal");

        @Nullable
        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            if (bracketType != BracketType.MAP || !(o instanceof ReadMarshallable)) {
                String text = in.text();
                if (o != null) {
                    EnumCache<?> cache = EnumCache.of(o.getClass());
                    Object ret = cache.valueOf(text);
                    if (ret == null) {
                        throw new IORuntimeException("No enum value '" + text + "' defined for " + o.getClass());
                    }
                    return ret;
                }
                return text;
            }
            ((ReadMarshallable)o).readMarshallable(in.wireIn());
            return o;
        }

        @NotNull
        public Class type() {
            return Enum.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.UNKNOWN;
        }

        @Override
        public Object newInstanceOrNull(Class type) {
            try {
                DynamicEnum o = (DynamicEnum)UnsafeMemory.INSTANCE.allocateInstance(type);
                o.setField("name", "[unset]");
                if (o instanceof Enum) {
                    this.ordinal.set(o, -1);
                }
                return o;
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
    }
    ,
    ANY_NESTED{

        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            if (in.isNull()) {
                return null;
            }
            if (o == null) {
                throw new IllegalArgumentException("Unable to deserialize " + clazz);
            }
            Wires.readMarshallable(clazz, o, in.wireIn(), true);
            return o;
        }

        @NotNull
        public Class type() {
            return Object.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.UNKNOWN;
        }
    }
    ,
    DEMARSHALLABLE{

        @NotNull
        public Object readUsing(Class clazz, Object using, @NotNull ValueIn in, BracketType bracketType) {
            if (using instanceof DemarshallableWrapper) {
                @NotNull DemarshallableWrapper wrapper = (DemarshallableWrapper)using;
                wrapper.demarshallable = Demarshallable.newInstance(wrapper.type, in.wireIn());
                return wrapper;
            }
            if (using instanceof ReadMarshallable) {
                return in.object(using, Object.class);
            }
            return Demarshallable.newInstance(using.getClass(), in.wireIn());
        }

        @NotNull
        public Class type() {
            return Demarshallable.class;
        }

        @Override
        @NotNull
        public Object newInstanceOrNull(@NotNull Class type) {
            return new DemarshallableWrapper(type);
        }
    }
    ,
    SERIALIZABLE{

        public Object readUsing(Class clazz, Object o, ValueIn in, BracketType bracketType) {
            SerializationStrategies strategies = o instanceof Externalizable ? EXTERNALIZABLE : ANY_OBJECT;
            strategies.readUsing(clazz, o, in, bracketType);
            return o;
        }

        @NotNull
        public Class type() {
            return Serializable.class;
        }
    }
    ,
    EXTERNALIZABLE{

        @NotNull
        public Object readUsing(Class clazz, @NotNull Object o, @NotNull ValueIn in, BracketType bracketType) {
            try {
                ((Externalizable)o).readExternal(in.wireIn().objectInput());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IORuntimeException(e);
            }
            return o;
        }

        @NotNull
        public Class type() {
            return Externalizable.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    MAP{

        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            @NotNull Map<Object, Object> map = o == null ? new LinkedHashMap() : (Map)o;
            @NotNull WireIn wireIn = in.wireIn();
            long pos = wireIn.bytes().readPosition();
            while (in.hasNext()) {
                Object key = wireIn.readEvent(Object.class);
                map.put(key, in.object());
                long pos2 = wireIn.bytes().readPosition();
                if (pos2 <= pos && !Jvm.isDebug()) {
                    throw new IllegalStateException(wireIn.bytes().toDebugString());
                }
                pos = pos2;
            }
            return map;
        }

        @Override
        @NotNull
        public Object newInstanceOrNull(@Nullable Class type) {
            if (type == null) {
                return new LinkedHashMap();
            }
            return SortedMap.class.isAssignableFrom(type) ? new TreeMap() : new LinkedHashMap();
        }

        @NotNull
        public Class type() {
            return Map.class;
        }
    }
    ,
    SET{

        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            @NotNull Set<Object> set = o == null ? new LinkedHashSet() : (Set)o;
            @NotNull WireIn wireIn = in.wireIn();
            @NotNull Bytes<?> bytes = wireIn.bytes();
            long pos = bytes.readPosition();
            while (in.hasNextSequenceItem()) {
                @Nullable Object object = in.object();
                long pos2 = bytes.readPosition();
                if (pos2 <= pos && !Jvm.isDebug()) {
                    throw new IllegalStateException(bytes.toDebugString());
                }
                pos = pos2;
                set.add(object);
            }
            return set;
        }

        @Override
        @NotNull
        public Object newInstanceOrNull(@NotNull Class type) {
            return SortedSet.class.isAssignableFrom(type) ? new TreeSet() : new LinkedHashSet();
        }

        @NotNull
        public Class type() {
            return Set.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    LIST{

        public Object readUsing(Class clazz, Object o, @NotNull ValueIn in, BracketType bracketType) {
            @NotNull List<Object> list = o == null ? new ArrayList() : (List)o;
            @NotNull WireIn wireIn = in.wireIn();
            long pos = wireIn.bytes().readPosition();
            while (in.hasNextSequenceItem()) {
                list.add(in.object());
                long pos2 = wireIn.bytes().readPosition();
                if (pos2 <= pos && !Jvm.isDebug()) {
                    throw new IllegalStateException(wireIn.bytes().toDebugString());
                }
                pos = pos2;
            }
            return list;
        }

        @Override
        @NotNull
        public Object newInstanceOrNull(Class type) {
            return new ArrayList();
        }

        @NotNull
        public Class type() {
            return List.class;
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    ARRAY{

        @NotNull
        public Object readUsing(Class clazz, Object using, @NotNull ValueIn in, BracketType bracketType) {
            if (using instanceof ArrayWrapper) {
                @NotNull ArrayWrapper wrapper = (ArrayWrapper)using;
                Class<?> componentType = wrapper.type.getComponentType();
                @NotNull ArrayList<?> list = new ArrayList();
                while (in.hasNextSequenceItem()) {
                    list.add(in.object(componentType));
                }
                wrapper.array = list.toArray((Object[])Array.newInstance(componentType, list.size()));
                return wrapper;
            }
            @NotNull ArrayList<Object> list = new ArrayList<Object>();
            while (in.hasNextSequenceItem()) {
                list.add(in.object());
            }
            return list.toArray();
        }

        @NotNull
        public Class type() {
            return Object[].class;
        }

        @Override
        @NotNull
        public Object newInstanceOrNull(@NotNull Class type) {
            return new ArrayWrapper(type);
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    PRIM_ARRAY{

        @NotNull
        public Object readUsing(Class clazz, Object using, @NotNull ValueIn in, BracketType bracketType) {
            @NotNull PrimArrayWrapper wrapper = (PrimArrayWrapper)using;
            Class<?> componentType = wrapper.type.getComponentType();
            int i = 0;
            int len = 0;
            Object array = Array.newInstance(componentType, 0);
            while (in.hasNextSequenceItem()) {
                if (i >= len) {
                    int len2 = len * 2 + 2;
                    Object array2 = Array.newInstance(componentType, len2);
                    System.arraycopy(array, 0, array2, 0, len);
                    len = len2;
                    array = array2;
                }
                Array.set(array, i++, in.object(componentType));
            }
            if (i < len) {
                Object array2 = Array.newInstance(componentType, i);
                System.arraycopy(array, 0, array2, 0, i);
                array = array2;
            }
            wrapper.array = array;
            return wrapper;
        }

        @NotNull
        public Class type() {
            return Object.class;
        }

        @Override
        @NotNull
        public Object newInstanceOrNull(@NotNull Class type) {
            return new PrimArrayWrapper(type);
        }

        @Override
        @NotNull
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    };


    @Nullable
    public Object newInstanceOrNull(Class type) {
        return ObjectUtils.newInstanceOrNull(type);
    }

    @Override
    @NotNull
    public BracketType bracketType() {
        return BracketType.MAP;
    }

    static class DemarshallableWrapper
    implements ReadResolvable<Demarshallable> {
        @NotNull
        final Class type;
        Demarshallable demarshallable;

        DemarshallableWrapper(@NotNull Class type) {
            this.type = type;
        }

        @Override
        @NotNull
        public Demarshallable readResolve() {
            return this.demarshallable;
        }
    }

    static class PrimArrayWrapper
    implements ReadResolvable<Object> {
        @NotNull
        final Class type;
        Object array;

        PrimArrayWrapper(@NotNull Class type) {
            this.type = type;
        }

        @Override
        @NotNull
        public Object readResolve() {
            return this.array;
        }
    }

    static class ArrayWrapper
    implements ReadResolvable<Object[]> {
        @NotNull
        final Class type;
        Object[] array;

        ArrayWrapper(@NotNull Class type) {
            this.type = type;
        }

        @Override
        @NotNull
        public @NotNull Object @NotNull [] readResolve() {
            return this.array;
        }
    }
}

