/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.IntConsumer;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;

public final class Pretoucher
extends AbstractCloseable {
    static final long PRETOUCHER_PREROLL_TIME_DEFAULT_MS = 2000L;
    private final long PRETOUCHER_PREROLL_TIME_MS = Long.getLong("SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs", 2000L);
    private final SingleChronicleQueue queue;
    private final NewChunkListener chunkListener;
    private final IntConsumer cycleChangedListener;
    private final boolean earlyAcquireNextCycle;
    private final boolean canWrite;
    private final PretoucherState pretoucherState;
    private final TimeProvider pretouchTimeProvider;
    private int currentCycle = Integer.MIN_VALUE;
    private SingleChronicleQueueStore currentCycleWireStore;
    private MappedBytes currentCycleMappedBytes;

    public Pretoucher(SingleChronicleQueue queue) {
        this(queue, null, c -> {}, Jvm.getBoolean("SingleChronicleQueueExcerpts.earlyAcquireNextCycle", false), !Jvm.getBoolean("SingleChronicleQueueExcerpts.dontWrite"));
    }

    public Pretoucher(SingleChronicleQueue queue, NewChunkListener chunkListener, IntConsumer cycleChangedListener, boolean earlyAcquireNextCycle, boolean canWrite) {
        this.queue = queue;
        this.chunkListener = chunkListener;
        this.cycleChangedListener = cycleChangedListener;
        this.earlyAcquireNextCycle = this.checkEA(earlyAcquireNextCycle);
        this.canWrite = canWrite;
        this.pretoucherState = new PretoucherState(this::getStoreWritePosition);
        if (this.PRETOUCHER_PREROLL_TIME_MS != 2000L && !earlyAcquireNextCycle) {
            Jvm.warn().on(this.getClass(), "SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs has been set but not earlyAcquireNextCycle");
        }
        this.pretouchTimeProvider = () -> queue.time().currentTimeMillis() + (this.earlyAcquireNextCycle ? this.PRETOUCHER_PREROLL_TIME_MS : 0L);
        queue.addCloseListener(this);
    }

    private boolean checkEA(boolean ea) {
        if (ea) {
            Jvm.warn().on(this.getClass(), "SingleChronicleQueueExcerpts.earlyAcquireNextCycle is not supported");
        }
        return false;
    }

    public void execute() throws InvalidEventHandlerException {
        try {
            this.throwExceptionIfClosed();
        }
        catch (ClosedIllegalStateException e) {
            throw new InvalidEventHandlerException(e);
        }
        try {
            this.assignCurrentCycle();
            if (this.currentCycleMappedBytes != null) {
                this.pretoucherState.pretouch(this.currentCycleMappedBytes);
            }
        }
        catch (ClassCastException cce) {
            Jvm.warn().on(this.getClass(), cce);
        }
        catch (IllegalStateException e) {
            if (this.queue.isClosed()) {
                throw new InvalidEventHandlerException(e);
            }
            Jvm.warn().on(this.getClass(), e);
        }
    }

    public void shutdown() {
        this.throwExceptionIfClosed();
        this.queue.close();
    }

    private void assignCurrentCycle() {
        int qCycle = this.queue.cycle(this.pretouchTimeProvider);
        if (qCycle != this.currentCycle) {
            this.releaseResources();
            this.currentCycleWireStore = this.queue.storeForCycle(qCycle, this.queue.epoch(), this.earlyAcquireNextCycle || this.canWrite, this.currentCycleWireStore);
            if (this.currentCycleWireStore != null) {
                this.currentCycleMappedBytes = this.currentCycleWireStore.bytes();
                this.currentCycle = qCycle;
                if (this.chunkListener != null) {
                    this.currentCycleMappedBytes.mappedFile().setNewChunkListener(this.chunkListener);
                }
                this.cycleChangedListener.accept(qCycle);
                if (this.earlyAcquireNextCycle) {
                    Jvm.perf().on(this.getClass(), "Pretoucher ROLLING early to next file=" + this.currentCycleWireStore.file());
                }
            }
        }
    }

    private long getStoreWritePosition() {
        return this.currentCycleWireStore.writePosition();
    }

    private void releaseResources() {
        if (this.currentCycleWireStore != null) {
            this.queue.closeStore(this.currentCycleWireStore);
            this.currentCycleWireStore = null;
        }
        if (this.currentCycleMappedBytes != null) {
            this.currentCycleMappedBytes.close();
            this.currentCycleMappedBytes = null;
        }
    }

    @Override
    protected void performClose() {
        this.releaseResources();
    }
}

