/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.jitter;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueReadJitterMain {
    public static final String PROFILE_OF_THE_THREAD = "profile of the thread";
    static int runTime = Integer.getInteger("runTime", 600);
    static int size = Integer.getInteger("size", 128);
    static int sampleTime = Integer.getInteger("sampleTime", 30);
    static volatile boolean running = true;

    public static void main(String[] args) {
        new QueueReadJitterMain().run();
    }

    protected void run() {
        MappedFile.warmup();
        String path = "test-q-" + Time.uniqueId();
        AtomicLong lastRead = new AtomicLong();
        Thread reader = new Thread(() -> {
            try (ChronicleQueue q = this.createQueue(path);){
                ExcerptTailer tailer = q.createTailer().toEnd();
                long time = System.currentTimeMillis();
                while (running) {
                    Jvm.safepoint();
                    if (!tailer.peekDocument()) {
                        long now = System.currentTimeMillis();
                        if (now == time) continue;
                        time = now;
                    }
                    DocumentContext dc = tailer.readingDocument(false);
                    Throwable throwable = null;
                    try {
                        if (!dc.isPresent()) {
                            Jvm.safepoint();
                            continue;
                        }
                        Jvm.safepoint();
                        Bytes bytes = dc.wire().bytes();
                        long count = bytes.readLong();
                        while (bytes.readRemaining() > 7L) {
                            bytes.readLong();
                        }
                        lastRead.set(count);
                        Jvm.safepoint();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                        continue;
                    }
                    Jvm.safepoint();
                }
            }
        });
        reader.setDaemon(true);
        reader.start();
        Jvm.pause((long)100L);
        long count = 0L;
        try (ChronicleQueue q = this.createQueue(path);){
            ExcerptAppender appender = q.acquireAppender();
            long start0 = System.currentTimeMillis();
            do {
                try (DocumentContext dc = appender.writingDocument();){
                    Bytes bytes = dc.wire().bytes();
                    bytes.writeLong(++count);
                    for (int i = 8; i < size; i += 8) {
                        bytes.writeLong(0L);
                    }
                }
                long start1 = System.nanoTime();
                do {
                    Thread.yield();
                } while (System.nanoTime() < start1 + (long)(sampleTime * 1000));
                long time1 = System.nanoTime() - start1;
                if (time1 > (long)(sampleTime * 1000 * 10)) {
                    System.out.println("Time paused = " + time1 / 1000L + " us");
                }
                if (lastRead.get() == count) continue;
                StackTraceElement[] stes = reader.getStackTrace();
                StringBuilder sb = new StringBuilder();
                sb.append(PROFILE_OF_THE_THREAD);
                Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stes);
                System.out.println(sb);
            } while (System.currentTimeMillis() < start0 + (long)(runTime * 1000));
        }
        running = false;
        IOTools.deleteDirWithFiles((String)path, (int)2);
    }

    protected ChronicleQueue createQueue(String path) {
        return SingleChronicleQueueBuilder.single((String)path).blockSize(0x100000).build();
    }

    static {
        System.setProperty("jvm.safepoint.enabled", "true");
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
    }
}

