/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public final class RollAtEndOfCycleTest
extends ChronicleQueueTestBase {
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());

    private static void assertQueueFileCount(Path path, long expectedCount) throws IOException {
        try (Stream<Path> list = Files.list(path);){
            long count = list.filter(p -> p.toString().endsWith(".cq4")).count();
            Assert.assertEquals((long)expectedCount, (long)count);
        }
    }

    @Test
    public void shouldRollAndAppendToNewFile() throws IOException {
        Assume.assumeFalse((boolean)Jvm.isArm());
        try (SingleChronicleQueue queue = this.createQueue();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)1, (w, i) -> w.int32(i.intValue()));
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext context = tailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 1L);
            this.clock.addAndGet(TimeUnit.SECONDS.toMillis(2L));
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            appender.writeDocument((Object)2, (w, i) -> w.int32(i.intValue()));
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 2L);
            context = tailer.readingDocument();
            var6_8 = null;
            try {
                Assert.assertTrue((boolean)context.isPresent());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var6_8 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            ExcerptTailer newTailer = queue.createTailer();
            int totalCount = 0;
            while (true) {
                DocumentContext context;
                if ((context = newTailer.readingDocument()).isPresent() && context.isData()) {
                    Assert.assertNotEquals((long)0L, (long)context.wire().read().int32());
                    ++totalCount;
                    continue;
                }
                if (!context.isPresent()) break;
            }
            Assert.assertEquals((long)2L, (long)totalCount);
        }
    }

    @Test
    public void shouldAppendToExistingQueueFile() throws IOException {
        try (SingleChronicleQueue queue = this.createQueue();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)1, (w, i) -> w.int32(i.intValue()));
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext context = tailer.readingDocument();){
                Assert.assertTrue((boolean)context.isPresent());
            }
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 1L);
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            appender.writeDocument((Object)2, (w, i) -> w.int32(i.intValue()));
            RollAtEndOfCycleTest.assertQueueFileCount(queue.path.toPath(), 1L);
            context = tailer.readingDocument();
            var6_8 = null;
            try {
                Assert.assertTrue((boolean)context.isPresent());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var6_8 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
        }
    }

    private SingleChronicleQueue createQueue() {
        return SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().timeProvider(this.clock::get).build();
    }
}

