/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.wire.MessageHistory;
import org.junit.After;
import org.junit.Before;

public class QueueTestCommon {
    private final Map<Predicate<ExceptionKey>, String> ignoredExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();
    private final Map<Predicate<ExceptionKey>, String> expectedExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();
    protected ThreadDump threadDump;
    protected Map<ExceptionKey, Integer> exceptions;
    protected boolean finishedNormally;

    @Before
    public void assumeFinishedNormally() {
        this.finishedNormally = true;
    }

    @Before
    public void clearMessageHistory() {
        MessageHistory.get().reset();
    }

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptions = Jvm.recordExceptions();
    }

    public void ignoreException(String message) {
        this.ignoreException(k -> QueueTestCommon.contains(k.message, message) || k.throwable != null && QueueTestCommon.contains(k.throwable.getMessage(), message), message);
    }

    static boolean contains(String text, String message) {
        return text != null && text.contains(message);
    }

    public void expectException(String message) {
        this.expectException(k -> QueueTestCommon.contains(k.message, message) || k.throwable != null && QueueTestCommon.contains(k.throwable.getMessage(), message), message);
    }

    public void ignoreException(Predicate<ExceptionKey> predicate, String description) {
        this.ignoredExceptions.put(predicate, description);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.expectedExceptions.put(predicate, description);
    }

    public void checkExceptions() {
        if (OS.isWindows()) {
            this.ignoreException("Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write");
        }
        for (Map.Entry<Predicate<ExceptionKey>, String> expectedException : this.expectedExceptions.entrySet()) {
            if (!this.exceptions.keySet().removeIf(expectedException.getKey())) {
                throw new AssertionError((Object)("No error for " + expectedException.getValue()));
            }
        }
        this.expectedExceptions.clear();
        for (Map.Entry<Predicate<ExceptionKey>, String> ignoredException : this.ignoredExceptions.entrySet()) {
            if (this.exceptions.keySet().removeIf(ignoredException.getKey())) continue;
            Slf4jExceptionHandler.DEBUG.on(this.getClass(), "Ignored " + ignoredException.getValue());
        }
        this.ignoredExceptions.clear();
        for (String msg : "Shrinking ,Allocation of , ms to add mapping for ,jar to the classpath, ms to pollDiskSpace for , us to linearScan by position from ,File released ,Overriding roll length from existing metadata, was 3600000, overriding to 86400000   ".split(",")) {
            this.exceptions.keySet().removeIf(e -> e.message.contains(msg));
        }
        if (Jvm.hasException(this.exceptions)) {
            String msg = this.exceptions.size() + " exceptions were detected: " + this.exceptions.keySet().stream().map(ek -> ek.message).collect(Collectors.joining(", "));
            Jvm.dumpException(this.exceptions);
            Jvm.resetExceptionHandlers();
            throw new AssertionError((Object)msg);
        }
    }

    @After
    public void afterChecks() {
        this.preAfter();
        SystemTimeProvider.CLOCK = SystemTimeProvider.INSTANCE;
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        System.gc();
        AbstractCloseable.waitForCloseablesToClose((long)1000L);
        if (this.finishedNormally) {
            this.assertReferencesReleased();
            this.checkThreadDump();
            this.checkExceptions();
        }
        this.tearDown();
    }

    protected void preAfter() {
    }

    protected void tearDown() {
    }
}

