/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.CommonMappedBytes;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkedMappedBytes
extends CommonMappedBytes {
    public ChunkedMappedBytes(@NotNull MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected ChunkedMappedBytes(@NotNull MappedFile mappedFile, String name) throws IllegalStateException {
        super(mappedFile, name);
    }

    @Override
    @NotNull
    public ChunkedMappedBytes write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws IllegalStateException, BufferOverflowException {
        Longs.requireNonNegative(offsetInRDO);
        ObjectUtils.requireNonNull(byteArray);
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        this.throwExceptionIfClosed();
        long wp = offsetInRDO;
        if (length + offset > byteArray.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + byteArray.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        int remaining = length;
        MappedBytesStore bytesStore = this.acquireNextByteStore(wp, false);
        while (remaining > 0) {
            long safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= (long)remaining) {
                bytesStore.write(wp, byteArray, offset, remaining);
                return this;
            }
            bytesStore.write(wp, byteArray, offset, (int)safeCopySize);
            offset = (int)((long)offset + safeCopySize);
            remaining = (int)((long)remaining - safeCopySize);
            bytesStore = this.acquireNextByteStore0(wp += safeCopySize, false);
        }
        return this;
    }

    @Override
    @NotNull
    public ChunkedMappedBytes write(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        long safeCopySize;
        Longs.requireNonNegative(writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(readOffset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfClosed();
        long wp = writeOffset;
        if (length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        MappedBytesStore bytesStore = this.acquireNextByteStore(wp, false);
        for (long remaining = length; remaining > 0L; remaining -= safeCopySize) {
            safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= remaining) {
                bytesStore.write(wp, bytes, readOffset, remaining);
                return this;
            }
            bytesStore.write(wp, bytes, readOffset, safeCopySize);
            readOffset += safeCopySize;
            bytesStore = this.acquireNextByteStore0(wp += safeCopySize, false);
        }
        return this;
    }

    private long copySize(long writePosition) {
        long size = this.mappedFile.chunkSize();
        return size - writePosition % size;
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(long position, long remaining) throws BufferUnderflowException, IllegalStateException {
        long limit = position + remaining;
        this.acquireNextByteStore(position, true);
        try {
            if (this.writeLimit < limit) {
                this.writeLimit(limit);
            }
            if (Jvm.isAssertEnabled()) {
                this.readLimit(limit);
            } else {
                this.uncheckedWritePosition(limit);
            }
            return this.readPosition(position);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> readPosition(long position) throws BufferUnderflowException, IllegalStateException {
        if (this.bytesStore.inside(position)) {
            return super.readPosition(position);
        }
        this.acquireNextByteStore0(position, true);
        return this;
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException, IllegalStateException {
        Longs.requireNonNegative(offset);
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset)) {
            bytesStore = this.acquireNextByteStore0(offset, true);
        }
        return bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForRead(long offset, int buffer) throws UnsupportedOperationException, BufferUnderflowException, IllegalStateException {
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset, buffer)) {
            bytesStore = this.acquireNextByteStore0(offset, true);
        }
        return bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException, BufferOverflowException, IllegalStateException {
        Longs.requireNonNegative(offset);
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset)) {
            bytesStore = this.acquireNextByteStore0(offset, true);
        }
        return bytesStore.addressForWrite(offset);
    }

    @Override
    protected void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException, IllegalStateException {
        BytesStore bytesStore = this.bytesStore;
        long check = adding >= 0L ? offset : offset + adding;
        if (!bytesStore.inside(check, adding)) {
            this.acquireNextByteStore0(offset, false);
        }
        super.readCheckOffset(offset, adding, given);
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (offset + adding < this.start() || offset > this.mappedFile.capacity() - adding) {
            throw this.writeBufferOverflowException0(offset);
        }
        BytesStore bytesStore = this.bytesStore;
        if (adding > 0L && !bytesStore.inside(offset, this.checkSize0(adding - 1L))) {
            this.acquireNextByteStore0(offset + adding - 1L, false);
            if (!this.bytesStore.inside(offset, this.checkSize0(adding - 1L))) {
                throw new DecoratedBufferUnderflowException(String.format("Acquired the next BytesStore, but still not room to add %d when realCapacity %d", adding, this.bytesStore.realCapacity()));
            }
        }
    }

    private long checkSize0(long adding) {
        if (adding < 0L || adding > 0x7FFFFFFFFFFFFFF0L) {
            throw new IllegalArgumentException("Invalid size " + adding);
        }
        return adding;
    }

    @Override
    public void ensureCapacity(long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (desiredCapacity > this.capacity()) {
            throw new DecoratedBufferOverflowException("Cannot extend capacity beyond " + this.capacity());
        }
        if (desiredCapacity > this.writePosition()) {
            long adding = desiredCapacity - this.writePosition();
            if (!bytesStore.inside(this.writePosition(), this.checkSize0(adding))) {
                this.acquireNextByteStore0(this.writePosition() + adding, false);
            }
        }
    }

    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(this.writePosition(), Math.min(128L, bytesToSkip));
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @NotNull
    private BufferOverflowException writeBufferOverflowException0(long offset) {
        BufferOverflowException exception = new BufferOverflowException();
        exception.initCause(new IllegalArgumentException("Offset out of bound " + offset));
        return exception;
    }

    @NotNull
    private MappedBytesStore acquireNextByteStore(long offset, boolean set) throws IllegalStateException {
        BytesStore bytesStore = this.bytesStore;
        if (bytesStore.inside(offset)) {
            return (MappedBytesStore)bytesStore;
        }
        this.throwExceptionIfReleased();
        return this.acquireNextByteStore0(offset, set);
    }

    @NotNull
    private synchronized MappedBytesStore acquireNextByteStore0(long offset, boolean set) throws IllegalStateException {
        MappedBytesStore newBS;
        this.throwExceptionIfClosed();
        @Nullable BytesStore oldBS = this.bytesStore;
        try {
            newBS = this.mappedFile.acquireByteStore(this, offset, oldBS);
            if (newBS != oldBS) {
                this.bytesStore((BytesStore)newBS);
                if (oldBS != null) {
                    oldBS.release(this);
                }
                if (this.lastActualSize < newBS.maximumLimit) {
                    this.lastActualSize = newBS.maximumLimit;
                }
            }
            assert (newBS.reservedBy(this));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (set) {
            try {
                if (this.writeLimit() < this.readPosition) {
                    this.writeLimit(this.readPosition);
                }
                if (this.readLimit() < this.readPosition) {
                    this.readLimit(this.readPosition);
                }
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
            this.readPosition = offset;
        }
        return newBS;
    }

    @Override
    @NotNull
    public Bytes<Void> readSkip(long bytesToSkip) throws BufferUnderflowException, IllegalStateException {
        if (this.readPosition + bytesToSkip > this.readLimit()) {
            throw new BufferUnderflowException();
        }
        long check = bytesToSkip >= 0L ? this.readPosition : this.readPosition + bytesToSkip;
        BytesStore bytesStore = this.bytesStore;
        if (bytesToSkip != (long)((int)bytesToSkip) || !bytesStore.inside(this.readPosition, (int)bytesToSkip)) {
            this.acquireNextByteStore0(check, false);
        }
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> clear() throws IllegalStateException {
        long start;
        this.readPosition = start = 0L;
        this.uncheckedWritePosition(start);
        this.writeLimit = this.mappedFile.capacity();
        if (this.writeLimit == 0x101010CL) {
            throw new AssertionError();
        }
        return this;
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        Longs.requireNonNegative(offset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfClosed();
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (length > 0L) {
            if (bytes.isDirectMemory()) {
                long fromAddress = bytes.addressForRead(offset);
                if (length <= bytes.bytesStore().realCapacity() - offset) {
                    this.acquireNextByteStore(this.writePosition(), false);
                    if (this.bytesStore.realCapacity() - this.writePosition() >= length) {
                        this.rawCopy(length, fromAddress);
                        return this;
                    }
                }
            }
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    void rawCopy(long length, long fromAddress) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfReleased();
        OS.memory().copyMemory(fromAddress, this.addressForWritePosition(), length);
        this.uncheckedWritePosition(this.writePosition() + length);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset, 0L)) {
            bytesStore = this.acquireNextByteStore0(offset, false);
        }
        return bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset, 1L)) {
            bytesStore = this.acquireNextByteStore0(offset + 1L, false);
        }
        return bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset, 3L)) {
            bytesStore = this.acquireNextByteStore0(offset + 3L, false);
        }
        return bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset, 7L)) {
            bytesStore = this.acquireNextByteStore0(offset + 7L, false);
        }
        return bytesStore.readVolatileLong(offset);
    }

    @Override
    public int peekUnsignedByte() throws IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(this.readPosition, 0L)) {
            bytesStore = this.acquireNextByteStore0(this.readPosition, false);
        }
        try {
            return this.readPosition >= this.writePosition() ? -1 : bytesStore.readUnsignedByte(this.readPosition);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int peekUnsignedByte(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(offset, 0L)) {
            bytesStore = this.acquireNextByteStore0(offset + 0L, false);
        }
        return offset >= this.readLimit() ? -1 : bytesStore.peekUnsignedByte(offset);
    }

    @Override
    public int peekVolatileInt() throws IllegalStateException {
        BytesStore bytesStore = this.bytesStore;
        if (!bytesStore.inside(this.readPosition, 3L)) {
            bytesStore = this.acquireNextByteStore0(this.readPosition + 3L, true);
        }
        MappedBytesStore mbs = (MappedBytesStore)bytesStore;
        long address = mbs.address + mbs.translate(this.readPosition);
        @Nullable Memory memory = mbs.memory;
        return memory.readVolatileInt(address);
    }

    @Override
    @NotNull
    public Bytes<Void> appendUtf8(@NotNull char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        char c;
        int i;
        block5: {
            ObjectUtils.requireNonNull(chars);
            this.throwExceptionIfClosed();
            if (this.writePosition() < 0L || this.writePosition() > this.capacity() - 1L + (long)length) {
                throw this.writeBufferOverflowException0(this.writePosition());
            }
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    long oldPosition = this.writePosition();
                    BytesStore bytesStore = this.bytesStore;
                    if ((this.writePosition() & 0xFFL) == 0L && !bytesStore.inside(this.writePosition(), (long)(length - i) * 3L)) {
                        bytesStore = this.acquireNextByteStore0(this.writePosition(), false);
                    }
                    this.uncheckedWritePosition(this.writePosition() + 1L);
                    bytesStore.writeByte(oldPosition, (byte)c);
                    continue;
                }
                break block5;
            }
            return this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return this;
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (offset < 0L || offset > this.mappedFile.capacity() - 8L) {
            throw this.writeBufferOverflowException0(offset);
        }
        BytesStore bytesStore = this.bytesStore;
        if (bytesStore.start() > offset || offset + 8L > bytesStore.safeLimit()) {
            bytesStore = this.acquireNextByteStore0(offset, false);
        }
        return bytesStore.compareAndSwapLong(offset, expected, value);
    }
}

