/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal.migration;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.io.ReferenceOwner;

public final class HashCodeEqualsUtil {
    private HashCodeEqualsUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean contentEquals(BytesStore<?, ?> bytes, Object other) {
        if (bytes == other) {
            return true;
        }
        if (!(other instanceof BytesStore)) {
            return false;
        }
        BytesStore otherByteStore = (BytesStore)other;
        ReferenceOwner owner = ReferenceOwner.temporary("contentEquals");
        bytes.reserve(owner);
        try {
            otherByteStore.reserve(owner);
            long remaining = bytes.readRemaining();
            boolean bl = otherByteStore.readRemaining() == remaining && BytesInternal.contentEqual(bytes, otherByteStore);
            otherByteStore.release(owner);
            return bl;
            {
                catch (IllegalStateException e) {
                    boolean bl2 = false;
                    otherByteStore.release(owner);
                    bytes.release(owner);
                    return bl2;
                    {
                        catch (Throwable throwable) {
                            otherByteStore.release(owner);
                            throw throwable;
                        }
                    }
                }
            }
        }
        finally {
            bytes.release(owner);
        }
    }

    public static int hashCode(BytesStore<?, ?> bytes) {
        ReferenceOwner owner = ReferenceOwner.temporary("hashCode");
        bytes.reserve(owner);
        try {
            int n = BytesStoreHash.hash32(bytes);
            return n;
        }
        finally {
            bytes.release(owner);
        }
    }
}

