/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.reader.Reader;
import net.openhft.chronicle.queue.reader.comparator.BinarySearchComparator;
import net.openhft.chronicle.wire.ServicesTimestampLongConverter;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class TimestampComparator
implements BinarySearchComparator {
    static final String TS = "timestamp";
    private long ts;

    public void accept(Reader reader) {
        this.ts = ServicesTimestampLongConverter.INSTANCE.parse((CharSequence)Objects.requireNonNull(reader.arg()));
    }

    public Wire wireKey() {
        Wire rv = (Wire)WireType.TEXT.apply((Object)Bytes.elasticHeapByteBuffer());
        rv.writeEventName((CharSequence)TS).int64(this.ts);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Wire wire1, Wire wire2) {
        long readPositionO1 = wire1.bytes().readPosition();
        long readPositionO2 = wire2.bytes().readPosition();
        try {
            long key1 = wire1.read(TS).int64();
            long key2 = wire2.read(TS).int64();
            int n = Long.compare(key1, key2);
            return n;
        }
        finally {
            wire1.bytes().readPosition(readPositionO1);
            wire2.bytes().readPosition(readPositionO2);
        }
    }
}

