/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DefaultCycleCalculator;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollCyclesTest
extends QueueTestCommon {
    private static final long NO_EPOCH_OFFSET = 0L;
    private static final long SOME_EPOCH_OFFSET = 629L;
    private static final RollCycles[] TEST_DATA = RollCycles.values();
    private final RollCycles cycle;
    private final AtomicLong clock = new AtomicLong();
    private final TimeProvider timeProvider = this.clock::get;

    public RollCyclesTest(String cycleName, RollCycles cycle) {
        this.cycle = cycle;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (RollCycles testDatum : TEST_DATA) {
            data.add(new Object[]{testDatum.name(), testDatum});
        }
        return data;
    }

    private static TimeProvider withDelta(TimeProvider delegate, long deltaMillis) {
        return () -> delegate.currentTimeMillis() + deltaMillis;
    }

    private static TimeProvider plusOneMillisecond(TimeProvider delegate) {
        return () -> delegate.currentTimeMillis() + 1L;
    }

    private static TimeProvider minusOneMillisecond(TimeProvider delegate) {
        return () -> delegate.currentTimeMillis() - 1L;
    }

    @Test
    public void shouldBe32bitShifted() {
        long factor = (long)this.cycle.defaultIndexCount() * (long)this.cycle.defaultIndexCount() * (long)this.cycle.defaultIndexSpacing();
        if (factor < 0x100000000L) {
            factor = 0x100000000L;
        }
        Assert.assertEquals((long)factor, (long)this.cycle.toIndex(1, 0L));
    }

    @Test
    public void shouldDetermineCurrentCycle() {
        this.assertCycleRollTimes(0L, RollCyclesTest.withDelta(this.timeProvider, 0L));
    }

    @Test
    public void shouldTakeEpochIntoAccoutWhenCalculatingCurrentCycle() {
        this.assertCycleRollTimes(629L, RollCyclesTest.withDelta(this.timeProvider, 629L));
    }

    @Test
    public void shouldHandleReasonableDateRange() {
        int currentCycle = DefaultCycleCalculator.INSTANCE.currentCycle((RollCycle)this.cycle, this.timeProvider, 0L);
        long nowMillis = 1500000000000L;
        while (nowMillis < 2000000000000L) {
            this.clock.set(nowMillis);
            long index = this.cycle.toIndex(currentCycle, 0L);
            Assert.assertEquals((long)currentCycle, (long)this.cycle.toCycle(index));
            nowMillis = (long)((double)nowMillis + 3.0E10);
        }
    }

    private void assertCycleRollTimes(long epochOffset, TimeProvider timeProvider) {
        long currentTime = System.currentTimeMillis();
        long currentTimeAtStartOfCycle = currentTime - currentTime % (long)this.cycle.lengthInMillis();
        this.clock.set(currentTimeAtStartOfCycle);
        int startCycle = this.cycle.current(timeProvider, epochOffset);
        this.clock.addAndGet(this.cycle.lengthInMillis());
        Assert.assertEquals((long)(startCycle + 1), (long)this.cycle.current(timeProvider, epochOffset));
        Assert.assertEquals((long)(startCycle + 1), (long)this.cycle.current(RollCyclesTest.plusOneMillisecond(timeProvider), epochOffset));
        Assert.assertEquals((long)startCycle, (long)this.cycle.current(RollCyclesTest.minusOneMillisecond(timeProvider), epochOffset));
        this.clock.addAndGet(this.cycle.lengthInMillis());
        Assert.assertEquals((long)(startCycle + 2), (long)this.cycle.current(timeProvider, epochOffset));
        Assert.assertEquals((long)(startCycle + 2), (long)this.cycle.current(RollCyclesTest.plusOneMillisecond(timeProvider), epochOffset));
        Assert.assertEquals((long)(startCycle + 1), (long)this.cycle.current(RollCyclesTest.minusOneMillisecond(timeProvider), epochOffset));
    }
}

