/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.TimeProvider;

public class SetTimeProvider
extends AtomicLong
implements TimeProvider {
    private long autoIncrement = 0L;

    public SetTimeProvider() {
        this(0L);
    }

    public SetTimeProvider(long initialNanos) {
        super(initialNanos);
    }

    public SetTimeProvider(String timestamp) {
        super(SetTimeProvider.initialNanos(timestamp));
    }

    public SetTimeProvider(Instant instant) {
        super(SetTimeProvider.initialNanos(instant));
    }

    static long initialNanos(String timestamp) {
        LocalDateTime dateTime = LocalDateTime.parse(timestamp.replace("/", "-"));
        return SetTimeProvider.initialNanos(dateTime.toInstant(ZoneOffset.UTC));
    }

    static long initialNanos(Instant instant) {
        long initialNanos = instant.getEpochSecond() * 1000000000L;
        if (instant.isSupported(ChronoField.NANO_OF_SECOND)) {
            initialNanos += instant.getLong(ChronoField.NANO_OF_SECOND);
        }
        return initialNanos;
    }

    public SetTimeProvider autoIncrement(long autoIncrement, TimeUnit timeUnit) {
        this.autoIncrement = timeUnit.toNanos(autoIncrement);
        return this;
    }

    public void currentTimeMillis(long millis) throws IllegalArgumentException {
        this.currentTimeNanos(TimeUnit.MILLISECONDS.toNanos(millis));
    }

    @Override
    public long currentTimeMillis() {
        return this.currentTimeNanos() / 1000000L;
    }

    public void currentTimeMicros(long micros) throws IllegalArgumentException {
        this.currentTimeNanos(TimeUnit.MICROSECONDS.toNanos(micros));
    }

    @Override
    public long currentTimeMicros() {
        return this.currentTimeNanos() / 1000L;
    }

    public void currentTimeNanos(long nanos) throws IllegalArgumentException {
        if (nanos < this.get()) {
            throw new IllegalArgumentException("Cannot go back in time!");
        }
        this.set(nanos);
    }

    @Override
    public long currentTimeNanos() {
        return this.getAndAdd(this.autoIncrement);
    }

    @Override
    public long currentTime(TimeUnit unit) {
        return unit.convert(this.currentTimeNanos(), TimeUnit.NANOSECONDS);
    }

    public SetTimeProvider advanceMillis(long millis) {
        this.advanceNanos(TimeUnit.MILLISECONDS.toNanos(millis));
        return this;
    }

    public SetTimeProvider advanceMicros(long micros) {
        this.advanceNanos(TimeUnit.MICROSECONDS.toNanos(micros));
        return this;
    }

    public SetTimeProvider advanceNanos(long nanos) {
        this.addAndGet(nanos);
        return this;
    }

    @Override
    public String toString() {
        return "SetTimeProvider{autoIncrement=" + this.autoIncrement + ", nanoTime=" + this.get() + '}';
    }
}

